/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.contextmanagement;

import java.util.List;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.action.contextmanagement.ContextManagementTemplateService;
import org.opensearch.ml.common.contextmanager.ContextManagementTemplate;
import org.opensearch.ml.common.transport.contextmanagement.MLListContextManagementTemplatesRequest;
import org.opensearch.ml.common.transport.contextmanagement.MLListContextManagementTemplatesResponse;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class ListContextManagementTemplatesTransportAction
extends HandledTransportAction<MLListContextManagementTemplatesRequest, MLListContextManagementTemplatesResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(ListContextManagementTemplatesTransportAction.class);
    private final Client client;
    private final ContextManagementTemplateService contextManagementTemplateService;

    @Inject
    public ListContextManagementTemplatesTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, ContextManagementTemplateService contextManagementTemplateService) {
        super("cluster:admin/opensearch/ml/context_management/list", transportService, actionFilters, MLListContextManagementTemplatesRequest::new);
        this.client = client;
        this.contextManagementTemplateService = contextManagementTemplateService;
    }

    protected void doExecute(Task task, MLListContextManagementTemplatesRequest request, ActionListener<MLListContextManagementTemplatesResponse> listener) {
        try {
            log.debug("Listing context management templates from: {} size: {}", (Object)request.getFrom(), (Object)request.getSize());
            this.contextManagementTemplateService.listTemplates(request.getFrom(), request.getSize(), (ActionListener<List<ContextManagementTemplate>>)ActionListener.wrap(templates -> {
                log.debug("Successfully retrieved {} context management templates", (Object)templates.size());
                listener.onResponse((Object)new MLListContextManagementTemplatesResponse(templates, (long)templates.size()));
            }, exception -> {
                log.error("Error listing context management templates", (Throwable)exception);
                listener.onFailure(exception);
            }));
        }
        catch (Exception e) {
            log.error("Unexpected error listing context management templates", (Throwable)e);
            listener.onFailure(e);
        }
    }
}

