/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.data;

import com.oracle.labs.mlrg.olcut.config.Option;
import com.oracle.labs.mlrg.olcut.config.Options;
import com.oracle.labs.mlrg.olcut.util.Pair;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Locale;
import java.util.logging.Logger;
import org.tribuo.DataSource;
import org.tribuo.Dataset;
import org.tribuo.FeatureMap;
import org.tribuo.ImmutableDataset;
import org.tribuo.Model;
import org.tribuo.MutableDataset;
import org.tribuo.Output;
import org.tribuo.OutputFactory;
import org.tribuo.OutputInfo;
import org.tribuo.data.columnar.RowProcessor;
import org.tribuo.data.csv.CSVDataSource;
import org.tribuo.data.csv.CSVLoader;
import org.tribuo.data.text.impl.SimpleTextDataSource;
import org.tribuo.data.text.impl.TextFeatureExtractorImpl;
import org.tribuo.data.text.impl.TokenPipeline;
import org.tribuo.dataset.MinimumCardinalityDataset;
import org.tribuo.datasource.LibSVMDataSource;
import org.tribuo.transform.TransformationMap;
import org.tribuo.transform.transformations.LinearScalingTransformation;
import org.tribuo.util.tokens.Tokenizer;
import org.tribuo.util.tokens.impl.BreakIteratorTokenizer;

public final class DataOptions
implements Options {
    private static final Logger logger = Logger.getLogger(DataOptions.class.getName());
    @Option(longName="hashing-dimension", usage="Hashing dimension used for standard text format.")
    public int hashDim = 0;
    @Option(longName="ngram", usage="Ngram size to generate when using standard text format.")
    public int ngram = 2;
    @Option(longName="term-counting", usage="Use term counts instead of boolean when using the standard text format.")
    public boolean termCounting;
    @Option(charName=102, longName="model-output-path", usage="Path to serialize model to.")
    public Path outputPath;
    @Option(charName=114, longName="seed", usage="RNG seed.")
    public long seed = 12345L;
    @Option(charName=115, longName="input-format", usage="Loads the data using the specified format.")
    public InputFormat inputFormat = InputFormat.LIBSVM;
    @Option(longName="csv-response-name", usage="Response name in the csv file.")
    public String csvResponseName;
    @Option(longName="csv-delimiter", usage="Delimiter")
    public Delimiter delimiter = Delimiter.COMMA;
    @Option(longName="csv-quote-char", usage="Quote character in the CSV file.")
    public char csvQuoteChar = (char)34;
    @Option(longName="columnar-row-processor", usage="The name of the row processor from the config file.")
    public RowProcessor<?> rowProcessor;
    @Option(longName="min-count", usage="Minimum cardinality of the features.")
    public int minCount = 0;
    @Option(charName=117, longName="training-file", usage="Path to the training file.")
    public Path trainingPath;
    @Option(charName=118, longName="testing-file", usage="Path to the testing file.")
    public Path testingPath;
    @Option(longName="scale-features", usage="Scales the features to the range 0-1 independently.")
    public boolean scaleFeatures;
    @Option(longName="scale-including-zeros", usage="Includes implicit zeros in the scale range calculation.")
    public boolean scaleIncZeros;

    public String getOptionsDescription() {
        return "Options for loading and processing train and test data.";
    }

    /*
     * Unable to fully structure code
     */
    public <T extends Output<T>> Pair<Dataset<T>, Dataset<T>> load(OutputFactory<T> outputFactory) throws IOException {
        DataOptions.logger.info(String.format("Loading data from %s", new Object[]{this.trainingPath}));
        switch (1.$SwitchMap$org$tribuo$data$DataOptions$InputFormat[this.inputFormat.ordinal()]) {
            case 1: {
                DataOptions.logger.info("Deserialising dataset from " + this.trainingPath);
                try {
                    ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.trainingPath.toFile())));
                    var6_4 = null;
                    oits = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.testingPath.toFile())));
                    var8_11 = null;
                    try {
                        tmp = (Dataset)ois.readObject();
                        train = tmp;
                        if (this.minCount > 0) {
                            DataOptions.logger.info("Found " + train.getFeatureIDMap().size() + " features");
                            DataOptions.logger.info("Removing features that occur fewer than " + this.minCount + " times.");
                            train = new MinimumCardinalityDataset((Dataset)train, this.minCount);
                        }
                        DataOptions.logger.info(String.format("Loaded %d training examples for %s", new Object[]{train.size(), train.getOutputs().toString()}));
                        DataOptions.logger.info("Found " + train.getFeatureIDMap().size() + " features, and " + train.getOutputInfo().size() + " response dimensions");
                        deserTest = (Dataset)oits.readObject();
                        test = new ImmutableDataset((Iterable)deserTest, deserTest.getSourceProvenance(), deserTest.getOutputFactory(), train.getFeatureIDMap(), train.getOutputIDInfo(), true);
                    }
                    catch (Throwable tmp) {
                        var8_11 = tmp;
                        throw tmp;
                    }
                    finally {
                        if (oits != null) {
                            if (var8_11 != null) {
                                try {
                                    oits.close();
                                }
                                catch (Throwable tmp) {
                                    var8_11.addSuppressed(tmp);
                                }
                            } else {
                                oits.close();
                            }
                        }
                    }
                    if (ois == null) break;
                    if (var6_4 == null) ** GOTO lbl45
                    try {
                        ois.close();
                    }
                    catch (Throwable oits) {
                        var6_4.addSuppressed(oits);
                    }
                    break;
lbl45:
                    // 1 sources

                    ois.close();
                    ** break;
                    catch (Throwable oits) {
                        try {
                            var6_4 = oits;
                            throw oits;
                        }
                        catch (Throwable var13_25) {
                            if (ois != null) {
                                if (var6_4 != null) {
                                    try {
                                        ois.close();
                                    }
                                    catch (Throwable var14_27) {
                                        var6_4.addSuppressed(var14_27);
                                    }
                                } else {
                                    ois.close();
                                }
                            }
                            throw var13_25;
lbl62:
                            // 1 sources

                            break;
                        }
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Unknown class in serialised files", e);
                }
            }
            case 2: {
                trainSVMSource = new LibSVMDataSource(this.trainingPath, outputFactory);
                train = new MutableDataset((DataSource)trainSVMSource);
                zeroIndexed = trainSVMSource.isZeroIndexed();
                maxFeatureID = trainSVMSource.getMaxFeatureID();
                if (this.minCount > 0) {
                    DataOptions.logger.info("Removing features that occur fewer than " + this.minCount + " times.");
                    train = new MinimumCardinalityDataset((Dataset)train, this.minCount);
                }
                DataOptions.logger.info(String.format("Loaded %d training examples for %s", new Object[]{train.size(), train.getOutputs().toString()}));
                DataOptions.logger.info("Found " + train.getFeatureIDMap().size() + " features, and " + train.getOutputInfo().size() + " response dimensions");
                test = new ImmutableDataset((DataSource)new LibSVMDataSource(this.testingPath, outputFactory, zeroIndexed, maxFeatureID), (FeatureMap)train.getFeatureIDMap(), (OutputInfo)train.getOutputIDInfo(), false);
                break;
            }
            case 3: {
                extractor = this.hashDim > 0 ? new TextFeatureExtractorImpl<T>(new TokenPipeline((Tokenizer)new BreakIteratorTokenizer(Locale.US), this.ngram, this.termCounting, this.hashDim)) : new TextFeatureExtractorImpl<T>(new TokenPipeline((Tokenizer)new BreakIteratorTokenizer(Locale.US), this.ngram, this.termCounting));
                trainSource = new SimpleTextDataSource<T>(this.trainingPath, outputFactory, extractor);
                train = new MutableDataset(trainSource);
                if (this.minCount > 0) {
                    DataOptions.logger.info("Removing features that occur fewer than " + this.minCount + " times.");
                    train = new MinimumCardinalityDataset((Dataset)train, this.minCount);
                }
                DataOptions.logger.info(String.format("Loaded %d training examples for %s", new Object[]{train.size(), train.getOutputs().toString()}));
                DataOptions.logger.info("Found " + train.getFeatureIDMap().size() + " features, and " + train.getOutputInfo().size() + " response dimensions");
                testSource = new SimpleTextDataSource<T>(this.testingPath, outputFactory, extractor);
                test = new ImmutableDataset(testSource, (FeatureMap)train.getFeatureIDMap(), (OutputInfo)train.getOutputIDInfo(), false);
                break;
            }
            case 4: {
                if (this.csvResponseName == null) {
                    throw new IllegalArgumentException("Please supply a response column name");
                }
                separator = this.delimiter.value;
                loader = new CSVLoader<T>(separator, outputFactory);
                train = new MutableDataset(loader.loadDataSource(this.trainingPath, this.csvResponseName));
                DataOptions.logger.info(String.format("Loaded %d training examples for %s", new Object[]{train.size(), train.getOutputs().toString()}));
                DataOptions.logger.info("Found " + train.getFeatureIDMap().size() + " features, and " + train.getOutputInfo().size() + " response dimensions");
                test = new MutableDataset(loader.loadDataSource(this.testingPath, this.csvResponseName));
                break;
            }
            case 5: {
                if (this.rowProcessor == null) {
                    throw new IllegalArgumentException("Please supply a RowProcessor");
                }
                rowOutputFactory = this.rowProcessor.getResponseProcessor().getOutputFactory();
                if (!rowOutputFactory.equals(outputFactory)) {
                    throw new IllegalArgumentException("The RowProcessor doesn't use the same kind of OutputFactory as the one supplied. RowProcessor has " + rowOutputFactory.getClass().getSimpleName() + ", supplied " + outputFactory.getClass().getName());
                }
                typedRowProcessor = this.rowProcessor;
                separator = this.delimiter.value;
                train = new MutableDataset(new CSVDataSource<?>(this.trainingPath, typedRowProcessor, true, separator, this.csvQuoteChar));
                DataOptions.logger.info(String.format("Loaded %d training examples for %s", new Object[]{train.size(), train.getOutputs().toString()}));
                DataOptions.logger.info("Found " + train.getFeatureIDMap().size() + " features, and " + train.getOutputInfo().size() + " response dimensions");
                test = new MutableDataset(new CSVDataSource<?>(this.testingPath, typedRowProcessor, true, separator, this.csvQuoteChar));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported input format " + (Object)this.inputFormat);
            }
        }
        DataOptions.logger.info(String.format("Loaded %d testing examples", new Object[]{test.size()}));
        if (this.scaleFeatures) {
            DataOptions.logger.info("Fitting feature scaling");
            map = new TransformationMap(Collections.singletonList(new LinearScalingTransformation()));
            transformers = train.createTransformers(map, this.scaleIncZeros);
            DataOptions.logger.info("Applying scaling to training dataset");
            train = transformers.transformDataset((Dataset)train);
            DataOptions.logger.info("Applying scaling to testing dataset");
            test = transformers.transformDataset((Dataset)test);
        }
        return new Pair((Object)train, (Object)test);
    }

    public <T extends Output<T>> void saveModel(Model<T> model) throws IOException {
        try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(this.outputPath.toFile()));){
            oos.writeObject(model);
            logger.info("Serialized model to file: " + this.outputPath);
        }
    }

    public static enum Delimiter {
        COMMA(','),
        TAB('\t'),
        SEMICOLON(';');

        public final char value;

        private Delimiter(char value) {
            this.value = value;
        }
    }

    public static enum InputFormat {
        SERIALIZED,
        LIBSVM,
        TEXT,
        CSV,
        COLUMNAR;

    }
}

