/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.datetime;

import com.google.common.collect.ImmutableMap;
import java.text.ParsePosition;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opensearch.sql.data.model.ExprNullValue;
import org.opensearch.sql.data.model.ExprStringValue;
import org.opensearch.sql.data.model.ExprTimestampValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.expression.datetime.CalendarLookup;
import org.opensearch.sql.expression.function.FunctionProperties;

public class DateTimeFormatterUtil {
    private static final int SUFFIX_SPECIAL_START_TH = 11;
    private static final int SUFFIX_SPECIAL_END_TH = 13;
    private static final String SUFFIX_SPECIAL_TH = "th";
    private static final String NANO_SEC_FORMAT = "'%06d'";
    private static final Map<Integer, String> SUFFIX_CONVERTER = ImmutableMap.builder().put((Object)1, (Object)"st").put((Object)2, (Object)"nd").put((Object)3, (Object)"rd").build();
    public static final Map<String, DateTimeFormatHandler> DATE_HANDLERS = ImmutableMap.builder().put((Object)"%a", date -> "EEE").put((Object)"%b", date -> "LLL").put((Object)"%c", date -> "MM").put((Object)"%d", date -> "dd").put((Object)"%e", date -> "d").put((Object)"%H", date -> "HH").put((Object)"%h", date -> "hh").put((Object)"%I", date -> "hh").put((Object)"%i", date -> "mm").put((Object)"%j", date -> "DDD").put((Object)"%k", date -> "H").put((Object)"%l", date -> "h").put((Object)"%p", date -> "a").put((Object)"%M", date -> "LLLL").put((Object)"%m", date -> "MM").put((Object)"%r", date -> "hh:mm:ss a").put((Object)"%S", date -> "ss").put((Object)"%s", date -> "ss").put((Object)"%T", date -> "HH:mm:ss").put((Object)"%W", date -> "EEEE").put((Object)"%Y", date -> "yyyy").put((Object)"%y", date -> "yy").put((Object)"%D", date -> String.format(Locale.ROOT, "'%d%s'", date.getDayOfMonth(), DateTimeFormatterUtil.getSuffix(date.getDayOfMonth()))).put((Object)"%f", date -> String.format(Locale.ROOT, NANO_SEC_FORMAT, date.getNano() / 1000)).put((Object)"%w", date -> String.format(Locale.ROOT, "'%d'", date.getDayOfWeek().getValue())).put((Object)"%U", date -> String.format(Locale.ROOT, "'%d'", CalendarLookup.getWeekNumber(0, date.toLocalDate()))).put((Object)"%u", date -> String.format(Locale.ROOT, "'%d'", CalendarLookup.getWeekNumber(1, date.toLocalDate()))).put((Object)"%V", date -> String.format(Locale.ROOT, "'%d'", CalendarLookup.getWeekNumber(2, date.toLocalDate()))).put((Object)"%v", date -> String.format(Locale.ROOT, "'%d'", CalendarLookup.getWeekNumber(3, date.toLocalDate()))).put((Object)"%X", date -> String.format(Locale.ROOT, "'%d'", CalendarLookup.getYearNumber(2, date.toLocalDate()))).put((Object)"%x", date -> String.format(Locale.ROOT, "'%d'", CalendarLookup.getYearNumber(3, date.toLocalDate()))).build();
    private static final Map<String, DateTimeFormatHandler> TIME_HANDLERS = ImmutableMap.builder().put((Object)"%a", date -> null).put((Object)"%b", date -> null).put((Object)"%c", date -> "0").put((Object)"%d", date -> "00").put((Object)"%e", date -> "0").put((Object)"%H", date -> "HH").put((Object)"%h", date -> "hh").put((Object)"%I", date -> "hh").put((Object)"%i", date -> "mm").put((Object)"%j", date -> null).put((Object)"%k", date -> "H").put((Object)"%l", date -> "h").put((Object)"%p", date -> "a").put((Object)"%M", date -> null).put((Object)"%m", date -> "00").put((Object)"%r", date -> "hh:mm:ss a").put((Object)"%S", date -> "ss").put((Object)"%s", date -> "ss").put((Object)"%T", date -> "HH:mm:ss").put((Object)"%W", date -> null).put((Object)"%Y", date -> "0000").put((Object)"%y", date -> "00").put((Object)"%D", date -> null).put((Object)"%f", date -> String.format(Locale.ROOT, NANO_SEC_FORMAT, date.getNano() / 1000)).put((Object)"%w", date -> null).put((Object)"%U", date -> null).put((Object)"%u", date -> null).put((Object)"%V", date -> null).put((Object)"%v", date -> null).put((Object)"%X", date -> null).put((Object)"%x", date -> null).build();
    private static final Map<String, String> STR_TO_DATE_FORMATS = ImmutableMap.builder().put((Object)"%a", (Object)"EEE").put((Object)"%b", (Object)"LLL").put((Object)"%c", (Object)"M").put((Object)"%d", (Object)"d").put((Object)"%e", (Object)"d").put((Object)"%H", (Object)"H").put((Object)"%h", (Object)"H").put((Object)"%I", (Object)"h").put((Object)"%i", (Object)"m").put((Object)"%j", (Object)"DDD").put((Object)"%k", (Object)"H").put((Object)"%l", (Object)"h").put((Object)"%p", (Object)"a").put((Object)"%M", (Object)"LLLL").put((Object)"%m", (Object)"M").put((Object)"%r", (Object)"hh:mm:ss a").put((Object)"%S", (Object)"s").put((Object)"%s", (Object)"s").put((Object)"%T", (Object)"HH:mm:ss").put((Object)"%W", (Object)"EEEE").put((Object)"%Y", (Object)"u").put((Object)"%y", (Object)"uu").put((Object)"%f", (Object)"n").put((Object)"%D", (Object)"d").put((Object)"%w", (Object)"e").put((Object)"%U", (Object)"w").put((Object)"%u", (Object)"w").put((Object)"%V", (Object)"w").put((Object)"%v", (Object)"w").put((Object)"%X", (Object)"u").put((Object)"%x", (Object)"u").build();
    private static final Pattern pattern = Pattern.compile("%.");
    private static final Pattern CHARACTERS_WITH_NO_MOD_LITERAL_BEHIND_PATTERN = Pattern.compile("(?<!%)[a-zA-Z&&[^aydmshiHIMYDSEL]]+");
    private static final String MOD_LITERAL = "%";

    private DateTimeFormatterUtil() {
    }

    static StringBuffer getCleanFormat(ExprValue formatExpr) {
        return DateTimeFormatterUtil.getCleanFormat(formatExpr.stringValue());
    }

    public static StringBuffer getCleanFormat(String formatStr) {
        StringBuffer cleanFormat = new StringBuffer();
        Matcher m = CHARACTERS_WITH_NO_MOD_LITERAL_BEHIND_PATTERN.matcher(formatStr);
        while (m.find()) {
            m.appendReplacement(cleanFormat, String.format("'%s'", m.group()));
        }
        m.appendTail(cleanFormat);
        return cleanFormat;
    }

    public static ExprValue getFormattedString(ExprValue formatExpr, Map<String, DateTimeFormatHandler> handler, LocalDateTime datetime) {
        StringBuffer cleanFormat = DateTimeFormatterUtil.getCleanFormat(formatExpr);
        Matcher matcher = pattern.matcher(cleanFormat.toString());
        StringBuffer format = new StringBuffer();
        try {
            while (matcher.find()) {
                matcher.appendReplacement(format, handler.getOrDefault(matcher.group(), d -> String.format("'%s'", matcher.group().replaceFirst(MOD_LITERAL, ""))).getFormat(datetime));
            }
        }
        catch (Exception e) {
            return ExprNullValue.of();
        }
        matcher.appendTail(format);
        return new ExprStringValue(datetime.format(DateTimeFormatter.ofPattern(format.toString(), Locale.ENGLISH)));
    }

    public static String getFormattedDatetime(LocalDateTime datetime, String formatStr) {
        return DateTimeFormatterUtil.getFormattedString(new ExprStringValue(formatStr), DATE_HANDLERS, datetime).stringValue();
    }

    public static ExprValue getFormattedDate(ExprValue dateExpr, ExprValue formatExpr) {
        LocalDateTime date = dateExpr.timestampValue().atZone(ZoneOffset.UTC).toLocalDateTime();
        return DateTimeFormatterUtil.getFormattedString(formatExpr, DATE_HANDLERS, date);
    }

    public static ExprValue getFormattedDateOfToday(ExprValue formatExpr, ExprValue time, Clock current) {
        LocalDateTime date = LocalDateTime.of(LocalDate.now(current), time.timeValue());
        return DateTimeFormatterUtil.getFormattedString(formatExpr, DATE_HANDLERS, date);
    }

    public static ExprValue getFormattedTime(ExprValue timeExpr, ExprValue formatExpr) {
        LocalDateTime time = LocalDateTime.of(LocalDate.now(), timeExpr.timeValue());
        return DateTimeFormatterUtil.getFormattedString(formatExpr, TIME_HANDLERS, time);
    }

    private static boolean canGetDate(TemporalAccessor ta) {
        return ta.isSupported(ChronoField.YEAR) && ta.isSupported(ChronoField.MONTH_OF_YEAR) && ta.isSupported(ChronoField.DAY_OF_MONTH);
    }

    private static boolean canGetTime(TemporalAccessor ta) {
        return ta.isSupported(ChronoField.HOUR_OF_DAY) && ta.isSupported(ChronoField.MINUTE_OF_HOUR) && ta.isSupported(ChronoField.SECOND_OF_MINUTE);
    }

    static ExprValue parseStringWithDateOrTime(FunctionProperties fp, ExprValue datetimeStringExpr, ExprValue formatExpr) {
        TemporalAccessor taWithMissingFields;
        StringBuffer cleanFormat = DateTimeFormatterUtil.getCleanFormat(formatExpr);
        Matcher matcher = pattern.matcher(cleanFormat.toString());
        StringBuffer format = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(format, STR_TO_DATE_FORMATS.getOrDefault(matcher.group(), String.format("'%s'", matcher.group().replaceFirst(MOD_LITERAL, ""))));
        }
        matcher.appendTail(format);
        try {
            taWithMissingFields = new DateTimeFormatterBuilder().appendPattern(format.toString()).toFormatter().withResolverStyle(ResolverStyle.STRICT).parseUnresolved(datetimeStringExpr.stringValue(), new ParsePosition(0));
            if (taWithMissingFields == null) {
                throw new DateTimeException("Input string could not be parsed properly.");
            }
            if (!DateTimeFormatterUtil.canGetDate(taWithMissingFields) && !DateTimeFormatterUtil.canGetTime(taWithMissingFields)) {
                throw new DateTimeException("Not enough data to build a valid Date, Time, or Datetime.");
            }
        }
        catch (DateTimeException e) {
            return ExprNullValue.of();
        }
        int year = taWithMissingFields.isSupported(ChronoField.YEAR) ? taWithMissingFields.get(ChronoField.YEAR) : 2000;
        int month = taWithMissingFields.isSupported(ChronoField.MONTH_OF_YEAR) ? taWithMissingFields.get(ChronoField.MONTH_OF_YEAR) : 1;
        int day = taWithMissingFields.isSupported(ChronoField.DAY_OF_MONTH) ? taWithMissingFields.get(ChronoField.DAY_OF_MONTH) : 1;
        int hour = taWithMissingFields.isSupported(ChronoField.HOUR_OF_DAY) ? taWithMissingFields.get(ChronoField.HOUR_OF_DAY) : 0;
        int minute = taWithMissingFields.isSupported(ChronoField.MINUTE_OF_HOUR) ? taWithMissingFields.get(ChronoField.MINUTE_OF_HOUR) : 0;
        int second = taWithMissingFields.isSupported(ChronoField.SECOND_OF_MINUTE) ? taWithMissingFields.get(ChronoField.SECOND_OF_MINUTE) : 0;
        LocalDateTime output = !DateTimeFormatterUtil.canGetDate(taWithMissingFields) ? LocalDateTime.of(LocalDate.now(fp.getQueryStartClock()), LocalTime.of(hour, minute, second)) : LocalDateTime.of(year, month, day, hour, minute, second);
        return new ExprTimestampValue(output);
    }

    private static String getSuffix(int val) {
        if (11 <= val && val <= 13) {
            return SUFFIX_SPECIAL_TH;
        }
        return SUFFIX_CONVERTER.getOrDefault(val % 10, SUFFIX_SPECIAL_TH);
    }

    static interface DateTimeFormatHandler {
        public String getFormat(LocalDateTime var1);
    }
}

