/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories.blobstore;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;
import org.opensearch.cluster.metadata.CryptoMetadata;
import org.opensearch.common.Nullable;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class EncryptionContextUtils {
    public static String mergeAndEncodeEncryptionContexts(@Nullable String indexEncContext, @Nullable String repoEncContext) {
        if ((indexEncContext == null || indexEncContext.isEmpty()) && (repoEncContext == null || repoEncContext.isEmpty())) {
            return null;
        }
        String indexJson = null;
        if (indexEncContext != null && !indexEncContext.isEmpty()) {
            String trimmed = indexEncContext.trim();
            indexJson = trimmed.startsWith("{") ? trimmed : EncryptionContextUtils.cryptofsToJson(trimmed);
        }
        String repoJson = null;
        if (repoEncContext != null && !repoEncContext.isEmpty()) {
            try {
                byte[] decoded = Base64.getDecoder().decode(repoEncContext);
                repoJson = new String(decoded, StandardCharsets.UTF_8);
            }
            catch (IllegalArgumentException e) {
                repoJson = repoEncContext;
            }
        }
        String mergedJson = EncryptionContextUtils.mergeJson(repoJson, indexJson);
        return Base64.getEncoder().encodeToString(mergedJson.getBytes(StandardCharsets.UTF_8));
    }

    public static CryptoMetadata mergeCryptoMetadata(CryptoMetadata indexMetadata, CryptoMetadata repositoryCryptoMetadata) {
        if (indexMetadata == null && repositoryCryptoMetadata == null) {
            return null;
        }
        if (indexMetadata == null) {
            return repositoryCryptoMetadata;
        }
        if (repositoryCryptoMetadata == null) {
            return indexMetadata;
        }
        String keyProviderName = indexMetadata.keyProviderName() != null ? indexMetadata.keyProviderName() : repositoryCryptoMetadata.keyProviderName();
        String keyProviderType = indexMetadata.keyProviderType() != null ? indexMetadata.keyProviderType() : repositoryCryptoMetadata.keyProviderType();
        Settings.Builder settingsBuilder = Settings.builder().put(repositoryCryptoMetadata.settings()).put(indexMetadata.settings());
        String indexCtx = indexMetadata.settings().get("kms.encryption_context");
        String repoCtx = repositoryCryptoMetadata.settings().get("kms.encryption_context");
        if (indexCtx != null && !indexCtx.isEmpty()) {
            String indexJson;
            String string = indexJson = indexCtx.trim().startsWith("{") ? indexCtx : EncryptionContextUtils.cryptofsToJson(indexCtx);
            if (repoCtx != null && !repoCtx.isEmpty()) {
                String repoJson = repoCtx.trim().startsWith("{") ? repoCtx : EncryptionContextUtils.cryptofsToJson(repoCtx);
                String mergedJson = EncryptionContextUtils.mergeJson(repoJson, indexJson);
                String mergedCryptofs = EncryptionContextUtils.jsonToCryptofs(mergedJson);
                settingsBuilder.put("kms.encryption_context", mergedCryptofs);
            } else {
                settingsBuilder.put("kms.encryption_context", indexCtx);
            }
        } else if (repoCtx != null && !repoCtx.isEmpty()) {
            settingsBuilder.put("kms.encryption_context", repoCtx);
        }
        return new CryptoMetadata(keyProviderName, keyProviderType, settingsBuilder.build());
    }

    public static String cryptofsToJson(String cryptofs) {
        if (cryptofs == null || cryptofs.isEmpty()) {
            return "{}";
        }
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.startObject();
            for (String pair : cryptofs.split(",")) {
                String[] kv = pair.trim().split("=", 2);
                if (kv.length != 2) continue;
                builder.field(kv[0].trim(), kv[1].trim());
            }
            builder.endObject();
            return builder.toString();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to convert cryptofs format to JSON", e);
        }
    }

    public static String jsonToCryptofs(String json) {
        if (json == null || json.isEmpty()) {
            return "";
        }
        try {
            Map<String, String> map = EncryptionContextUtils.parseJsonToMap(json);
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (Map.Entry<String, String> e : map.entrySet()) {
                if (!first) {
                    sb.append(",");
                }
                sb.append(e.getKey()).append("=").append(e.getValue());
                first = false;
            }
            return sb.toString();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to parse JSON for cryptofs conversion", e);
        }
    }

    public static String mergeJson(String base, String override) {
        if (base == null || base.isEmpty()) {
            return override != null ? override : "{}";
        }
        if (override == null || override.isEmpty()) {
            return base;
        }
        try {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            map.putAll(EncryptionContextUtils.parseJsonToMap(base));
            map.putAll(EncryptionContextUtils.parseJsonToMap(override));
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.startObject();
            for (Map.Entry e : map.entrySet()) {
                builder.field((String)e.getKey(), (String)e.getValue());
            }
            builder.endObject();
            return builder.toString();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to merge JSON contexts", e);
        }
    }

    public static void parseSimpleJson(String json, Map<String, String> map) {
        try {
            map.putAll(EncryptionContextUtils.parseJsonToMap(json));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to parse JSON", e);
        }
    }

    private static Map<String, String> parseJsonToMap(String json) throws IOException {
        if (json == null || json.trim().isEmpty()) {
            return new LinkedHashMap<String, String>();
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        try (XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, json);){
            XContentParser.Token token = parser.nextToken();
            if (token != XContentParser.Token.START_OBJECT) {
                throw new IllegalArgumentException("Expected JSON object, got: " + String.valueOf(token));
            }
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token != XContentParser.Token.FIELD_NAME) continue;
                String key = parser.currentName();
                parser.nextToken();
                String value = parser.text();
                map.put(key, value);
            }
        }
        return map;
    }
}

