/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sql.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.hibernate.action.internal.BulkOperationCleanupAction;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.spi.NonSelectQueryPlan;
import org.hibernate.query.sql.internal.SQLQueryParser;
import org.hibernate.query.sql.spi.ParameterOccurrence;
import org.hibernate.query.sqm.internal.SqmJdbcExecutionContextAdapter;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.JdbcOperationQueryMutationNative;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;

public class NativeNonSelectQueryPlanImpl
implements NonSelectQueryPlan {
    private final String sql;
    private final Set<String> affectedTableNames;
    private final List<ParameterOccurrence> parameterList;

    public NativeNonSelectQueryPlanImpl(String sql, Set<String> affectedTableNames, List<ParameterOccurrence> parameterList) {
        this.sql = sql;
        this.affectedTableNames = affectedTableNames;
        this.parameterList = parameterList;
    }

    @Override
    public int executeUpdate(DomainQueryExecutionContext executionContext) {
        JdbcParameterBindings jdbcParameterBindings;
        List<JdbcParameterBinder> jdbcParameterBinders;
        SharedSessionContractImplementor session = executionContext.getSession();
        session.autoFlushIfRequired(this.affectedTableNames);
        BulkOperationCleanupAction.schedule(session, this.affectedTableNames);
        if (this.parameterList == null || this.parameterList.isEmpty()) {
            jdbcParameterBinders = Collections.emptyList();
            jdbcParameterBindings = JdbcParameterBindings.NO_BINDINGS;
        } else {
            jdbcParameterBinders = new ArrayList(this.parameterList.size());
            jdbcParameterBindings = new JdbcParameterBindingsImpl(executionContext.getQueryParameterBindings(), this.parameterList, jdbcParameterBinders, session.getFactory());
        }
        String processedSql = new SQLQueryParser(this.sql, null, session.getSessionFactory()).process();
        return session.getJdbcServices().getJdbcMutationExecutor().execute(new JdbcOperationQueryMutationNative(processedSql, jdbcParameterBinders, this.affectedTableNames), jdbcParameterBindings, sql -> session.getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, SqmJdbcExecutionContextAdapter.usingLockingAndPaging(executionContext));
    }
}

