/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.utils;

import java.util.concurrent.TimeUnit;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.SessionExpirationUtils;

public record RealmExpiration(int lifespan, int maxIdle, int offlineLifespan, int offlineMaxIdle, int rememberMeLifespan, int rememberMeMaxIdle) {
    public int getLifespan(boolean rememberMe) {
        return rememberMe ? this.rememberMeLifespan : this.lifespan;
    }

    public int getMaxIdle(boolean rememberMe) {
        return rememberMe ? this.rememberMeMaxIdle : this.maxIdle;
    }

    public long calculateOfflineLifespanTimestamp(long created) {
        return this.offlineLifespan == -1 ? -1L : created + TimeUnit.SECONDS.toMillis(this.offlineLifespan);
    }

    public long calculateRegularLifespanTimestamp(long created, boolean rememberMe) {
        return created + TimeUnit.SECONDS.toMillis(this.getLifespan(rememberMe));
    }

    public long calculateOfflineMaxIdleTimestamp(long lastRefresh) {
        return lastRefresh + TimeUnit.SECONDS.toMillis(this.offlineMaxIdle);
    }

    public long calculateRegularMaxIdleTimestamp(long lastRefresh, boolean rememberMe) {
        return lastRefresh + TimeUnit.SECONDS.toMillis(this.getMaxIdle(rememberMe));
    }

    public static RealmExpiration fromRealm(RealmModel realm) {
        int offlineMaxIdle = SessionExpirationUtils.getOfflineSessionIdleTimeout(realm);
        int offlineLifespan = realm.isOfflineSessionMaxLifespanEnabled() ? SessionExpirationUtils.getOfflineSessionMaxLifespan(realm) : -1;
        int maxIdle = SessionExpirationUtils.getSsoSessionIdleTimeout(realm);
        int lifespan = SessionExpirationUtils.getSsoSessionMaxLifespan(realm);
        int maxIdleRememberMe = Math.max(maxIdle, realm.getSsoSessionIdleTimeoutRememberMe());
        int lifespanRememberMe = Math.max(lifespan, realm.getSsoSessionMaxLifespanRememberMe());
        return new RealmExpiration(lifespan, maxIdle, offlineLifespan, offlineMaxIdle, lifespanRememberMe, maxIdleRememberMe);
    }
}

