/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.encode;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class AccessTokenContext {
    private final SessionType sessionType;
    private final TokenType tokenType;
    private final String grantType;
    private final String rawTokenId;

    @JsonCreator
    public AccessTokenContext(@JsonProperty(value="sessionType") SessionType sessionType, @JsonProperty(value="tokenType") TokenType tokenType, @JsonProperty(value="grantType") String grantType, @JsonProperty(value="rawTokenId") String rawTokenId) {
        Objects.requireNonNull(sessionType, "Null sessionType not allowed");
        Objects.requireNonNull(tokenType, "Null tokenType not allowed");
        Objects.requireNonNull(grantType, "Null grantType not allowed");
        Objects.requireNonNull(grantType, "Null rawTokenId not allowed");
        this.sessionType = sessionType;
        this.tokenType = tokenType;
        this.grantType = grantType;
        this.rawTokenId = rawTokenId;
    }

    public SessionType getSessionType() {
        return this.sessionType;
    }

    public TokenType getTokenType() {
        return this.tokenType;
    }

    public String getGrantType() {
        return this.grantType;
    }

    public String getRawTokenId() {
        return this.rawTokenId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AccessTokenContext)) return false;
        AccessTokenContext that = (AccessTokenContext)obj;
        if (this.sessionType != that.sessionType) return false;
        if (this.tokenType != that.tokenType) return false;
        if (!Objects.equals(this.grantType, that.grantType)) return false;
        if (!Objects.equals(this.rawTokenId, that.rawTokenId)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sessionType, this.tokenType, this.grantType, this.rawTokenId});
    }

    public static enum SessionType {
        ONLINE("on", false, true, false, false),
        OFFLINE("of", false, false, true, false),
        TRANSIENT("tr", true, false, false, false),
        ONLINE_TRANSIENT_CLIENT("nt", false, true, false, true),
        OFFLINE_TRANSIENT_CLIENT("ft", false, false, true, true),
        UNKNOWN("un", true, true, true, false);

        private final String shortcut;
        private final boolean allowTransientUserSession;
        private final boolean allowLookupOnlineUserSession;
        private final boolean allowLookupOfflineUserSession;
        private final boolean allowTransientClientSession;

        private SessionType(String shortcut, boolean allowTransientUserSession, boolean allowLookupOnlineUserSession, boolean allowLookupOfflineUserSession, boolean allowTransientClientSession) {
            this.shortcut = shortcut;
            this.allowTransientUserSession = allowTransientUserSession;
            this.allowLookupOnlineUserSession = allowLookupOnlineUserSession;
            this.allowLookupOfflineUserSession = allowLookupOfflineUserSession;
            this.allowTransientClientSession = allowTransientClientSession;
        }

        public String getShortcut() {
            return this.shortcut;
        }

        public boolean isAllowTransientUserSession() {
            return this.allowTransientUserSession;
        }

        public boolean isAllowLookupOnlineUserSession() {
            return this.allowLookupOnlineUserSession;
        }

        public boolean isAllowLookupOfflineUserSession() {
            return this.allowLookupOfflineUserSession;
        }

        public boolean isAllowTransientClientSession() {
            return this.allowTransientClientSession;
        }
    }

    public static enum TokenType {
        REGULAR("rt"),
        LIGHTWEIGHT("lt"),
        UNKNOWN("un");

        private final String shortcut;

        private TokenType(String shortcut) {
            this.shortcut = shortcut;
        }

        public String getShortcut() {
            return this.shortcut;
        }
    }
}

