/*
 * Decompiled with CFR 0.152.
 */
package org.linuxsampler.lscp;

import org.linuxsampler.lscp.Client;
import org.linuxsampler.lscp.LscpException;
import org.linuxsampler.lscp.LscpI18n;
import org.linuxsampler.lscp.Parseable;
import org.linuxsampler.lscp.Parser;

public class FxSend
implements Parseable {
    private int fxSendId = -1;
    private String name = null;
    private int midiController = -1;
    private float level = 0.0f;
    private Integer[] aor = null;

    public FxSend() {
    }

    public FxSend(String[] stringArray) throws LscpException {
        for (String string : stringArray) {
            if (this.parse(string)) continue;
            Client.getLogger().info(LscpI18n.getLogMsg("unknownLine", string));
        }
    }

    public int getFxSendId() {
        return this.fxSendId;
    }

    public void setFxSendId(int n) {
        this.fxSendId = n;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getMidiController() {
        return this.midiController;
    }

    public float getLevel() {
        return this.level;
    }

    public Integer[] getAudioOutputRouting() {
        return this.aor;
    }

    @Override
    public boolean parse(String string) throws LscpException {
        if (string.startsWith("NAME: ")) {
            this.name = Parser.toNonEscapedString(string.substring("NAME: ".length()));
        } else if (string.startsWith("MIDI_CONTROLLER: ")) {
            string = string.substring("MIDI_CONTROLLER: ".length());
            this.midiController = Parser.parseInt(string);
        } else if (string.startsWith("LEVEL: ")) {
            string = string.substring("LEVEL: ".length());
            this.level = Parser.parseFloat(string);
        } else if (string.startsWith("AUDIO_OUTPUT_ROUTING: ")) {
            string = string.substring("AUDIO_OUTPUT_ROUTING: ".length());
            this.aor = Parser.parseIntList(string);
        } else {
            return false;
        }
        return true;
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof FxSend)) {
            return false;
        }
        FxSend fxSend = (FxSend)object;
        return this.getFxSendId() == fxSend.getFxSendId();
    }
}

