/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.builtin.stringvalidation;

import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.builtin.stringvalidation.StringValidator;

final class RegexpValidator
extends StringValidator {
    private final Pattern pattern;
    private final String message;
    private boolean acceptPartialMatches;

    RegexpValidator(String pattern, String message, boolean acceptPartialMatches) {
        this.pattern = Pattern.compile(pattern);
        this.message = message;
        this.acceptPartialMatches = acceptPartialMatches;
    }

    @Override
    public void validate(Problems problems, String compName, String model) {
        boolean result;
        Matcher m = this.pattern.matcher(model);
        boolean bl = result = this.acceptPartialMatches ? m.lookingAt() : m.matches();
        if (!result) {
            String prb = this.message;
            prb = MessageFormat.format(prb, compName, model);
            problems.append(prb);
        }
    }
}

