# SPDX-License-Identifier: GPL-2.0-or-later
# MonoidalCategories: Monoidal and monoidal (co)closed categories
#
# Implementations
#
# THIS FILE IS AUTOMATICALLY GENERATED, SEE CAP_project/CAP/gap/MethodRecordTools.gi

## IsomorphismFromLeftDualObjectToLeftInternalHomIntoTensorUnit
InstallMethod( AddIsomorphismFromLeftDualObjectToLeftInternalHomIntoTensorUnit,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsomorphismFromLeftDualObjectToLeftInternalHomIntoTensorUnit", category, func, -1 );
    
end );

InstallMethod( AddIsomorphismFromLeftDualObjectToLeftInternalHomIntoTensorUnit,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsomorphismFromLeftDualObjectToLeftInternalHomIntoTensorUnit", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsomorphismFromLeftInternalHomIntoTensorUnitToLeftDualObject
InstallMethod( AddIsomorphismFromLeftInternalHomIntoTensorUnitToLeftDualObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsomorphismFromLeftInternalHomIntoTensorUnitToLeftDualObject", category, func, -1 );
    
end );

InstallMethod( AddIsomorphismFromLeftInternalHomIntoTensorUnitToLeftDualObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsomorphismFromLeftInternalHomIntoTensorUnitToLeftDualObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsomorphismFromLeftInternalHomToObject
InstallMethod( AddIsomorphismFromLeftInternalHomToObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsomorphismFromLeftInternalHomToObject", category, func, -1 );
    
end );

InstallMethod( AddIsomorphismFromLeftInternalHomToObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsomorphismFromLeftInternalHomToObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsomorphismFromLeftInternalHomToObjectWithGivenLeftInternalHom
InstallMethod( AddIsomorphismFromLeftInternalHomToObjectWithGivenLeftInternalHom,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsomorphismFromLeftInternalHomToObjectWithGivenLeftInternalHom", category, func, -1 );
    
end );

InstallMethod( AddIsomorphismFromLeftInternalHomToObjectWithGivenLeftInternalHom,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsomorphismFromLeftInternalHomToObjectWithGivenLeftInternalHom", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( IsomorphismFromLeftInternalHomToObjectWithGivenLeftInternalHom,
                    "IsomorphismFromLeftInternalHomToObjectWithGivenLeftInternalHom by calling IsomorphismFromLeftInternalHomToObject with the WithGiven argument(s) dropped",
                    [
                        [ IsomorphismFromLeftInternalHomToObject, 1 ],
                    ],
  function( cat, a, s )
    
    return IsomorphismFromLeftInternalHomToObject( cat, a );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( IsomorphismFromLeftInternalHomToObject,
                    "IsomorphismFromLeftInternalHomToObject by calling IsomorphismFromLeftInternalHomToObjectWithGivenLeftInternalHom with the WithGiven object(s)",
                    [
                        [ IsomorphismFromLeftInternalHomToObjectWithGivenLeftInternalHom, 1 ],
                        [ LeftInternalHomOnObjects, 1 ],
                        [ TensorUnit, 1 ],
                    ],
  function( cat, a )
    
    return IsomorphismFromLeftInternalHomToObjectWithGivenLeftInternalHom( cat, a, LeftInternalHomOnObjects( cat, TensorUnit( cat ), a ) );
    
end : is_with_given_derivation := true );

## IsomorphismFromObjectToLeftInternalHom
InstallMethod( AddIsomorphismFromObjectToLeftInternalHom,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsomorphismFromObjectToLeftInternalHom", category, func, -1 );
    
end );

InstallMethod( AddIsomorphismFromObjectToLeftInternalHom,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsomorphismFromObjectToLeftInternalHom", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsomorphismFromObjectToLeftInternalHomWithGivenLeftInternalHom
InstallMethod( AddIsomorphismFromObjectToLeftInternalHomWithGivenLeftInternalHom,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsomorphismFromObjectToLeftInternalHomWithGivenLeftInternalHom", category, func, -1 );
    
end );

InstallMethod( AddIsomorphismFromObjectToLeftInternalHomWithGivenLeftInternalHom,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsomorphismFromObjectToLeftInternalHomWithGivenLeftInternalHom", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( IsomorphismFromObjectToLeftInternalHomWithGivenLeftInternalHom,
                    "IsomorphismFromObjectToLeftInternalHomWithGivenLeftInternalHom by calling IsomorphismFromObjectToLeftInternalHom with the WithGiven argument(s) dropped",
                    [
                        [ IsomorphismFromObjectToLeftInternalHom, 1 ],
                    ],
  function( cat, a, r )
    
    return IsomorphismFromObjectToLeftInternalHom( cat, a );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( IsomorphismFromObjectToLeftInternalHom,
                    "IsomorphismFromObjectToLeftInternalHom by calling IsomorphismFromObjectToLeftInternalHomWithGivenLeftInternalHom with the WithGiven object(s)",
                    [
                        [ IsomorphismFromObjectToLeftInternalHomWithGivenLeftInternalHom, 1 ],
                        [ LeftInternalHomOnObjects, 1 ],
                        [ TensorUnit, 1 ],
                    ],
  function( cat, a )
    
    return IsomorphismFromObjectToLeftInternalHomWithGivenLeftInternalHom( cat, a, LeftInternalHomOnObjects( cat, TensorUnit( cat ), a ) );
    
end : is_with_given_derivation := true );

## LeftClosedMonoidalCoevaluationMorphism
InstallMethod( AddLeftClosedMonoidalCoevaluationMorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "LeftClosedMonoidalCoevaluationMorphism", category, func, -1 );
    
end );

InstallMethod( AddLeftClosedMonoidalCoevaluationMorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "LeftClosedMonoidalCoevaluationMorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## LeftClosedMonoidalCoevaluationMorphismWithGivenRange
InstallMethod( AddLeftClosedMonoidalCoevaluationMorphismWithGivenRange,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "LeftClosedMonoidalCoevaluationMorphismWithGivenRange", category, func, -1 );
    
end );

InstallMethod( AddLeftClosedMonoidalCoevaluationMorphismWithGivenRange,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "LeftClosedMonoidalCoevaluationMorphismWithGivenRange", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( LeftClosedMonoidalCoevaluationMorphismWithGivenRange,
                    "LeftClosedMonoidalCoevaluationMorphismWithGivenRange by calling LeftClosedMonoidalCoevaluationMorphism with the WithGiven argument(s) dropped",
                    [
                        [ LeftClosedMonoidalCoevaluationMorphism, 1 ],
                    ],
  function( cat, a, b, r )
    
    return LeftClosedMonoidalCoevaluationMorphism( cat, a, b );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( LeftClosedMonoidalCoevaluationMorphism,
                    "LeftClosedMonoidalCoevaluationMorphism by calling LeftClosedMonoidalCoevaluationMorphismWithGivenRange with the WithGiven object(s)",
                    [
                        [ LeftClosedMonoidalCoevaluationMorphismWithGivenRange, 1 ],
                        [ LeftInternalHomOnObjects, 1 ],
                        [ TensorProductOnObjects, 1 ],
                    ],
  function( cat, a, b )
    
    return LeftClosedMonoidalCoevaluationMorphismWithGivenRange( cat, a, b, LeftInternalHomOnObjects( cat, a, TensorProductOnObjects( cat, b, a ) ) );
    
end : is_with_given_derivation := true );

## LeftClosedMonoidalEvaluationForLeftDual
InstallMethod( AddLeftClosedMonoidalEvaluationForLeftDual,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "LeftClosedMonoidalEvaluationForLeftDual", category, func, -1 );
    
end );

InstallMethod( AddLeftClosedMonoidalEvaluationForLeftDual,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "LeftClosedMonoidalEvaluationForLeftDual", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## LeftClosedMonoidalEvaluationForLeftDualWithGivenTensorProduct
InstallMethod( AddLeftClosedMonoidalEvaluationForLeftDualWithGivenTensorProduct,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "LeftClosedMonoidalEvaluationForLeftDualWithGivenTensorProduct", category, func, -1 );
    
end );

InstallMethod( AddLeftClosedMonoidalEvaluationForLeftDualWithGivenTensorProduct,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "LeftClosedMonoidalEvaluationForLeftDualWithGivenTensorProduct", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( LeftClosedMonoidalEvaluationForLeftDualWithGivenTensorProduct,
                    "LeftClosedMonoidalEvaluationForLeftDualWithGivenTensorProduct by calling LeftClosedMonoidalEvaluationForLeftDual with the WithGiven argument(s) dropped",
                    [
                        [ LeftClosedMonoidalEvaluationForLeftDual, 1 ],
                    ],
  function( cat, s, a, r )
    
    return LeftClosedMonoidalEvaluationForLeftDual( cat, a );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( LeftClosedMonoidalEvaluationForLeftDual,
                    "LeftClosedMonoidalEvaluationForLeftDual by calling LeftClosedMonoidalEvaluationForLeftDualWithGivenTensorProduct with the WithGiven object(s)",
                    [
                        [ LeftClosedMonoidalEvaluationForLeftDualWithGivenTensorProduct, 1 ],
                        [ TensorProductOnObjects, 1 ],
                        [ LeftDualOnObjects, 1 ],
                        [ TensorUnit, 1 ],
                    ],
  function( cat, a )
    
    return LeftClosedMonoidalEvaluationForLeftDualWithGivenTensorProduct( cat, TensorProductOnObjects( cat, LeftDualOnObjects( cat, a ), a ), a, TensorUnit( cat ) );
    
end : is_with_given_derivation := true );

## LeftClosedMonoidalEvaluationMorphism
InstallMethod( AddLeftClosedMonoidalEvaluationMorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "LeftClosedMonoidalEvaluationMorphism", category, func, -1 );
    
end );

InstallMethod( AddLeftClosedMonoidalEvaluationMorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "LeftClosedMonoidalEvaluationMorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## LeftClosedMonoidalEvaluationMorphismWithGivenSource
InstallMethod( AddLeftClosedMonoidalEvaluationMorphismWithGivenSource,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "LeftClosedMonoidalEvaluationMorphismWithGivenSource", category, func, -1 );
    
end );

InstallMethod( AddLeftClosedMonoidalEvaluationMorphismWithGivenSource,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "LeftClosedMonoidalEvaluationMorphismWithGivenSource", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( LeftClosedMonoidalEvaluationMorphismWithGivenSource,
                    "LeftClosedMonoidalEvaluationMorphismWithGivenSource by calling LeftClosedMonoidalEvaluationMorphism with the WithGiven argument(s) dropped",
                    [
                        [ LeftClosedMonoidalEvaluationMorphism, 1 ],
                    ],
  function( cat, a, b, s )
    
    return LeftClosedMonoidalEvaluationMorphism( cat, a, b );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( LeftClosedMonoidalEvaluationMorphism,
                    "LeftClosedMonoidalEvaluationMorphism by calling LeftClosedMonoidalEvaluationMorphismWithGivenSource with the WithGiven object(s)",
                    [
                        [ LeftClosedMonoidalEvaluationMorphismWithGivenSource, 1 ],
                        [ TensorProductOnObjects, 1 ],
                        [ LeftInternalHomOnObjects, 1 ],
                    ],
  function( cat, a, b )
    
    return LeftClosedMonoidalEvaluationMorphismWithGivenSource( cat, a, b, TensorProductOnObjects( cat, LeftInternalHomOnObjects( cat, a, b ), a ) );
    
end : is_with_given_derivation := true );

## LeftClosedMonoidalLambdaElimination
InstallMethod( AddLeftClosedMonoidalLambdaElimination,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "LeftClosedMonoidalLambdaElimination", category, func, -1 );
    
end );

InstallMethod( AddLeftClosedMonoidalLambdaElimination,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "LeftClosedMonoidalLambdaElimination", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## LeftClosedMonoidalLambdaIntroduction
InstallMethod( AddLeftClosedMonoidalLambdaIntroduction,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "LeftClosedMonoidalLambdaIntroduction", category, func, -1 );
    
end );

InstallMethod( AddLeftClosedMonoidalLambdaIntroduction,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "LeftClosedMonoidalLambdaIntroduction", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## LeftClosedMonoidalPostComposeMorphism
InstallMethod( AddLeftClosedMonoidalPostComposeMorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "LeftClosedMonoidalPostComposeMorphism", category, func, -1 );
    
end );

InstallMethod( AddLeftClosedMonoidalPostComposeMorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "LeftClosedMonoidalPostComposeMorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## LeftClosedMonoidalPostComposeMorphismWithGivenObjects
InstallMethod( AddLeftClosedMonoidalPostComposeMorphismWithGivenObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "LeftClosedMonoidalPostComposeMorphismWithGivenObjects", category, func, -1 );
    
end );

InstallMethod( AddLeftClosedMonoidalPostComposeMorphismWithGivenObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "LeftClosedMonoidalPostComposeMorphismWithGivenObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( LeftClosedMonoidalPostComposeMorphismWithGivenObjects,
                    "LeftClosedMonoidalPostComposeMorphismWithGivenObjects by calling LeftClosedMonoidalPostComposeMorphism with the WithGiven argument(s) dropped",
                    [
                        [ LeftClosedMonoidalPostComposeMorphism, 1 ],
                    ],
  function( cat, s, a, b, c, r )
    
    return LeftClosedMonoidalPostComposeMorphism( cat, a, b, c );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( LeftClosedMonoidalPostComposeMorphism,
                    "LeftClosedMonoidalPostComposeMorphism by calling LeftClosedMonoidalPostComposeMorphismWithGivenObjects with the WithGiven object(s)",
                    [
                        [ LeftClosedMonoidalPostComposeMorphismWithGivenObjects, 1 ],
                        [ TensorProductOnObjects, 1 ],
                        [ LeftInternalHomOnObjects, 3 ],
                    ],
  function( cat, a, b, c )
    
    return LeftClosedMonoidalPostComposeMorphismWithGivenObjects( cat, TensorProductOnObjects( cat, LeftInternalHomOnObjects( cat, b, c ), LeftInternalHomOnObjects( cat, a, b ) ), a, b, c, LeftInternalHomOnObjects( cat, a, c ) );
    
end : is_with_given_derivation := true );

## LeftClosedMonoidalPreComposeMorphism
InstallMethod( AddLeftClosedMonoidalPreComposeMorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "LeftClosedMonoidalPreComposeMorphism", category, func, -1 );
    
end );

InstallMethod( AddLeftClosedMonoidalPreComposeMorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "LeftClosedMonoidalPreComposeMorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## LeftClosedMonoidalPreComposeMorphismWithGivenObjects
InstallMethod( AddLeftClosedMonoidalPreComposeMorphismWithGivenObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "LeftClosedMonoidalPreComposeMorphismWithGivenObjects", category, func, -1 );
    
end );

InstallMethod( AddLeftClosedMonoidalPreComposeMorphismWithGivenObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "LeftClosedMonoidalPreComposeMorphismWithGivenObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( LeftClosedMonoidalPreComposeMorphismWithGivenObjects,
                    "LeftClosedMonoidalPreComposeMorphismWithGivenObjects by calling LeftClosedMonoidalPreComposeMorphism with the WithGiven argument(s) dropped",
                    [
                        [ LeftClosedMonoidalPreComposeMorphism, 1 ],
                    ],
  function( cat, s, a, b, c, r )
    
    return LeftClosedMonoidalPreComposeMorphism( cat, a, b, c );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( LeftClosedMonoidalPreComposeMorphism,
                    "LeftClosedMonoidalPreComposeMorphism by calling LeftClosedMonoidalPreComposeMorphismWithGivenObjects with the WithGiven object(s)",
                    [
                        [ LeftClosedMonoidalPreComposeMorphismWithGivenObjects, 1 ],
                        [ TensorProductOnObjects, 1 ],
                        [ LeftInternalHomOnObjects, 3 ],
                    ],
  function( cat, a, b, c )
    
    return LeftClosedMonoidalPreComposeMorphismWithGivenObjects( cat, TensorProductOnObjects( cat, LeftInternalHomOnObjects( cat, a, b ), LeftInternalHomOnObjects( cat, b, c ) ), a, b, c, LeftInternalHomOnObjects( cat, a, c ) );
    
end : is_with_given_derivation := true );

## LeftDualOnMorphisms
InstallMethod( AddLeftDualOnMorphisms,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "LeftDualOnMorphisms", category, func, -1 );
    
end );

InstallMethod( AddLeftDualOnMorphisms,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "LeftDualOnMorphisms", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## LeftDualOnMorphismsWithGivenLeftDuals
InstallMethod( AddLeftDualOnMorphismsWithGivenLeftDuals,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "LeftDualOnMorphismsWithGivenLeftDuals", category, func, -1 );
    
end );

InstallMethod( AddLeftDualOnMorphismsWithGivenLeftDuals,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "LeftDualOnMorphismsWithGivenLeftDuals", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( LeftDualOnMorphismsWithGivenLeftDuals,
                    "LeftDualOnMorphismsWithGivenLeftDuals by calling LeftDualOnMorphisms with the WithGiven argument(s) dropped",
                    [
                        [ LeftDualOnMorphisms, 1 ],
                    ],
  function( cat, s, alpha, r )
    
    return LeftDualOnMorphisms( cat, alpha );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( LeftDualOnMorphisms,
                    "LeftDualOnMorphisms by calling LeftDualOnMorphismsWithGivenLeftDuals with the WithGiven object(s)",
                    [
                        [ LeftDualOnMorphismsWithGivenLeftDuals, 1 ],
                        [ LeftDualOnObjects, 2 ],
                    ],
  function( cat, alpha )
    
    return LeftDualOnMorphismsWithGivenLeftDuals( cat, LeftDualOnObjects( cat, Range( alpha ) ), alpha, LeftDualOnObjects( cat, Source( alpha ) ) );
    
end : is_with_given_derivation := true );

## LeftDualOnObjects
InstallMethod( AddLeftDualOnObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "LeftDualOnObjects", category, func, -1 );
    
end );

InstallMethod( AddLeftDualOnObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "LeftDualOnObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## LeftInternalHomOnMorphisms
InstallMethod( AddLeftInternalHomOnMorphisms,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "LeftInternalHomOnMorphisms", category, func, -1 );
    
end );

InstallMethod( AddLeftInternalHomOnMorphisms,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "LeftInternalHomOnMorphisms", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## LeftInternalHomOnMorphismsWithGivenLeftInternalHoms
InstallMethod( AddLeftInternalHomOnMorphismsWithGivenLeftInternalHoms,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "LeftInternalHomOnMorphismsWithGivenLeftInternalHoms", category, func, -1 );
    
end );

InstallMethod( AddLeftInternalHomOnMorphismsWithGivenLeftInternalHoms,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "LeftInternalHomOnMorphismsWithGivenLeftInternalHoms", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( LeftInternalHomOnMorphismsWithGivenLeftInternalHoms,
                    "LeftInternalHomOnMorphismsWithGivenLeftInternalHoms by calling LeftInternalHomOnMorphisms with the WithGiven argument(s) dropped",
                    [
                        [ LeftInternalHomOnMorphisms, 1 ],
                    ],
  function( cat, s, alpha, beta, r )
    
    return LeftInternalHomOnMorphisms( cat, alpha, beta );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( LeftInternalHomOnMorphisms,
                    "LeftInternalHomOnMorphisms by calling LeftInternalHomOnMorphismsWithGivenLeftInternalHoms with the WithGiven object(s)",
                    [
                        [ LeftInternalHomOnMorphismsWithGivenLeftInternalHoms, 1 ],
                        [ LeftInternalHomOnObjects, 2 ],
                    ],
  function( cat, alpha, beta )
    
    return LeftInternalHomOnMorphismsWithGivenLeftInternalHoms( cat, LeftInternalHomOnObjects( cat, Range( alpha ), Source( beta ) ), alpha, beta, LeftInternalHomOnObjects( cat, Source( alpha ), Range( beta ) ) );
    
end : is_with_given_derivation := true );

## LeftInternalHomOnObjects
InstallMethod( AddLeftInternalHomOnObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "LeftInternalHomOnObjects", category, func, -1 );
    
end );

InstallMethod( AddLeftInternalHomOnObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "LeftInternalHomOnObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## LeftInternalHomToTensorProductAdjunctMorphism
InstallMethod( AddLeftInternalHomToTensorProductAdjunctMorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "LeftInternalHomToTensorProductAdjunctMorphism", category, func, -1 );
    
end );

InstallMethod( AddLeftInternalHomToTensorProductAdjunctMorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "LeftInternalHomToTensorProductAdjunctMorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## LeftInternalHomToTensorProductAdjunctMorphismWithGivenTensorProduct
InstallMethod( AddLeftInternalHomToTensorProductAdjunctMorphismWithGivenTensorProduct,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "LeftInternalHomToTensorProductAdjunctMorphismWithGivenTensorProduct", category, func, -1 );
    
end );

InstallMethod( AddLeftInternalHomToTensorProductAdjunctMorphismWithGivenTensorProduct,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "LeftInternalHomToTensorProductAdjunctMorphismWithGivenTensorProduct", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( LeftInternalHomToTensorProductAdjunctMorphismWithGivenTensorProduct,
                    "LeftInternalHomToTensorProductAdjunctMorphismWithGivenTensorProduct by calling LeftInternalHomToTensorProductAdjunctMorphism with the WithGiven argument(s) dropped",
                    [
                        [ LeftInternalHomToTensorProductAdjunctMorphism, 1 ],
                    ],
  function( cat, b, c, g, t )
    
    return LeftInternalHomToTensorProductAdjunctMorphism( cat, b, c, g );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( LeftInternalHomToTensorProductAdjunctMorphism,
                    "LeftInternalHomToTensorProductAdjunctMorphism by calling LeftInternalHomToTensorProductAdjunctMorphismWithGivenTensorProduct with the WithGiven object(s)",
                    [
                        [ LeftInternalHomToTensorProductAdjunctMorphismWithGivenTensorProduct, 1 ],
                        [ TensorProductOnObjects, 1 ],
                    ],
  function( cat, b, c, g )
    
    return LeftInternalHomToTensorProductAdjunctMorphismWithGivenTensorProduct( cat, b, c, g, TensorProductOnObjects( cat, Source( g ), b ) );
    
end : is_with_given_derivation := true );

## MorphismFromTensorProductToLeftInternalHom
InstallMethod( AddMorphismFromTensorProductToLeftInternalHom,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MorphismFromTensorProductToLeftInternalHom", category, func, -1 );
    
end );

InstallMethod( AddMorphismFromTensorProductToLeftInternalHom,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MorphismFromTensorProductToLeftInternalHom", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## MorphismFromTensorProductToLeftInternalHomWithGivenObjects
InstallMethod( AddMorphismFromTensorProductToLeftInternalHomWithGivenObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MorphismFromTensorProductToLeftInternalHomWithGivenObjects", category, func, -1 );
    
end );

InstallMethod( AddMorphismFromTensorProductToLeftInternalHomWithGivenObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MorphismFromTensorProductToLeftInternalHomWithGivenObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( MorphismFromTensorProductToLeftInternalHomWithGivenObjects,
                    "MorphismFromTensorProductToLeftInternalHomWithGivenObjects by calling MorphismFromTensorProductToLeftInternalHom with the WithGiven argument(s) dropped",
                    [
                        [ MorphismFromTensorProductToLeftInternalHom, 1 ],
                    ],
  function( cat, s, a, b, r )
    
    return MorphismFromTensorProductToLeftInternalHom( cat, a, b );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( MorphismFromTensorProductToLeftInternalHom,
                    "MorphismFromTensorProductToLeftInternalHom by calling MorphismFromTensorProductToLeftInternalHomWithGivenObjects with the WithGiven object(s)",
                    [
                        [ MorphismFromTensorProductToLeftInternalHomWithGivenObjects, 1 ],
                        [ TensorProductOnObjects, 1 ],
                        [ LeftDualOnObjects, 1 ],
                        [ LeftInternalHomOnObjects, 1 ],
                    ],
  function( cat, a, b )
    
    return MorphismFromTensorProductToLeftInternalHomWithGivenObjects( cat, TensorProductOnObjects( cat, LeftDualOnObjects( cat, a ), b ), a, b, LeftInternalHomOnObjects( cat, a, b ) );
    
end : is_with_given_derivation := true );

## MorphismToLeftBidual
InstallMethod( AddMorphismToLeftBidual,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MorphismToLeftBidual", category, func, -1 );
    
end );

InstallMethod( AddMorphismToLeftBidual,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MorphismToLeftBidual", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## MorphismToLeftBidualWithGivenLeftBidual
InstallMethod( AddMorphismToLeftBidualWithGivenLeftBidual,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MorphismToLeftBidualWithGivenLeftBidual", category, func, -1 );
    
end );

InstallMethod( AddMorphismToLeftBidualWithGivenLeftBidual,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MorphismToLeftBidualWithGivenLeftBidual", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( MorphismToLeftBidualWithGivenLeftBidual,
                    "MorphismToLeftBidualWithGivenLeftBidual by calling MorphismToLeftBidual with the WithGiven argument(s) dropped",
                    [
                        [ MorphismToLeftBidual, 1 ],
                    ],
  function( cat, a, r )
    
    return MorphismToLeftBidual( cat, a );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( MorphismToLeftBidual,
                    "MorphismToLeftBidual by calling MorphismToLeftBidualWithGivenLeftBidual with the WithGiven object(s)",
                    [
                        [ MorphismToLeftBidualWithGivenLeftBidual, 1 ],
                        [ LeftDualOnObjects, 2 ],
                    ],
  function( cat, a )
    
    return MorphismToLeftBidualWithGivenLeftBidual( cat, a, LeftDualOnObjects( cat, LeftDualOnObjects( cat, a ) ) );
    
end : is_with_given_derivation := true );

## TensorProductLeftDualityCompatibilityMorphism
InstallMethod( AddTensorProductLeftDualityCompatibilityMorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "TensorProductLeftDualityCompatibilityMorphism", category, func, -1 );
    
end );

InstallMethod( AddTensorProductLeftDualityCompatibilityMorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "TensorProductLeftDualityCompatibilityMorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## TensorProductLeftDualityCompatibilityMorphismWithGivenObjects
InstallMethod( AddTensorProductLeftDualityCompatibilityMorphismWithGivenObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "TensorProductLeftDualityCompatibilityMorphismWithGivenObjects", category, func, -1 );
    
end );

InstallMethod( AddTensorProductLeftDualityCompatibilityMorphismWithGivenObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "TensorProductLeftDualityCompatibilityMorphismWithGivenObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( TensorProductLeftDualityCompatibilityMorphismWithGivenObjects,
                    "TensorProductLeftDualityCompatibilityMorphismWithGivenObjects by calling TensorProductLeftDualityCompatibilityMorphism with the WithGiven argument(s) dropped",
                    [
                        [ TensorProductLeftDualityCompatibilityMorphism, 1 ],
                    ],
  function( cat, s, a, b, r )
    
    return TensorProductLeftDualityCompatibilityMorphism( cat, a, b );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( TensorProductLeftDualityCompatibilityMorphism,
                    "TensorProductLeftDualityCompatibilityMorphism by calling TensorProductLeftDualityCompatibilityMorphismWithGivenObjects with the WithGiven object(s)",
                    [
                        [ TensorProductLeftDualityCompatibilityMorphismWithGivenObjects, 1 ],
                        [ TensorProductOnObjects, 2 ],
                        [ LeftDualOnObjects, 3 ],
                    ],
  function( cat, a, b )
    
    return TensorProductLeftDualityCompatibilityMorphismWithGivenObjects( cat, TensorProductOnObjects( cat, LeftDualOnObjects( cat, a ), LeftDualOnObjects( cat, b ) ), a, b, LeftDualOnObjects( cat, TensorProductOnObjects( cat, a, b ) ) );
    
end : is_with_given_derivation := true );

## TensorProductLeftInternalHomCompatibilityMorphism
InstallMethod( AddTensorProductLeftInternalHomCompatibilityMorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "TensorProductLeftInternalHomCompatibilityMorphism", category, func, -1 );
    
end );

InstallMethod( AddTensorProductLeftInternalHomCompatibilityMorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "TensorProductLeftInternalHomCompatibilityMorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## TensorProductLeftInternalHomCompatibilityMorphismWithGivenObjects
InstallMethod( AddTensorProductLeftInternalHomCompatibilityMorphismWithGivenObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "TensorProductLeftInternalHomCompatibilityMorphismWithGivenObjects", category, func, -1 );
    
end );

InstallMethod( AddTensorProductLeftInternalHomCompatibilityMorphismWithGivenObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "TensorProductLeftInternalHomCompatibilityMorphismWithGivenObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( TensorProductLeftInternalHomCompatibilityMorphismWithGivenObjects,
                    "TensorProductLeftInternalHomCompatibilityMorphismWithGivenObjects by calling TensorProductLeftInternalHomCompatibilityMorphism with the WithGiven argument(s) dropped",
                    [
                        [ TensorProductLeftInternalHomCompatibilityMorphism, 1 ],
                    ],
  function( cat, source, list, range )
    
    return TensorProductLeftInternalHomCompatibilityMorphism( cat, list );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( TensorProductLeftInternalHomCompatibilityMorphism,
                    "TensorProductLeftInternalHomCompatibilityMorphism by calling TensorProductLeftInternalHomCompatibilityMorphismWithGivenObjects with the WithGiven object(s)",
                    [
                        [ TensorProductLeftInternalHomCompatibilityMorphismWithGivenObjects, 1 ],
                        [ TensorProductOnObjects, 3 ],
                        [ LeftInternalHomOnObjects, 3 ],
                    ],
  function( cat, list )
    
    return TensorProductLeftInternalHomCompatibilityMorphismWithGivenObjects( cat, TensorProductOnObjects( cat, LeftInternalHomOnObjects( cat, list[1], list[2] ), LeftInternalHomOnObjects( cat, list[3], list[4] ) ), list, LeftInternalHomOnObjects( cat, TensorProductOnObjects( cat, list[1], list[3] ), TensorProductOnObjects( cat, list[2], list[4] ) ) );
    
end : is_with_given_derivation := true );

## TensorProductToLeftInternalHomAdjunctMorphism
InstallMethod( AddTensorProductToLeftInternalHomAdjunctMorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "TensorProductToLeftInternalHomAdjunctMorphism", category, func, -1 );
    
end );

InstallMethod( AddTensorProductToLeftInternalHomAdjunctMorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "TensorProductToLeftInternalHomAdjunctMorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## TensorProductToLeftInternalHomAdjunctMorphismWithGivenLeftInternalHom
InstallMethod( AddTensorProductToLeftInternalHomAdjunctMorphismWithGivenLeftInternalHom,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "TensorProductToLeftInternalHomAdjunctMorphismWithGivenLeftInternalHom", category, func, -1 );
    
end );

InstallMethod( AddTensorProductToLeftInternalHomAdjunctMorphismWithGivenLeftInternalHom,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "TensorProductToLeftInternalHomAdjunctMorphismWithGivenLeftInternalHom", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( TensorProductToLeftInternalHomAdjunctMorphismWithGivenLeftInternalHom,
                    "TensorProductToLeftInternalHomAdjunctMorphismWithGivenLeftInternalHom by calling TensorProductToLeftInternalHomAdjunctMorphism with the WithGiven argument(s) dropped",
                    [
                        [ TensorProductToLeftInternalHomAdjunctMorphism, 1 ],
                    ],
  function( cat, a, b, f, i )
    
    return TensorProductToLeftInternalHomAdjunctMorphism( cat, a, b, f );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( TensorProductToLeftInternalHomAdjunctMorphism,
                    "TensorProductToLeftInternalHomAdjunctMorphism by calling TensorProductToLeftInternalHomAdjunctMorphismWithGivenLeftInternalHom with the WithGiven object(s)",
                    [
                        [ TensorProductToLeftInternalHomAdjunctMorphismWithGivenLeftInternalHom, 1 ],
                        [ LeftInternalHomOnObjects, 1 ],
                    ],
  function( cat, a, b, f )
    
    return TensorProductToLeftInternalHomAdjunctMorphismWithGivenLeftInternalHom( cat, a, b, f, LeftInternalHomOnObjects( cat, b, Range( f ) ) );
    
end : is_with_given_derivation := true );

## UniversalPropertyOfLeftDual
InstallMethod( AddUniversalPropertyOfLeftDual,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "UniversalPropertyOfLeftDual", category, func, -1 );
    
end );

InstallMethod( AddUniversalPropertyOfLeftDual,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "UniversalPropertyOfLeftDual", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);
