/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.api.CompositeObjectId;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.file.FileTypeAction;
import org.jkiss.dbeaver.model.fs.DBFUtils;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.file.AbstractFileHandler;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectOpen;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public abstract class AbstractFileDatabaseHandler
extends AbstractFileHandler {
    public void openFiles(@NotNull List<Path> fileList, @Nullable DBPDataSourceContainer dataSource, @NotNull FileTypeAction action) throws DBException {
        if (action != FileTypeAction.DATABASE) {
            super.openFiles(fileList, dataSource, action);
            return;
        }
        DBPProject project = DBWorkbench.getPlatform().getWorkspace().getActiveProject();
        if (project == null) {
            throw new DBException("No active project - cannot open file");
        }
        DBPDriver driver = DBWorkbench.getPlatform().getDataSourceProviderRegistry().findDriver(this.getDriverReference());
        if (driver == null) {
            throw new DBException("Driver '" + String.valueOf(this.getDriverReference()) + "' not found");
        }
        if (this.isSingleDatabaseConnection()) {
            String databaseName = this.createDatabaseName(fileList);
            String connectionName = this.createConnectionName(fileList);
            this.createDatabaseConnection(connectionName, databaseName, project, driver);
        } else {
            for (Path dbFile : fileList) {
                String databaseName = this.createDatabaseName(Collections.singletonList(dbFile));
                String connectionName = this.createConnectionName(Collections.singletonList(dbFile));
                this.createDatabaseConnection(connectionName, databaseName, project, driver);
            }
        }
    }

    private void createDatabaseConnection(@NotNull String connectionName, @NotNull String databaseName, @NotNull DBPProject project, @NotNull DBPDriver driver) throws DBException {
        DBPConnectionConfiguration configuration = new DBPConnectionConfiguration();
        configuration.setDatabaseName(databaseName);
        DBPDataSourceContainer dsContainer = DBFUtils.createTemporaryDataSourceContainer((String)connectionName, (DBPProject)project, (DBPDriver)driver, (DBPConnectionConfiguration)configuration);
        if (dsContainer == null) {
            return;
        }
        UIUtils.runWithMonitor(monitor -> {
            if (dsContainer.isConnected() || dsContainer.connect(monitor, true, true)) {
                DBPDataSourceRegistry dBPDataSourceRegistry = dsContainer.getRegistry();
                if (dBPDataSourceRegistry instanceof DataSourceRegistry) {
                    DataSourceRegistry registry = (DataSourceRegistry)dBPDataSourceRegistry;
                    registry.flushDataSourceEvents();
                }
                DBPDataSource dataSource = dsContainer.getDataSource();
                DBNDatabaseNode openNode = DBNUtils.getDefaultDatabaseNodeToOpen((DBRProgressMonitor)monitor, (DBPDataSource)dataSource);
                int i = 0;
                while (i < 10 && openNode == null) {
                    RuntimeUtils.pause((int)100);
                    openNode = DBNUtils.getDefaultDatabaseNodeToOpen((DBRProgressMonitor)monitor, (DBPDataSource)dataSource);
                    ++i;
                }
                if (openNode == null) {
                    throw new DBException("Cannot determine target node for " + dsContainer.getName());
                }
                DBNDatabaseNode openNode1 = openNode;
                UIUtils.syncExec(() -> {
                    IEditorPart iEditorPart = NavigatorHandlerObjectOpen.openEntityEditor((DBNNode)openNode1, null, null, null, (IWorkbenchWindow)UIUtils.getActiveWorkbenchWindow(), (boolean)true, (boolean)false);
                });
            }
            return null;
        });
    }

    @NotNull
    public Set<FileTypeAction> supportedActions() {
        return Set.of(FileTypeAction.DATABASE, FileTypeAction.INTERNAL_EDITOR, FileTypeAction.EXTERNAL_EDITOR);
    }

    protected abstract String getDatabaseTerm();

    protected abstract String createDatabaseName(@NotNull List<Path> var1);

    protected abstract String createConnectionName(@NotNull List<Path> var1);

    protected abstract CompositeObjectId getDriverReference();

    protected boolean isSingleDatabaseConnection() {
        return true;
    }
}

