/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.ws.yahoo.rss;

import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import org.jdesktop.beans.AbstractBean;
import org.jdesktop.swingx.ws.yahoo.rss.RSSException;

public abstract class YahooRSS
extends AbstractBean {
    protected abstract String getUrlPrefix();

    protected abstract Map getParameters();

    protected final URL constructUrl() throws MalformedURLException {
        StringBuilder buffer = new StringBuilder(this.getUrlPrefix());
        buffer.append("?");
        Map params = this.getParameters();
        for (Object key : params.keySet()) {
            buffer.append(URLEncoder.encode(key.toString()));
            buffer.append("=");
            buffer.append(URLEncoder.encode(params.get(key).toString()));
            buffer.append("&");
        }
        if (buffer.charAt(buffer.length() - 1) == '&') {
            buffer.deleteCharAt(buffer.length() - 1);
        }
        return new URL(buffer.toString());
    }

    public SyndFeed readFeed() throws RSSException {
        try {
            URL feedUrl = this.constructUrl();
            SyndFeedInput input = new SyndFeedInput();
            return input.build((Reader)new XmlReader(feedUrl));
        }
        catch (Exception e) {
            throw new RSSException(e);
        }
    }
}

