# Ruanui sky: Tahiti and Society islands

## Introduction

French Polynesia encompasses 118 islands scattered amidst a marine area of nearly 5 millions square kilometers. It is divided into 5 archipelagos: the Society archipelago, the Austral, the Tuamotu, the Gambier and the Marquesas archipelago. The Society archipelago, composed of 6 islands and 8 atolls, is divided into 2 subgroups, the Windward islands and the Leeward islands. This archipelago has developed its own sky culture with Tahiti at its centre. Tahiti being the biggest island (1500 square kilometers), it is also the economic and political centre. Ra'iatea was the religious centre with the archeological site of Taputapuatea, and Bora-Bora was famous for its knowledge and mastery of the art of navigation. It is therefore noteworthy to mention that the names of the stars can be different from one archipelago of French Polynesia to another, and that the sky culture presented here is that of the Society Islands.

## Description

The names of the stars in the Tahitian sky mainly come from the "genealogy of the stars", a text which was recited to the English missionary John Muggridge Orsmond in 1818 by Ruanui, an old lady from Bora Bora, in the leeward islands, northwest of Tahiti. It was enhanced thanks to the logbook of J.R. Forster, a naturalist on the 2nd expedition of Captain James Cook (1772-1776), but also thanks to accounts from Europeans living in Tahiti at the end of the 18th century such as J.Morisson (1789-1791) and lastly thanks to the many observations and records of the first missionnaries at the turn of the 19th century.

The "Genealogy of the stars" was published later on by Teuira Henry, the granddaughter of J. M. Orsmond, in the book "Ancient Tahiti" (1928). This long poem, whose key asset was its transcription in the vernacular tongue by J.Orsmond in 1818, then translated in English, narrates the birth of the stars, the Moon, the Sun and the planets as a genealogy. Children of the divine couple Rua-tupua-nui and Atea, the astral bodies, take partners and give birth to other celestial bodies to populate the sky. Shell, egg or seed, the sky is seen as a creator space revealing divine manifestations such as clouds, swells, currents and winds and yielding the principle of life.

### Linking space, time and men: an "environmental" calendar

Based on very precise observations, the experts of ancient times or tahu'a developed an acute knowledge of the stellar movement, linking closely the sky, the space and the time to the cycles of the environment, of the animals and of the plants. They were indissociable. This knowledge was passed down in the form of environmental calendars. Known and controlled by the elites, leaders and specialists, those calendars planned the propitiatory ceremonies and the community activities such as agriculture and fishing. They were set on the observation of the stars, planets and constellations, and related to the Sun's come and go movement between north and south, the shifting of the Moon, the seasons of the main winds and swells. The astral bodies, observed at night, after the sunset or before sunrise, were bearers of different functions which are available to us through their names which are oftentimes long, but which give each of them a proper identity. For example, the Pleiades, also called Matari'i in Tahiti, had a crucial cultural role and were used namely to divide the year into 2 seasons: from November to May, a hot and rainy season, known as the season of abundance, Matari'i I ni'a, and set on the fruiting of the breadfruit tree or 'uru and the return of the migrating pelagic fishes. The second season, cooler, drier, known as the season of restrictions, Matari'i i raro from May to November, during which the root crops / tubers were replacing the 'uru and the fishing in the lagoon replaced the offshore fishing.

### Explore, navigate and build alliances

"Star navigation" was the subject of much research in order to determine how the reading of the sky allowed the Polynesian people to navigate with such accuracy during journeys over thousands of km between remote islands. Today the names of the stars and of the constellations are becoming keys to approach the ancient voyagers' vision of the sky: markers to reach a target island and to come back to one's island home, but also to make inter-islands alliances for in a broad sense, in the Polynesian mindset one always belongs to a network, whether it be one of men, of the divinities of the ocean or of the space. Jean-Claude Teriierooiterai, linguist and Tahitian anthropologist, spent some of his life trying to resolve this mystery. He suggested a classification of the names of the stars by their usage. Hence, the stars Pou (Pillars) were used to locate the meridians whereas the stars Ta'urua would indicate a Rua. The Rua of the stars correspond to a succession of stars rising on the horizon at an essentially identical declination and they would enable the voyager to steer a course (Thesis "Mythes, astronomie, découpage du temps et navigation traditionnelle : l'héritage océanien contenu dans les mots de la langue tahitienne", J-C Teriierooiterai, 2013).

Today, the "Fa'afaite i te Ao Ma'ohi" association keeps these traditional navigation techniques alive by travelling between the polynesian islands on a traditional Polynesian double-hulled canoe.

### Constellations

Some names of constellations managed to reach us thanks to the "Genealogy of the stars" by Ruanui and by the popular use, yet our knowledge of the asterisms of the Tahitian sky is only in its infancy. Therefore, we only mention a few names and representations on this topic. However it is interesting to notice that certain constellations of the Tahitian sky could get a different name depending on the season and on their observation. For example, the constellation of the Scorpio was visible shaped like a hook "Matau a Maui" (Maui's hook) at the beginning of the Matari'i i ni'a season. The same constellation is shaped like a "'Uo" (kite) during the Matari'i i raro season, which is also the season of the southeast wind, the Mara'amu and the season of the kites, hence lending it a different function.

### Nomenclature of the Tahitian sky on Stellarium

One star having many functions, it could often have many names related to the context, the season or the inherent activities. Therefore the same name can correspond to several stars. For example in the reference book "Ancient Tahiti" in its English version, several texts describe "Ana roto" at times as Epi/Spica in Virgo (p361), at other times as Regulus in Leo (p174). A rigorous comparison study of the existing sources led the authors of this sky culture to prefer a "first name" for each star listed. That one will appear while navigating the Stellarium. By clicking on a given star you will be able to see all its other possible names. Libor Teaonui Prokop, well known in the Polynesian culture in Tahiti, also presented an alpha-numeric naming which allows to give a unique name to each star and summarize the different sources existing for that star. In this classification, for example, Regulus is called "A3a 'Ana roto" and Epi/Spica "A3b 'Ana roto". Whenever available, this naming will be visible by clicking on the star. A is the 1st letter of the word 'Ana (star): the number corresponds to the order of the 'Ana stars listed in the "Genealogy of the stars" in the book by Teuira HENRY p361, the letter corresponds to the selected source text. Hence "a" corresponds to the text on page 361 in the "Genealogy of the stars" in which the 'Ana are shiny stars located at the top of the pillars placed in order to support the sky. The letter "b" refers to the one on page 174 in which the stars 'Ana represent the body of the priests in office in the stone temple or marae. The functions of the 'Ana stars being different and not wanting to favor one text over another, we thought it appropriate to present this frame of reference. As they were discovering new islands further east, towards the Sun, going from Austronesians to Polynesians, those pioneers of celestial navigation had to adapt their knowledge of the sky to their new environment. The Tahitian sky is embedded in an oceanic culture scaled on the big Pacific Ocean yet it does retain its own personality. The understanding of the lengthy Tahitian names for the celestial bodies is an enrichment both identitarian and historical since this knowledge is associated with other sky cultures from Hawaii, New Zealand, Tonga and Anuta in order to push forward the knowledge of a common past.

## References

- [#1]: HENRY, Teuira, 1928. Ancient Tahiti, based on material recorded by J. M. Orsmond, bul. n°48 Honolulu, Bishop Museum. - 1968 (1951). Tahiti aux temps anciens, Paris, SO, n°1, Musée de l'Homme, 722 p., [Traduit par Bertrand Jaunez].
- [#2]: GRAINDORGE, Maurice, 2015. Le Ciel de Tahiti et des Mers du Sud, Papeete, Haere Po.
- [#3]: TERIIEROOITERAI, Claude, 2013. Mythes, astronomie, découpage du temps et navigation traditionnelle : l’héritage océanien contenu dans les mots de la langue tahitienne, thèse de doctorat en langues et cultures océaniennes.
- [#4]: ELLIS, William, 1972, A la recherche de la Polynésie d’autrefois, Paris, Publication de la Société des Océanistes N°25, 2 vol., 942 p.
- [#5]: FORSTER, Johann, Reinhold, 1982. The Resolution Journal of Johann Reinholf Forster 1772-1775, 4 volumes, Edited by Michael E. Hoare, The Hakluyt Society, London. - 1996, [1778]. Observations made during a Voyage Round the World, Honolulu, UH, 446 p.
- [#6]: DROLLET, Alexandre, 1989 [1922]. "Rectifications à apporter à certains noms mal orthographiés en langue tahitienne", in BSEO Papeete, N°248, p.100-101.
- [#7]: LAGUESSE, Janine, 1945, "A propos des connaissances astronomiques des anciens Tahitiens", Papeete, in BSEO, N°75, pp. 141-154.
- [#8]: PROKOP, Libor. Nomenclature alphanumérique des étoiles du ciel tahitien.
- [#9]:  SAURA Bruno, Huahine aux temps anciens, Cahiers du patrimoine n°8, 2005

## Authors

This sky culture was contributed by a working group composed of Christine Briant, Libor Prokop, Regis Plichart and Thibaud Guillaud-Saumur, with the help of association "Fa'afaite i te Ao Ma'ohi" (Rereao Carlson, Titaua Teipoarii) for the Maui's Hook/Hiro's Kite constellation and the association "Te Fare Hiroà no Vavau" for the mention of Ruanui in the skyculture name. WALKER Maurani did the translation of this text from French to English.

## License

CC BY-SA 4.0
