#ifndef network__HH
#define network__HH
#include "TArrow.h"
#include "TEllipse.h"
#include "TPaveLabel.h"
#include "TCanvas.h"
#include "TH2F.h"
#include "TFile.h"
#include "TString.h"
#include "TDirectory.h"
#include "TKey.h"
#include "TText.h"

#include "tmvaglob.h"
namespace TMVA{

   // this macro prints out a neural network generated by MethodMLP graphically
   // @author: Matt Jachowski, jachowski@stanford.edu

   void     draw_layer_labels( Int_t nLayers ); 
   void     draw_input_labels(TString dataset,Int_t nInputs, Double_t* cy, 
                              Double_t rad, Double_t layerWidth);
   void     draw_layer       (TString dataset, TCanvas* c, TH2F* h, Int_t iHist, Int_t nLayers, Double_t maxWeight );
   void     draw_synapse     ( Double_t cx1, Double_t cy1, Double_t cx2, Double_t cy2,
                               Double_t  rad1, Double_t rad2, Double_t weightNormed );
   TString* get_var_names    (TString dataset, Int_t nVars );

   void draw_network(TString dataset, TFile* f, TDirectory* d, const TString& hName = "weights_hist", 
                     Bool_t movieMode = kFALSE, const TString& epoch = "" );

   void draw_activation(TCanvas* c, Double_t cx, Double_t cy, 
                        Double_t radx, Double_t rady, Int_t whichActivation);
   void network(TString dataset, TString fin = "TMVA.root", Bool_t useTMVAStyle = kTRUE );

}
#endif
