/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationVariant;
import org.opensearch.client.opensearch._types.aggregations.FormatMetricAggregationBase;
import org.opensearch.client.opensearch._types.aggregations.HdrMethod;
import org.opensearch.client.opensearch._types.aggregations.TDigest;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class PercentilesAggregation
extends FormatMetricAggregationBase
implements AggregationVariant,
ToCopyableBuilder<Builder, PercentilesAggregation> {
    @Nullable
    private final HdrMethod hdr;
    @Nullable
    private final Boolean keyed;
    @Nonnull
    private final List<Double> percents;
    @Nullable
    private final TDigest tdigest;
    public static final JsonpDeserializer<PercentilesAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PercentilesAggregation::setupPercentilesAggregationDeserializer);

    private PercentilesAggregation(Builder builder) {
        super(builder);
        this.hdr = builder.hdr;
        this.keyed = builder.keyed;
        this.percents = ApiTypeHelper.unmodifiable(builder.percents);
        this.tdigest = builder.tdigest;
    }

    public static PercentilesAggregation of(Function<Builder, ObjectBuilder<PercentilesAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.Percentiles;
    }

    @Nullable
    public final HdrMethod hdr() {
        return this.hdr;
    }

    @Nullable
    public final Boolean keyed() {
        return this.keyed;
    }

    @Nonnull
    public final List<Double> percents() {
        return this.percents;
    }

    @Nullable
    public final TDigest tdigest() {
        return this.tdigest;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.hdr != null) {
            generator.writeKey("hdr");
            this.hdr.serialize(generator, mapper);
        }
        if (this.keyed != null) {
            generator.writeKey("keyed");
            generator.write(this.keyed.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.percents)) {
            generator.writeKey("percents");
            generator.writeStartArray();
            for (Double item0 : this.percents) {
                generator.write(item0.doubleValue());
            }
            generator.writeEnd();
        }
        if (this.tdigest != null) {
            generator.writeKey("tdigest");
            this.tdigest.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupPercentilesAggregationDeserializer(ObjectDeserializer<Builder> op) {
        PercentilesAggregation.setupFormatMetricAggregationBaseDeserializer(op);
        op.add(Builder::hdr, HdrMethod._DESERIALIZER, "hdr");
        op.add(Builder::keyed, JsonpDeserializer.booleanDeserializer(), "keyed");
        op.add(Builder::percents, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.doubleDeserializer()), "percents");
        op.add(Builder::tdigest, TDigest._DESERIALIZER, "tdigest");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.hdr);
        result = 31 * result + Objects.hashCode(this.keyed);
        result = 31 * result + Objects.hashCode(this.percents);
        result = 31 * result + Objects.hashCode(this.tdigest);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PercentilesAggregation other = (PercentilesAggregation)o;
        return Objects.equals(this.hdr, other.hdr) && Objects.equals(this.keyed, other.keyed) && Objects.equals(this.percents, other.percents) && Objects.equals(this.tdigest, other.tdigest);
    }

    public static class Builder
    extends FormatMetricAggregationBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, PercentilesAggregation> {
        @Nullable
        private HdrMethod hdr;
        @Nullable
        private Boolean keyed;
        @Nullable
        private List<Double> percents;
        @Nullable
        private TDigest tdigest;

        public Builder() {
        }

        private Builder(PercentilesAggregation o) {
            super(o);
            this.hdr = o.hdr;
            this.keyed = o.keyed;
            this.percents = Builder._listCopy(o.percents);
            this.tdigest = o.tdigest;
        }

        private Builder(Builder o) {
            super(o);
            this.hdr = o.hdr;
            this.keyed = o.keyed;
            this.percents = Builder._listCopy(o.percents);
            this.tdigest = o.tdigest;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder hdr(@Nullable HdrMethod value) {
            this.hdr = value;
            return this;
        }

        @Nonnull
        public final Builder hdr(Function<HdrMethod.Builder, ObjectBuilder<HdrMethod>> fn) {
            return this.hdr(fn.apply(new HdrMethod.Builder()).build());
        }

        @Nonnull
        public final Builder keyed(@Nullable Boolean value) {
            this.keyed = value;
            return this;
        }

        @Nonnull
        public final Builder percents(List<Double> list) {
            this.percents = Builder._listAddAll(this.percents, list);
            return this;
        }

        @Nonnull
        public final Builder percents(Double value, Double ... values) {
            this.percents = Builder._listAdd(this.percents, value, values);
            return this;
        }

        @Nonnull
        public final Builder tdigest(@Nullable TDigest value) {
            this.tdigest = value;
            return this;
        }

        @Nonnull
        public final Builder tdigest(Function<TDigest.Builder, ObjectBuilder<TDigest>> fn) {
            return this.tdigest(fn.apply(new TDigest.Builder()).build());
        }

        @Override
        @Nonnull
        public PercentilesAggregation build() {
            this._checkSingleUse();
            return new PercentilesAggregation(this);
        }
    }
}

