/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.memoryoptsearch;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.store.IndexInput;
import org.opensearch.knn.memoryoptsearch.MemorySegmentAddressExtractor;

public abstract class AbstractMemorySegmentAddressExtractor
implements MemorySegmentAddressExtractor {
    @Generated
    private static final Logger log = LogManager.getLogger(AbstractMemorySegmentAddressExtractor.class);

    @Override
    public long[] extractAddressAndSize(IndexInput indexInput, long baseOffset, long requestSize) {
        try {
            return this.doExtractAddressAndSize(indexInput, baseOffset, requestSize);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Unexpected exception was thrown from address extraction", (Throwable)e);
            return null;
        }
    }

    private long[] doExtractAddressAndSize(IndexInput indexInput, long baseOffset, long requestSize) {
        Object objSegments = this.getMemorySegments(indexInput);
        if (objSegments == null) {
            return null;
        }
        int numSegments = Array.getLength(objSegments);
        long[] addressAndSize = new long[2 * numSegments];
        int addressIndex = 0;
        int sizeIndex = 1;
        long startOffset = 0L;
        long totalSize = 0L;
        for (int segmentIndex = 0; segmentIndex < numSegments; ++segmentIndex) {
            long chunkSize;
            Object memorySegment = Array.get(objSegments, segmentIndex);
            if (memorySegment == null) {
                log.warn("Memory segment at " + segmentIndex + " is null, which is unexpected. The number of MemorySegment was" + numSegments);
                return null;
            }
            long address = this.getAddressFromMemorySegment(memorySegment);
            long originalChunkSize = chunkSize = this.getChunkSizeFromMemorySegment(memorySegment);
            long endOffsetExclusive = startOffset + chunkSize;
            if (endOffsetExclusive > baseOffset) {
                if (startOffset < baseOffset) {
                    chunkSize = endOffsetExclusive - baseOffset;
                    address += baseOffset - startOffset;
                }
                addressAndSize[addressIndex] = address;
                addressAndSize[sizeIndex] = chunkSize;
                addressIndex += 2;
                if ((totalSize += chunkSize) >= requestSize) {
                    int n = sizeIndex;
                    addressAndSize[n] = addressAndSize[n] - (totalSize - requestSize);
                    totalSize = requestSize;
                    break;
                }
                sizeIndex += 2;
            }
            startOffset += originalChunkSize;
        }
        if (requestSize > totalSize) {
            throw new IllegalArgumentException("Requested size (" + requestSize + " bytes) exceeds available memory chunk size (" + totalSize + " bytes).");
        }
        if (addressIndex != addressAndSize.length) {
            long[] newAddressAndSize = new long[addressIndex];
            System.arraycopy(addressAndSize, 0, newAddressAndSize, 0, addressIndex);
            return newAddressAndSize;
        }
        return addressAndSize;
    }

    protected abstract long getChunkSizeFromMemorySegment(Object var1);

    protected abstract long getAddressFromMemorySegment(Object var1);

    protected Object getMemorySegments(IndexInput indexInput) {
        try {
            Field f = indexInput.getClass().getSuperclass().getDeclaredField("segments");
            f.setAccessible(true);
            Object objSegments = f.get(indexInput);
            if (objSegments == null || !objSegments.getClass().isArray()) {
                return null;
            }
            return objSegments;
        }
        catch (IllegalAccessException | InaccessibleObjectException e) {
            log.warn("Failed to extract MemorySegment[] from IndexInput=" + indexInput.getClass().getSimpleName() + " , error message={}", (Object)e.getMessage());
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return null;
    }
}

