/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import org.bouncycastle.bcpg.CRC24;

public class FastCRC24
extends CRC24 {
    private static final int[] TABLE0;
    private static final int[] TABLE8;
    private static final int[] TABLE16;

    @Override
    public void update(int b) {
        int index = (b ^ this.crc >> 16) & 0xFF;
        this.crc = this.crc << 8 ^ TABLE0[index];
    }

    @Override
    public void update3(byte[] buf, int off) {
        this.crc = TABLE16[(buf[off + 0] ^ this.crc >> 16) & 0xFF] ^ TABLE8[(buf[off + 1] ^ this.crc >> 8) & 0xFF] ^ TABLE0[(buf[off + 2] ^ this.crc) & 0xFF];
    }

    static {
        int i;
        int[] table0 = new int[256];
        int[] table8 = new int[256];
        int[] table16 = new int[256];
        int crc = 0x800000;
        for (i = 1; i < 256; i <<= 1) {
            int carry = crc << 8 >> 31 & 0x1864CFB;
            crc = crc << 1 ^ carry;
            for (int j = 0; j < i; ++j) {
                table0[i + j] = crc ^ table0[j];
            }
        }
        for (i = 1; i < 256; ++i) {
            int crc0 = table0[i];
            int crc8 = (crc0 & 0xFFFF) << 8 ^ table0[crc0 >> 16 & 0xFF];
            int crc16 = (crc8 & 0xFFFF) << 8 ^ table0[crc8 >> 16 & 0xFF];
            table8[i] = crc8;
            table16[i] = crc16;
        }
        TABLE0 = table0;
        TABLE8 = table8;
        TABLE16 = table16;
    }
}

