# -*- coding: binary -*-

require 'spec_helper'

RSpec.describe Rex::Proto::X11::Xkeyboard do
  subject do
    mod = ::Msf::Exploit.new
    mod.extend described_class

    mod.send(:initialize)
    mod
  end

  let(:get_keyboardmap_resp) do
    "\x01\x03\x07\x00\x47\x05\x00\x00\x00\x00\x08\xff\x07\x00\x00\x1c" \
    "\x1c\x08\x6f\x01\xf8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08" \
    "\xf8\x0f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00" \
    "\x01\x01\x00\x00\x02\x01\x00\x00\x01\x01\x01\x01\x00\x00\x00\x00" \
    "\x03\x03\x00\x00\x02\x02\x00\x00\x01\x01\x01\x01\x00\x00\x00\x00" \
    "\x01\x02\x01\x02\x00\x00\x00\x00\x11\x01\x01\x00\x02\x01\x00\x00" \
    "\x01\x10\x01\x00\x01\x00\x00\x00\x09\x01\x02\x00\x02\x01\x00\x00" \
    "\x01\x09\x01\x01\x02\x00\x00\x00\x40\x40\x00\x00\x02\x01\x00\x00" \
    "\x01\x40\x01\x40\x00\x00\x00\x00\x04\x04\x00\x00\x02\x01\x00\x00" \
    "\x01\x04\x01\x04\x00\x00\x00\x00\x00\x00\x40\x00\x02\x01\x00\x00" \
    "\x00\x00\x01\x00\x40\x00\x00\x00\x00\x00\x20\x00\x02\x01\x00\x00" \
    "\x00\x00\x01\x00\x20\x00\x00\x00\x08\x00\x02\x00\x02\x01\x00\x00" \
    "\x01\x08\x01\x00\x02\x00\x00\x00\x00\x00\x08\x00\x02\x01\x00\x00" \
    "\x00\x00\x01\x00\x08\x00\x00\x00\x00\x00\x10\x00\x02\x01\x00\x00" \
    "\x00\x00\x01\x00\x10\x00\x00\x00\x8d\x05\x06\x00\x05\x04\x01\x00" \
    "\x01\x01\x01\x01\x00\x00\x00\x00\x01\x80\x02\x00\x04\x00\x00\x00" \
    "\x01\x81\x03\x01\x04\x00\x00\x00\x01\x0c\x04\x04\x02\x00\x00\x00" \
    "\x01\x01\x00\x00\x00\x00\x00\x00\x01\x01\x00\x00\x00\x00\x00\x00" \
    "\x87\x07\x04\x00\x08\x0f\x00\x00\x01\x03\x00\x03\x00\x00\x00\x00" \
    "\x01\x01\x01\x01\x00\x00\x00\x00\x01\x02\x01\x02\x00\x00\x00\x00" \
    "\x01\x80\x02\x00\x04\x00\x00\x00\x01\x83\x02\x03\x04\x00\x00\x00" \
    "\x01\x81\x03\x01\x04\x00\x00\x00\x01\x82\x03\x02\x04\x00\x00\x00" \
    "\x01\x04\x04\x04\x00\x00\x00\x00\x01\x07\x04\x07\x00\x00\x00\x00" \
    "\x01\x05\x05\x05\x00\x00\x00\x00\x01\x06\x05\x06\x00\x00\x00\x00" \
    "\x01\x84\x06\x04\x04\x00\x00\x00\x01\x87\x06\x07\x04\x00\x00\x00" \
    "\x01\x85\x07\x05\x04\x00\x00\x00\x01\x86\x07\x06\x04\x00\x00\x00" \
    "\x81\x01\x04\x00\x03\x03\x00\x00\x01\x01\x01\x01\x00\x00\x00\x00" \
    "\x01\x80\x02\x00\x04\x00\x00\x00\x01\x81\x02\x01\x04\x00\x00\x00" \
    "\x81\x01\x04\x01\x08\x07\x00\x00\x01\x01\x01\x01\x00\x00\x00\x00" \
    "\x01\x80\x02\x00\x04\x00\x00\x00\x01\x81\x03\x01\x04\x00\x00\x00" \
    "\x00\x00\x04\x00\x00\x01\x00\x00\x00\x01\x05\x01\x00\x01\x00\x00" \
    "\x01\x80\x06\x00\x04\x01\x00\x00\x01\x81\x07\x01\x04\x01\x00\x00" \
    "\x83\x03\x04\x01\x08\x0d\x00\x00\x01\x01\x01\x01\x00\x00\x00\x00" \
    "\x01\x02\x01\x02\x00\x00\x00\x00\x01\x80\x02\x00\x04\x00\x00\x00" \
    "\x01\x81\x03\x01\x04\x00\x00\x00\x01\x82\x03\x02\x04\x00\x00\x00" \
    "\x01\x83\x02\x03\x04\x00\x00\x00\x00\x00\x04\x00\x00\x01\x00\x00" \
    "\x00\x01\x05\x01\x00\x01\x00\x00\x00\x02\x05\x02\x00\x01\x00\x00" \
    "\x01\x80\x06\x00\x04\x01\x00\x00\x01\x81\x07\x01\x04\x01\x00\x00" \
    "\x01\x82\x07\x02\x04\x01\x00\x00\x01\x83\x06\x03\x04\x01\x00\x00" \
    "\x93\x03\x05\x01\x08\x1c\x01\x00\x01\x01\x01\x01\x00\x00\x00\x00" \
    "\x01\x80\x02\x00\x04\x00\x00\x00\x01\x81\x03\x01\x04\x00\x00\x00" \
    "\x00\x00\x04\x00\x00\x01\x00\x00\x00\x01\x05\x01\x00\x01\x00\x00" \
    "\x01\x80\x06\x00\x04\x01\x00\x00\x01\x81\x07\x01\x04\x01\x00\x00" \
    "\x01\x10\x04\x00\x01\x00\x00\x00\x01\x11\x05\x01\x01\x00\x00\x00" \
    "\x01\x90\x06\x00\x05\x00\x00\x00\x01\x91\x07\x01\x05\x00\x00\x00" \
    "\x01\x11\x01\x01\x01\x01\x00\x00\x01\x90\x02\x00\x05\x01\x00\x00" \
    "\x01\x91\x03\x01\x05\x01\x00\x00\x01\x03\x01\x03\x00\x00\x00\x00" \
    "\x01\x82\x02\x02\x04\x00\x00\x00\x01\x83\x03\x03\x04\x00\x00\x00" \
    "\x00\x02\x04\x02\x00\x01\x00\x00\x00\x03\x05\x03\x00\x01\x00\x00" \
    "\x01\x82\x06\x02\x04\x01\x00\x00\x01\x83\x07\x03\x04\x01\x00\x00" \
    "\x01\x12\x04\x02\x01\x00\x00\x00\x01\x13\x05\x03\x01\x00\x00\x00" \
    "\x01\x92\x06\x02\x05\x00\x00\x00\x01\x93\x07\x03\x05\x00\x00\x00" \
    "\x01\x13\x01\x03\x01\x01\x00\x00\x01\x92\x02\x02\x05\x01\x00\x00" \
    "\x01\x93\x03\x03\x05\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x01\x01\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x01\x01\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x01\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x01\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x93\x03\x05\x01\x08\x1c\x01\x00" \
    "\x01\x01\x01\x01\x00\x00\x00\x00\x01\x80\x02\x00\x04\x00\x00\x00" \
    "\x01\x81\x03\x01\x04\x00\x00\x00\x00\x00\x04\x00\x00\x01\x00\x00" \
    "\x00\x01\x05\x01\x00\x01\x00\x00\x01\x80\x06\x00\x04\x01\x00\x00" \
    "\x01\x81\x07\x01\x04\x01\x00\x00\x01\x10\x04\x00\x01\x00\x00\x00" \
    "\x01\x11\x05\x01\x01\x00\x00\x00\x01\x90\x06\x00\x05\x00\x00\x00" \
    "\x01\x91\x07\x01\x05\x00\x00\x00\x01\x11\x01\x01\x01\x01\x00\x00" \
    "\x01\x90\x02\x00\x05\x01\x00\x00\x01\x91\x03\x01\x05\x01\x00\x00" \
    "\x01\x02\x01\x02\x00\x00\x00\x00\x01\x82\x02\x02\x04\x00\x00\x00" \
    "\x01\x83\x03\x03\x04\x00\x00\x00\x00\x02\x04\x02\x00\x01\x00\x00" \
    "\x00\x03\x05\x03\x00\x01\x00\x00\x01\x82\x06\x02\x04\x01\x00\x00" \
    "\x01\x83\x07\x03\x04\x01\x00\x00\x01\x12\x04\x02\x01\x00\x00\x00" \
    "\x01\x13\x05\x03\x01\x00\x00\x00\x01\x92\x06\x02\x05\x00\x00\x00" \
    "\x01\x93\x07\x03\x05\x00\x00\x00\x01\x12\x01\x02\x01\x01\x00\x00" \
    "\x01\x92\x03\x02\x05\x01\x00\x00\x01\x93\x02\x03\x05\x01\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x01\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x01\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x83\x03\x04\x01\x08\x0e\x01\x00\x01\x01\x01\x01\x00\x00\x00\x00" \
    "\x01\x02\x01\x02\x00\x00\x00\x00\x01\x80\x02\x00\x04\x00\x00\x00" \
    "\x01\x81\x03\x01\x04\x00\x00\x00\x01\x82\x02\x02\x04\x00\x00\x00" \
    "\x01\x83\x03\x03\x04\x00\x00\x00\x00\x00\x04\x00\x00\x01\x00\x00" \
    "\x00\x01\x05\x01\x00\x01\x00\x00\x00\x02\x05\x02\x00\x01\x00\x00" \
    "\x00\x03\x05\x03\x00\x01\x00\x00\x01\x80\x06\x00\x04\x01\x00\x00" \
    "\x01\x81\x07\x01\x04\x01\x00\x00\x01\x82\x06\x02\x04\x01\x00\x00" \
    "\x01\x83\x07\x03\x04\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x02\x02\x00\x00\x02\x02\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x02\x02\x00\x00\x02\x02\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x02\x02\x00\x00\x02\x02\x00\x00" \
    "\x81\x01\x04\x00\x04\x03\x00\x00\x01\x01\x01\x01\x00\x00\x00\x00" \
    "\x01\x80\x02\x00\x04\x00\x00\x00\x01\x81\x03\x01\x04\x00\x00\x00" \
    "\x83\x03\x04\x00\x04\x06\x00\x00\x01\x01\x01\x01\x00\x00\x00\x00" \
    "\x01\x02\x01\x02\x00\x00\x00\x00\x01\x80\x02\x00\x04\x00\x00\x00" \
    "\x01\x81\x03\x01\x04\x00\x00\x00\x01\x82\x03\x02\x04\x00\x00\x00" \
    "\x01\x83\x02\x03\x04\x00\x00\x00\x83\x03\x04\x00\x04\x06\x01\x00" \
    "\x01\x01\x01\x01\x00\x00\x00\x00\x01\x02\x01\x02\x00\x00\x00\x00" \
    "\x01\x80\x02\x00\x04\x00\x00\x00\x01\x81\x03\x01\x04\x00\x00\x00" \
    "\x01\x82\x02\x02\x04\x00\x00\x00\x01\x83\x03\x03\x04\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x02\x02\x00\x00\x02\x02\x00\x00\x91\x01\x05\x00\x04\x07\x00\x00" \
    "\x01\x11\x00\x01\x01\x00\x00\x00\x01\x10\x01\x00\x01\x00\x00\x00" \
    "\x01\x01\x01\x01\x00\x00\x00\x00\x01\x80\x02\x00\x04\x00\x00\x00" \
    "\x01\x90\x02\x00\x05\x00\x00\x00\x01\x81\x03\x01\x04\x00\x00\x00" \
    "\x01\x91\x03\x01\x05\x00\x00\x00\x8d\x05\x06\x00\x04\x03\x00\x00" \
    "\x01\x80\x01\x00\x04\x00\x00\x00\x01\x81\x02\x01\x04\x00\x00\x00" \
    "\x01\x0c\x03\x04\x02\x00\x00\x00\x83\x03\x04\x00\x04\x06\x01\x00" \
    "\x01\x01\x01\x01\x00\x00\x00\x00\x01\x02\x03\x02\x00\x00\x00\x00" \
    "\x01\x80\x02\x00\x04\x00\x00\x00\x01\x81\x03\x01\x04\x00\x00\x00" \
    "\x01\x82\x02\x02\x04\x00\x00\x00\x01\x83\x02\x03\x04\x00\x00\x00" \
    "\x00\x00\x00\x00\x02\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x02\x02\x00\x00\x00\x00\x00\x00\x83\x03\x04\x00\x05\x07\x00\x00" \
    "\x01\x01\x01\x01\x00\x00\x00\x00\x01\x80\x02\x00\x04\x00\x00\x00" \
    "\x01\x81\x03\x01\x04\x00\x00\x00\x01\x02\x04\x02\x00\x00\x00\x00" \
    "\x01\x03\x01\x03\x00\x00\x00\x00\x01\x82\x02\x02\x04\x00\x00\x00" \
    "\x01\x83\x03\x03\x04\x00\x00\x00\x91\x01\x05\x00\x04\x06\x00\x00" \
    "\x01\x01\x01\x01\x00\x00\x00\x00\x01\x10\x01\x00\x01\x00\x00\x00" \
    "\x01\x80\x02\x00\x04\x00\x00\x00\x01\x81\x03\x01\x04\x00\x00\x00" \
    "\x01\x90\x03\x00\x05\x00\x00\x00\x01\x91\x02\x01\x05\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x01\x01\x00" \
    "\x1b\xff\x00\x00\x01\x00\x00\x00\x01\x02\x02\x00\x31\x00\x00\x00" \
    "\x21\x00\x00\x00\x01\x00\x00\x00\x01\x02\x02\x00\x32\x00\x00\x00" \
    "\x40\x00\x00\x00\x01\x00\x00\x00\x01\x02\x02\x00\x33\x00\x00\x00" \
    "\x23\x00\x00\x00\x01\x00\x00\x00\x01\x02\x02\x00\x34\x00\x00\x00" \
    "\x24\x00\x00\x00\x01\x00\x00\x00\x01\x02\x02\x00\x35\x00\x00\x00" \
    "\x25\x00\x00\x00\x01\x00\x00\x00\x01\x02\x02\x00\x36\x00\x00\x00" \
    "\x5e\x00\x00\x00\x01\x00\x00\x00\x01\x02\x02\x00\x37\x00\x00\x00" \
    "\x26\x00\x00\x00\x01\x00\x00\x00\x01\x02\x02\x00\x38\x00\x00\x00" \
    "\x2a\x00\x00\x00\x01\x00\x00\x00\x01\x02\x02\x00\x39\x00\x00\x00" \
    "\x28\x00\x00\x00\x01\x00\x00\x00\x01\x02\x02\x00\x30\x00\x00\x00" \
    "\x29\x00\x00\x00\x01\x00\x00\x00\x01\x02\x02\x00\x2d\x00\x00\x00" \
    "\x5f\x00\x00\x00\x01\x00\x00\x00\x01\x02\x02\x00\x3d\x00\x00\x00" \
    "\x2b\x00\x00\x00\x01\x00\x00\x00\x01\x02\x02\x00\x08\xff\x00\x00" \
    "\x08\xff\x00\x00\x01\x00\x00\x00\x01\x02\x02\x00\x09\xff\x00\x00" \
    "\x20\xfe\x00\x00\x02\x00\x00\x00\x01\x02\x02\x00\x71\x00\x00\x00" \
    "\x51\x00\x00\x00\x02\x00\x00\x00\x01\x02\x02\x00\x77\x00\x00\x00" \
    "\x57\x00\x00\x00\x02\x00\x00\x00\x01\x02\x02\x00\x65\x00\x00\x00" \
    "\x45\x00\x00\x00\x02\x00\x00\x00\x01\x02\x02\x00\x72\x00\x00\x00" \
    "\x52\x00\x00\x00\x02\x00\x00\x00\x01\x02\x02\x00\x74\x00\x00\x00" \
    "\x54\x00\x00\x00\x02\x00\x00\x00\x01\x02\x02\x00\x79\x00\x00\x00" \
    "\x59\x00\x00\x00\x02\x00\x00\x00\x01\x02\x02\x00\x75\x00\x00\x00" \
    "\x55\x00\x00\x00\x02\x00\x00\x00\x01\x02\x02\x00\x69\x00\x00\x00" \
    "\x49\x00\x00\x00\x02\x00\x00\x00\x01\x02\x02\x00\x6f\x00\x00\x00" \
    "\x4f\x00\x00\x00\x02\x00\x00\x00\x01\x02\x02\x00\x70\x00\x00\x00" \
    "\x50\x00\x00\x00\x01\x00\x00\x00\x01\x02\x02\x00\x5b\x00\x00\x00" \
    "\x7b\x00\x00\x00\x01\x00\x00\x00\x01\x02\x02\x00\x5d\x00\x00\x00" \
    "\x7d\x00\x00\x00\x00\x00\x00\x00\x01\x01\x01\x00\x0d\xff\x00\x00" \
    "\x00\x00\x00\x00\x01\x01\x01\x00\xe3\xff\x00\x00\x02\x00\x00\x00" \
    "\x01\x02\x02\x00\x61\x00\x00\x00\x41\x00\x00\x00\x02\x00\x00\x00" \
    "\x01\x02\x02\x00\x73\x00\x00\x00\x53\x00\x00\x00\x02\x00\x00\x00" \
    "\x01\x02\x02\x00\x64\x00\x00\x00\x44\x00\x00\x00\x02\x00\x00\x00" \
    "\x01\x02\x02\x00\x66\x00\x00\x00\x46\x00\x00\x00\x02\x00\x00\x00" \
    "\x01\x02\x02\x00\x67\x00\x00\x00\x47\x00\x00\x00\x02\x00\x00\x00" \
    "\x01\x02\x02\x00\x68\x00\x00\x00\x48\x00\x00\x00\x02\x00\x00\x00" \
    "\x01\x02\x02\x00\x6a\x00\x00\x00\x4a\x00\x00\x00\x02\x00\x00\x00" \
    "\x01\x02\x02\x00\x6b\x00\x00\x00\x4b\x00\x00\x00\x02\x00\x00\x00" \
    "\x01\x02\x02\x00\x6c\x00\x00\x00\x4c\x00\x00\x00\x01\x00\x00\x00" \
    "\x01\x02\x02\x00\x3b\x00\x00\x00\x3a\x00\x00\x00\x01\x00\x00\x00" \
    "\x01\x02\x02\x00\x27\x00\x00\x00\x22\x00\x00\x00\x01\x00\x00\x00" \
    "\x01\x02\x02\x00\x60\x00\x00\x00\x7e\x00\x00\x00\x00\x00\x00\x00" \
    "\x01\x01\x01\x00\xe1\xff\x00\x00\x01\x00\x00\x00\x01\x02\x02\x00" \
    "\x5c\x00\x00\x00\x7c\x00\x00\x00\x02\x00\x00\x00\x01\x02\x02\x00" \
    "\x7a\x00\x00\x00\x5a\x00\x00\x00\x02\x00\x00\x00\x01\x02\x02\x00" \
    "\x78\x00\x00\x00\x58\x00\x00\x00\x02\x00\x00\x00\x01\x02\x02\x00" \
    "\x63\x00\x00\x00\x43\x00\x00\x00\x02\x00\x00\x00\x01\x02\x02\x00" \
    "\x76\x00\x00\x00\x56\x00\x00\x00\x02\x00\x00\x00\x01\x02\x02\x00" \
    "\x62\x00\x00\x00\x42\x00\x00\x00\x02\x00\x00\x00\x01\x02\x02\x00" \
    "\x6e\x00\x00\x00\x4e\x00\x00\x00\x02\x00\x00\x00\x01\x02\x02\x00" \
    "\x6d\x00\x00\x00\x4d\x00\x00\x00\x01\x00\x00\x00\x01\x02\x02\x00" \
    "\x2c\x00\x00\x00\x3c\x00\x00\x00\x01\x00\x00\x00\x01\x02\x02\x00" \
    "\x2e\x00\x00\x00\x3e\x00\x00\x00\x01\x00\x00\x00\x01\x02\x02\x00" \
    "\x2f\x00\x00\x00\x3f\x00\x00\x00\x00\x00\x00\x00\x01\x01\x01\x00" \
    "\xe2\xff\x00\x00\x0c\x00\x00\x00\x01\x05\x05\x00\xaa\xff\x00\x00" \
    "\xaa\xff\x00\x00\xaa\xff\x00\x00\xaa\xff\x00\x00\x21\xfe\x08\x10" \
    "\x01\x00\x00\x00\x01\x02\x02\x00\xe9\xff\x00\x00\xe7\xff\x00\x00" \
    "\x00\x00\x00\x00\x01\x01\x01\x00\x20\x00\x00\x00\x00\x00\x00\x00" \
    "\x01\x01\x01\x00\xe5\xff\x00\x00\x0c\x00\x00\x00\x01\x05\x05\x00" \
    "\xbe\xff\x00\x00\xbe\xff\x00\x00\xbe\xff\x00\x00\xbe\xff\x00\x00" \
    "\x01\xfe\x08\x10\x0c\x00\x00\x00\x01\x05\x05\x00\xbf\xff\x00\x00" \
    "\xbf\xff\x00\x00\xbf\xff\x00\x00\xbf\xff\x00\x00\x02\xfe\x08\x10" \
    "\x0c\x00\x00\x00\x01\x05\x05\x00\xc0\xff\x00\x00\xc0\xff\x00\x00" \
    "\xc0\xff\x00\x00\xc0\xff\x00\x00\x03\xfe\x08\x10\x0c\x00\x00\x00" \
    "\x01\x05\x05\x00\xc1\xff\x00\x00\xc1\xff\x00\x00\xc1\xff\x00\x00" \
    "\xc1\xff\x00\x00\x04\xfe\x08\x10\x0c\x00\x00\x00\x01\x05\x05\x00" \
    "\xc2\xff\x00\x00\xc2\xff\x00\x00\xc2\xff\x00\x00\xc2\xff\x00\x00" \
    "\x05\xfe\x08\x10\x0c\x00\x00\x00\x01\x05\x05\x00\xc3\xff\x00\x00" \
    "\xc3\xff\x00\x00\xc3\xff\x00\x00\xc3\xff\x00\x00\x06\xfe\x08\x10" \
    "\x0c\x00\x00\x00\x01\x05\x05\x00\xc4\xff\x00\x00\xc4\xff\x00\x00" \
    "\xc4\xff\x00\x00\xc4\xff\x00\x00\x07\xfe\x08\x10\x0c\x00\x00\x00" \
    "\x01\x05\x05\x00\xc5\xff\x00\x00\xc5\xff\x00\x00\xc5\xff\x00\x00" \
    "\xc5\xff\x00\x00\x08\xfe\x08\x10\x0c\x00\x00\x00\x01\x05\x05\x00" \
    "\xc6\xff\x00\x00\xc6\xff\x00\x00\xc6\xff\x00\x00\xc6\xff\x00\x00" \
    "\x09\xfe\x08\x10\x0c\x00\x00\x00\x01\x05\x05\x00\xc7\xff\x00\x00" \
    "\xc7\xff\x00\x00\xc7\xff\x00\x00\xc7\xff\x00\x00\x0a\xfe\x08\x10" \
    "\x00\x00\x00\x00\x01\x01\x01\x00\x7f\xff\x00\x00\x00\x00\x00\x00" \
    "\x01\x01\x01\x00\x14\xff\x00\x00\x03\x00\x00\x00\x01\x02\x02\x00" \
    "\x95\xff\x00\x00\xb7\xff\x00\x00\x03\x00\x00\x00\x01\x02\x02\x00" \
    "\x97\xff\x00\x00\xb8\xff\x00\x00\x03\x00\x00\x00\x01\x02\x02\x00" \
    "\x9a\xff\x00\x00\xb9\xff\x00\x00\x0c\x00\x00\x00\x01\x05\x05\x00" \
    "\xad\xff\x00\x00\xad\xff\x00\x00\xad\xff\x00\x00\xad\xff\x00\x00" \
    "\x23\xfe\x08\x10\x03\x00\x00\x00\x01\x02\x02\x00\x96\xff\x00\x00" \
    "\xb4\xff\x00\x00\x03\x00\x00\x00\x01\x02\x02\x00\x9d\xff\x00\x00" \
    "\xb5\xff\x00\x00\x03\x00\x00\x00\x01\x02\x02\x00\x98\xff\x00\x00" \
    "\xb6\xff\x00\x00\x0c\x00\x00\x00\x01\x05\x05\x00\xab\xff\x00\x00" \
    "\xab\xff\x00\x00\xab\xff\x00\x00\xab\xff\x00\x00\x22\xfe\x08\x10" \
    "\x03\x00\x00\x00\x01\x02\x02\x00\x9c\xff\x00\x00\xb1\xff\x00\x00" \
    "\x03\x00\x00\x00\x01\x02\x02\x00\x99\xff\x00\x00\xb2\xff\x00\x00" \
    "\x03\x00\x00\x00\x01\x02\x02\x00\x9b\xff\x00\x00\xb3\xff\x00\x00" \
    "\x03\x00\x00\x00\x01\x02\x02\x00\x9e\xff\x00\x00\xb0\xff\x00\x00" \
    "\x03\x00\x00\x00\x01\x02\x02\x00\x9f\xff\x00\x00\xae\xff\x00\x00" \
    "\x00\x00\x00\x00\x01\x01\x01\x00\x03\xfe\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x14\x00\x00\x00\x01\x04\x04\x00\x3c\x00\x00\x00" \
    "\x3e\x00\x00\x00\x7c\x00\x00\x00\xa6\x00\x00\x00\x0c\x00\x00\x00" \
    "\x01\x05\x05\x00\xc8\xff\x00\x00\xc8\xff\x00\x00\xc8\xff\x00\x00" \
    "\xc8\xff\x00\x00\x0b\xfe\x08\x10\x0c\x00\x00\x00\x01\x05\x05\x00" \
    "\xc9\xff\x00\x00\xc9\xff\x00\x00\xc9\xff\x00\x00\xc9\xff\x00\x00" \
    "\x0c\xfe\x08\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x01\x01\x01\x00\x26\xff\x00\x00\x00\x00\x00\x00\x01\x01\x01\x00" \
    "\x25\xff\x00\x00\x00\x00\x00\x00\x01\x01\x01\x00\x23\xff\x00\x00" \
    "\x00\x00\x00\x00\x01\x01\x01\x00\x27\xff\x00\x00\x00\x00\x00\x00" \
    "\x01\x01\x01\x00\x22\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x01\x01\x01\x00\x8d\xff\x00\x00\x00\x00\x00\x00" \
    "\x01\x01\x01\x00\xe4\xff\x00\x00\x0c\x00\x00\x00\x01\x05\x05\x00" \
    "\xaf\xff\x00\x00\xaf\xff\x00\x00\xaf\xff\x00\x00\xaf\xff\x00\x00" \
    "\x20\xfe\x08\x10\x09\x00\x00\x00\x01\x02\x02\x00\x61\xff\x00\x00" \
    "\x15\xff\x00\x00\x01\x00\x00\x00\x01\x02\x02\x00\xea\xff\x00\x00" \
    "\xe8\xff\x00\x00\x00\x00\x00\x00\x01\x01\x01\x00\x0a\xff\x00\x00" \
    "\x00\x00\x00\x00\x01\x01\x01\x00\x50\xff\x00\x00\x00\x00\x00\x00" \
    "\x01\x01\x01\x00\x52\xff\x00\x00\x00\x00\x00\x00\x01\x01\x01\x00" \
    "\x55\xff\x00\x00\x00\x00\x00\x00\x01\x01\x01\x00\x51\xff\x00\x00" \
    "\x00\x00\x00\x00\x01\x01\x01\x00\x53\xff\x00\x00\x00\x00\x00\x00" \
    "\x01\x01\x01\x00\x57\xff\x00\x00\x00\x00\x00\x00\x01\x01\x01\x00" \
    "\x54\xff\x00\x00\x00\x00\x00\x00\x01\x01\x01\x00\x56\xff\x00\x00" \
    "\x00\x00\x00\x00\x01\x01\x01\x00\x63\xff\x00\x00\x00\x00\x00\x00" \
    "\x01\x01\x01\x00\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x01\x01\x01\x00\x12\xff\x08\x10\x00\x00\x00\x00" \
    "\x01\x01\x01\x00\x11\xff\x08\x10\x00\x00\x00\x00\x01\x01\x01\x00" \
    "\x13\xff\x08\x10\x00\x00\x00\x00\x01\x01\x01\x00\x2a\xff\x08\x10" \
    "\x00\x00\x00\x00\x01\x01\x01\x00\xbd\xff\x00\x00\x00\x00\x00\x00" \
    "\x01\x01\x01\x00\xb1\x00\x00\x00\x06\x00\x00\x00\x01\x02\x02\x00" \
    "\x13\xff\x00\x00\x6b\xff\x00\x00\x00\x00\x00\x00\x01\x01\x01\x00" \
    "\x4a\xff\x08\x10\x03\x00\x00\x00\x01\x02\x02\x00\xae\xff\x00\x00" \
    "\xae\xff\x00\x00\x00\x00\x00\x00\x01\x01\x01\x00\x31\xff\x00\x00" \
    "\x00\x00\x00\x00\x01\x01\x01\x00\x34\xff\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x01\x01\x01\x00\xeb\xff\x00\x00" \
    "\x00\x00\x00\x00\x01\x01\x01\x00\xec\xff\x00\x00\x00\x00\x00\x00" \
    "\x01\x01\x01\x00\x67\xff\x00\x00\x00\x00\x00\x00\x01\x01\x01\x00" \
    "\x69\xff\x00\x00\x00\x00\x00\x00\x01\x01\x01\x00\x66\xff\x00\x00" \
    "\x00\x00\x00\x00\x01\x01\x01\x00\x70\xff\x05\x10\x00\x00\x00\x00" \
    "\x01\x01\x01\x00\x65\xff\x00\x00\x00\x00\x00\x00\x01\x01\x01\x00" \
    "\x71\xff\x05\x10\x00\x00\x00\x00\x01\x01\x01\x00\x57\xff\x08\x10" \
    "\x00\x00\x00\x00\x01\x01\x01\x00\x6b\xff\x08\x10\x00\x00\x00\x00" \
    "\x01\x01\x01\x00\x6d\xff\x08\x10\x00\x00\x00\x00\x01\x01\x01\x00" \
    "\x68\xff\x00\x00\x00\x00\x00\x00\x01\x01\x01\x00\x58\xff\x08\x10" \
    "\x00\x00\x00\x00\x01\x01\x01\x00\x6a\xff\x00\x00\x00\x00\x00\x00" \
    "\x01\x01\x01\x00\x65\xff\x08\x10\x00\x00\x00\x00\x01\x01\x01\x00" \
    "\x1d\xff\x08\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x01\x01\x01\x00\x2f\xff\x08\x10\x00\x00\x00\x00\x01\x01\x01\x00" \
    "\x2b\xff\x08\x10\x00\x00\x00\x00\x01\x01\x01\x00\x5d\xff\x08\x10" \
    "\x00\x00\x00\x00\x01\x01\x01\x00\x7b\xff\x08\x10\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x01\x01\x01\x00\x8a\xff\x08\x10" \
    "\x00\x00\x00\x00\x01\x01\x01\x00\x41\xff\x08\x10\x00\x00\x00\x00" \
    "\x01\x01\x01\x00\x42\xff\x08\x10\x00\x00\x00\x00\x01\x01\x01\x00" \
    "\x2e\xff\x08\x10\x00\x00\x00\x00\x01\x01\x01\x00\x5a\xff\x08\x10" \
    "\x00\x00\x00\x00\x01\x01\x01\x00\x2d\xff\x08\x10\x00\x00\x00\x00" \
    "\x01\x01\x01\x00\x74\xff\x08\x10\x00\x00\x00\x00\x01\x01\x01\x00" \
    "\x7f\xff\x08\x10\x00\x00\x00\x00\x01\x01\x01\x00\x19\xff\x08\x10" \
    "\x00\x00\x00\x00\x01\x01\x01\x00\x30\xff\x08\x10\x00\x00\x00\x00" \
    "\x01\x01\x01\x00\x33\xff\x08\x10\x00\x00\x00\x00\x01\x01\x01\x00" \
    "\x26\xff\x08\x10\x00\x00\x00\x00\x01\x01\x01\x00\x27\xff\x08\x10" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x01\x01\x00" \
    "\x2c\xff\x08\x10\x00\x00\x00\x00\x01\x01\x01\x00\x2c\xff\x08\x10" \
    "\x00\x00\x00\x00\x01\x01\x01\x00\x17\xff\x08\x10\x01\x00\x00\x00" \
    "\x01\x02\x02\x00\x14\xff\x08\x10\x31\xff\x08\x10\x00\x00\x00\x00" \
    "\x01\x01\x01\x00\x16\xff\x08\x10\x01\x00\x00\x00\x01\x02\x02\x00" \
    "\x15\xff\x08\x10\x2c\xff\x08\x10\x00\x00\x00\x00\x01\x01\x01\x00" \
    "\x1c\xff\x08\x10\x00\x00\x00\x00\x01\x01\x01\x00\x3e\xff\x08\x10" \
    "\x00\x00\x00\x00\x01\x01\x01\x00\x6e\xff\x08\x10\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x01\x01\x01\x00\x81\xff\x08\x10" \
    "\x00\x00\x00\x00\x01\x01\x01\x00\x18\xff\x08\x10\x00\x00\x00\x00" \
    "\x01\x01\x01\x00\x73\xff\x08\x10\x00\x00\x00\x00\x01\x01\x01\x00" \
    "\x56\xff\x08\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x01\x01\x01\x00\x78\xff\x08\x10" \
    "\x00\x00\x00\x00\x01\x01\x01\x00\x79\xff\x08\x10\x00\x00\x00\x00" \
    "\x01\x01\x01\x00\x28\x00\x00\x00\x00\x00\x00\x00\x01\x01\x01\x00" \
    "\x29\x00\x00\x00\x00\x00\x00\x00\x01\x01\x01\x00\x68\xff\x08\x10" \
    "\x00\x00\x00\x00\x01\x01\x01\x00\x66\xff\x00\x00\x00\x00\x00\x00" \
    "\x01\x01\x01\x00\x81\xff\x08\x10\x00\x00\x00\x00\x01\x01\x01\x00" \
    "\x45\xff\x08\x10\x00\x00\x00\x00\x01\x01\x01\x00\x46\xff\x08\x10" \
    "\x00\x00\x00\x00\x01\x01\x01\x00\x47\xff\x08\x10\x00\x00\x00\x00" \
    "\x01\x01\x01\x00\x48\xff\x08\x10\x00\x00\x00\x00\x01\x01\x01\x00" \
    "\x49\xff\x08\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x01\x01\x01\x00\xb2\xff\x08\x10\x00\x00\x00\x00\x01\x01\x01\x00" \
    "\xa9\xff\x08\x10\x00\x00\x00\x00\x01\x01\x01\x00\xb0\xff\x08\x10" \
    "\x00\x00\x00\x00\x01\x01\x01\x00\xb1\xff\x08\x10\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x01\x01\x01\x00\x7e\xff\x00\x00" \
    "\x01\x00\x00\x00\x01\x02\x02\x00\x00\x00\x00\x00\xe9\xff\x00\x00" \
    "\x01\x00\x00\x00\x01\x02\x02\x00\x00\x00\x00\x00\xe7\xff\x00\x00" \
    "\x01\x00\x00\x00\x01\x02\x02\x00\x00\x00\x00\x00\xeb\xff\x00\x00" \
    "\x01\x00\x00\x00\x01\x02\x02\x00\x00\x00\x00\x00\xed\xff\x00\x00" \
    "\x00\x00\x00\x00\x01\x01\x01\x00\x14\xff\x08\x10\x00\x00\x00\x00" \
    "\x01\x01\x01\x00\x31\xff\x08\x10\x00\x00\x00\x00\x01\x01\x01\x00" \
    "\x43\xff\x08\x10\x00\x00\x00\x00\x01\x01\x01\x00\x44\xff\x08\x10" \
    "\x00\x00\x00\x00\x01\x01\x01\x00\x4b\xff\x08\x10\x00\x00\x00\x00" \
    "\x01\x01\x01\x00\xa7\xff\x08\x10\x00\x00\x00\x00\x01\x01\x01\x00" \
    "\x56\xff\x08\x10\x00\x00\x00\x00\x01\x01\x01\x00\x14\xff\x08\x10" \
    "\x00\x00\x00\x00\x01\x01\x01\x00\x97\xff\x08\x10\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x01\x01\x01\x00\x61\xff\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x01\x01\x00" \
    "\x8f\xff\x08\x10\x00\x00\x00\x00\x01\x01\x01\x00\xb6\xff\x08\x10" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x01\x01\x00" \
    "\x19\xff\x08\x10\x00\x00\x00\x00\x01\x01\x01\x00\x8e\xff\x08\x10" \
    "\x00\x00\x00\x00\x01\x01\x01\x00\x1b\xff\x08\x10\x00\x00\x00\x00" \
    "\x01\x01\x01\x00\x5f\xff\x08\x10\x00\x00\x00\x00\x01\x01\x01\x00" \
    "\x3c\xff\x08\x10\x00\x00\x00\x00\x01\x01\x01\x00\x5e\xff\x08\x10" \
    "\x00\x00\x00\x00\x01\x01\x01\x00\x36\xff\x08\x10\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x01\x01\x01\x00\x69\xff\x00\x00" \
    "\x00\x00\x00\x00\x01\x01\x01\x00\x03\xff\x08\x10\x00\x00\x00\x00" \
    "\x01\x01\x01\x00\x02\xff\x08\x10\x00\x00\x00\x00\x01\x01\x01\x00" \
    "\x32\xff\x08\x10\x00\x00\x00\x00\x01\x01\x01\x00\x59\xff\x08\x10" \
    "\x00\x00\x00\x00\x01\x01\x01\x00\x04\xff\x08\x10\x00\x00\x00\x00" \
    "\x01\x01\x01\x00\x06\xff\x08\x10\x00\x00\x00\x00\x01\x01\x01\x00" \
    "\x05\xff\x08\x10\x00\x00\x00\x00\x01\x01\x01\x00\x7b\xff\x08\x10" \
    "\x00\x00\x00\x00\x01\x01\x01\x00\x72\xff\x08\x10\x00\x00\x00\x00" \
    "\x01\x01\x01\x00\x90\xff\x08\x10\x00\x00\x00\x00\x01\x01\x01\x00" \
    "\x77\xff\x08\x10\x00\x00\x00\x00\x01\x01\x01\x00\x5b\xff\x08\x10" \
    "\x00\x00\x00\x00\x01\x01\x01\x00\x93\xff\x08\x10\x00\x00\x00\x00" \
    "\x01\x01\x01\x00\x94\xff\x08\x10\x00\x00\x00\x00\x01\x01\x01\x00" \
    "\x95\xff\x08\x10\x00\x00\x00\x00\x01\x01\x01\x00\x96\xff\x08\x10" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x01\x01\x00" \
    "\x22\xfe\x08\x10\x00\x00\x00\x00\x01\x01\x01\x00\x23\xfe\x08\x10" \
    "\x00\x00\x00\x00\x01\x01\x01\x00\x07\xff\x08\x10\x00\x00\x00\x00" \
    "\x01\x01\x01\x00\xf4\x10\x08\x10\x00\x00\x00\x00\x01\x01\x01\x00" \
    "\xf5\x10\x08\x10\x00\x00\x00\x00\x01\x01\x01\x00\xb4\xff\x08\x10" \
    "\x00\x00\x00\x00\x01\x01\x01\x00\xb5\xff\x08\x10\x25\x04\x32\x01" \
    "\x3e\x01\x40\x08\x42\x02\x4d\x10\x5c\x80\x69\x04\x6c\x08\x85\x40" \
    "\x86\x40\xcb\x80\xcd\x08\xce\x40\xcf\x40\x00\x00"
  end

  let(:get_keyboardmap_resp_2) do
    "\001\003\a\000C\005\000\000\000\000\b\377\a\000\000\034\034\bo\001" \
    "\370\000\000\000\000\000\000\000\000\000\000\b\370\017\000\000\000" \
    "\000\000\000\000\000\000\000\001\000\000\000\001\001\000\000\002\001" \
    "\000\000\001\001\001\001\000\000\000\000\003\003\000\000\002\002\000" \
    "\000\001\001\001\001\000\000\000\000\001\002\001\002\000\000\000\000" \
    "\021\001\001\000\002\001\000\000\001\020\001\000\001\000\000\000\t" \
    "\001\002\000\002\001\000\000\001\t\001\001\002\000\000\000@@\000\000" \
    "\002\001\000\000\001@\001@\000\000\000\000\004\004\000\000\002\001" \
    "\000\000\001\004\001\004\000\000\000\000\000\000@\000\002\001\000" \
    "\000\000\000\001\000@\000\000\000\000\000 \000\002\001\000\000\000" \
    "\000\001\000 \000\000\000\b\000\002\000\002\001\000\000\001\b\001" \
    "\000\002\000\000\000\000\000\b\000\002\001\000\000\000\000\001\000" \
    "\b\000\000\000\000\000\020\000\002\001\000\000\000\000\001\000\020" \
    "\000\000\000\215\005\006\000\005\004\001\000\001\001\001\001\000\000" \
    "\000\000\001\200\002\000\004\000\000\000\001\201\003\001\004\000\000" \
    "\000\001\f\004\004\002\000\000\000\001\001\000\000\000\000\000\000\001" \
    "\001\000\000\000\000\000\000\207\a\004\000\b\016\000\000\001\001\001\001" \
    "\000\000\000\000\001\002\001\002\000\000\000\000\001\200\002\000\004\000" \
    "\000\000\001\203\002\003\004\000\000\000\001\201\003\001\004\000\000\000" \
    "\001\202\003\002\004\000\000\000\001\004\004\004\000\000\000\000\001\a" \
    "\004\a\000\000\000\000\001\005\005\005\000\000\000\000\001\006\005\006" \
    "\000\000\000\000\001\204\006\004\004\000\000\000\001\207\006\a\004\000" \
    "\000\000\001\205\a\005\004\000\000\000\001\206\a\006\004\000\000\000" \
    "\201\001\004\000\003\003\000\000\001\001\001\001\000\000\000\000\001" \
    "\200\002\000\004\000\000\000\001\201\002\001\004\000\000\000\201\001" \
    "\004\001\b\a\000\000\001\001\001\001\000\000\000\000\001\200\002\000" \
    "\004\000\000\000\001\201\003\001\004\000\000\000\000\000\004\000\000" \
    "\001\000\000\000\001\005\001\000\001\000\000\001\200\006\000\004\001" \
    "\000\000\001\201\a\001\004\001\000\000\203\003\004\001\b\r\000\000" \
    "\001\001\001\001\000\000\000\000\001\002\001\002\000\000\000\000\001" \
    "\200\002\000\004\000\000\000\001\201\003\001\004\000\000\000\001\202" \
    "\003\002\004\000\000\000\001\203\002\003\004\000\000\000\000\000\004" \
    "\000\000\001\000\000\000\001\005\001\000\001\000\000\000\002\005\002" \
    "\000\001\000\000\001\200\006\000\004\001\000\000\001\201\a\001\004" \
    "\001\000\000\001\202\a\002\004\001\000\000\001\203\006\003\004\001" \
    "\000\000\223\003\005\001\b\034\001\000\001\001\001\001\000\000\000" \
    "\000\001\200\002\000\004\000\000\000\001\201\003\001\004\000\000" \
    "\000\000\000\004\000\000\001\000\000\000\001\005\001\000\001\000" \
    "\000\001\200\006\000\004\001\000\000\001\201\a\001\004\001\000\000" \
    "\001\020\004\000\001\000\000\000\001\021\005\001\001\000\000\000" \
    "\001\220\006\000\005\000\000\000\001\221\a\001\005\000\000\000\001" \
    "\021\001\001\001\001\000\000\001\220\002\000\005\001\000\000\001" \
    "\221\003\001\005\001\000\000\001\003\001\003\000\000\000\000\001" \
    "\202\002\002\004\000\000\000\001\203\003\003\004\000\000\000\000" \
    "\002\004\002\000\001\000\000\000\003\005\003\000\001\000\000\001" \
    "\202\006\002\004\001\000\000\001\203\a\003\004\001\000\000\001" \
    "\022\004\002\001\000\000\000\001\023\005\003\001\000\000\000" \
    "\001\222\006\002\005\000\000\000\001\223\a\003\005\000\000\000" \
    "\001\023\001\003\001\001\000\000\001\222\002\002\005\001\000\000" \
    "\001\223\003\003\005\001\000\000\000\000\000\000\000\000\000\000" \
    "\000\000\000\000\000\000\000\000\001\001\000\000\000\000\000\000" \
    "\000\000\000\000\000\000\000\000\001\001\000\000\000\000\000\000" \
    "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000" \
    "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000" \
    "\001\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000" \
    "\001\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000" \
    "\000\000\000\000\000\000\000\000\223\003\005\001\b\034\001\000" \
    "\001\001\001\001\000\000\000\000\001\200\002\000\004\000\000\000" \
    "\001\201\003\001\004\000\000\000\000\000\004\000\000\001\000\000" \
    "\000\001\005\001\000\001\000\000\001\200\006\000\004\001\000\000" \
    "\001\201\a\001\004\001\000\000\001\020\004\000\001\000\000\000" \
    "\001\021\005\001\001\000\000\000\001\220\006\000\005\000\000\000" \
    "\001\221\a\001\005\000\000\000\001\021\001\001\001\001\000\000" \
    "\001\220\002\000\005\001\000\000\001\221\003\001\005\001\000\000" \
    "\001\002\001\002\000\000\000\000\001\202\002\002\004\000\000\000" \
    "\001\203\003\003\004\000\000\000\000\002\004\002\000\001\000\000" \
    "\000\003\005\003\000\001\000\000\001\202\006\002\004\001\000\000" \
    "\001\203\a\003\004\001\000\000\001\022\004\002\001\000\000\000" \
    "\001\023\005\003\001\000\000\000\001\222\006\002\005\000\000\000" \
    "\001\223\a\003\005\000\000\000\001\022\001\002\001\001\000\000" \
    "\001\222\003\002\005\001\000\000\001\223\002\003\005\001\000\000" \
    "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000" \
    "\001\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000" \
    "\001\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000" \
    "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000" \
    "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000" \
    "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000" \
    "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000" \
    "\203\003\004\001\b\016\001\000\001\001\001\001\000\000\000\000" \
    "\001\002\001\002\000\000\000\000\001\200\002\000\004\000\000\000" \
    "\001\201\003\001\004\000\000\000\001\202\002\002\004\000\000\000" \
    "\001\203\003\003\004\000\000\000\000\000\004\000\000\001\000\000" \
    "\000\001\005\001\000\001\000\000\000\002\005\002\000\001\000\000" \
    "\000\003\005\003\000\001\000\000\001\200\006\000\004\001\000\000" \
    "\001\201\a\001\004\001\000\000\001\202\006\002\004\001\000\000" \
    "\001\203\a\003\004\001\000\000\000\000\000\000\000\000\000\000" \
    "\000\000\000\000\000\000\000\000\002\002\000\000\002\002\000\000" \
    "\000\000\000\000\000\000\000\000\002\002\000\000\002\002\000\000" \
    "\000\000\000\000\000\000\000\000\002\002\000\000\002\002\000\000" \
    "\201\001\004\000\004\003\000\000\001\001\001\001\000\000\000\000" \
    "\001\200\002\000\004\000\000\000\001\201\003\001\004\000\000\000" \
    "\203\003\004\000\004\006\000\000\001\001\001\001\000\000\000\000" \
    "\001\002\001\002\000\000\000\000\001\200\002\000\004\000\000\000" \
    "\001\201\003\001\004\000\000\000\001\202\003\002\004\000\000\000" \
    "\001\203\002\003\004\000\000\000\203\003\004\000\004\006\001\000" \
    "\001\001\001\001\000\000\000\000\001\002\001\002\000\000\000\000" \
    "\001\200\002\000\004\000\000\000\001\201\003\001\004\000\000\000" \
    "\001\202\002\002\004\000\000\000\001\203\003\003\004\000\000\000" \
    "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000" \
    "\002\002\000\000\002\002\000\000\221\001\005\000\004\006\000\000" \
    "\001\020\001\000\001\000\000\000\001\001\001\001\000\000\000\000" \
    "\001\200\002\000\004\000\000\000\001\220\002\000\005\000\000\000" \
    "\001\201\003\001\004\000\000\000\001\221\003\001\005\000\000\000" \
    "\215\005\006\000\004\003\000\000\001\200\001\000\004\000\000\000" \
    "\001\201\002\001\004\000\000\000\001\f\003\004\002\000\000\000" \
    "\203\003\004\000\004\006\001\000\001\001\001\001\000\000\000\000" \
    "\001\002\003\002\000\000\000\000\001\200\002\000\004\000\000\000" \
    "\001\201\003\001\004\000\000\000\001\202\002\002\004\000\000\000" \
    "\001\203\002\003\004\000\000\000\000\000\000\000\002\002\000\000" \
    "\000\000\000\000\000\000\000\000\002\002\000\000\000\000\000\000" \
    "\203\003\004\000\005\a\000\000\001\001\001\001\000\000\000\000" \
    "\001\200\002\000\004\000\000\000\001\201\003\001\004\000\000\000" \
    "\001\002\004\002\000\000\000\000\001\003\001\003\000\000\000\000" \
    "\001\202\002\002\004\000\000\000\001\203\003\003\004\000\000\000" \
    "\221\001\005\000\004\006\000\000\001\001\001\001\000\000\000\000" \
    "\001\020\001\000\001\000\000\000\001\200\002\000\004\000\000\000" \
    "\001\201\003\001\004\000\000\000\001\220\003\000\005\000\000\000" \
    "\001\221\002\001\005\000\000\000\000\000\000\000\000\000\000\000" \
    "\000\000\000\000\001\001\001\000\033\377\000\000\001\000\000\000" \
    "\001\002\002\0001\000\000\000!\000\000\000\001\000\000\000\001" \
    "\002\002\0002\000\000\000@\000\000\000\001\000\000\000\001\002" \
    "\002\0003\000\000\000#\000\000\000\001\000\000\000\001\002\002" \
    "\0004\000\000\000$\000\000\000\001\000\000\000\001\002\002\0005" \
    "\000\000\000%\000\000\000\001\000\000\000\001\002\002\0006\000" \
    "\000\000^\000\000\000\001\000\000\000\001\002\002\0007\000\000" \
    "\000&\000\000\000\001\000\000\000\001\002\002\0008\000\000\000*" \
    "\000\000\000\001\000\000\000\001\002\002\0009\000\000\000(\000" \
    "\000\000\001\000\000\000\001\002\002\0000\000\000\000)\000\000" \
    "\000\001\000\000\000\001\002\002\000-\000\000\000_\000\000\000" \
    "\001\000\000\000\001\002\002\000=\000\000\000+\000\000\000\001" \
    "\000\000\000\001\002\002\000\b\377\000\000\b\377\000\000\001\000" \
    "\000\000\001\002\002\000\t\377\000\000 \376\000\000\002\000\000" \
    "\000\001\002\002\000q\000\000\000Q\000\000\000\002\000\000\000" \
    "\001\002\002\000w\000\000\000W\000\000\000\002\000\000\000\001" \
    "\002\002\000e\000\000\000E\000\000\000\002\000\000\000\001\002" \
    "\002\000r\000\000\000R\000\000\000\002\000\000\000\001\002\002" \
    "\000t\000\000\000T\000\000\000\002\000\000\000\001\002\002\000y" \
    "\000\000\000Y\000\000\000\002\000\000\000\001\002\002\000u\000" \
    "\000\000U\000\000\000\002\000\000\000\001\002\002\000i\000\000" \
    "\000I\000\000\000\002\000\000\000\001\002\002\000o\000\000\000O" \
    "\000\000\000\002\000\000\000\001\002\002\000p\000\000\000P\000" \
    "\000\000\001\000\000\000\001\002\002\000[\000\000\000{\000\000" \
    "\000\001\000\000\000\001\002\002\000]\000\000\000}\000\000\000" \
    "\000\000\000\000\001\001\001\000\r\377\000\000\000\000\000\000" \
    "\001\001\001\000\343\377\000\000\002\000\000\000\001\002\002" \
    "\000a\000\000\000A\000\000\000\002\000\000\000\001\002\002\000s" \
    "\000\000\000S\000\000\000\002\000\000\000\001\002\002\000d\000" \
    "\000\000D\000\000\000\002\000\000\000\001\002\002\000f\000\000" \
    "\000F\000\000\000\002\000\000\000\001\002\002\000g\000\000\000G" \
    "\000\000\000\002\000\000\000\001\002\002\000h\000\000\000H\000" \
    "\000\000\002\000\000\000\001\002\002\000j\000\000\000J\000\000" \
    "\000\002\000\000\000\001\002\002\000k\000\000\000K\000\000\000" \
    "\002\000\000\000\001\002\002\000l\000\000\000L\000\000\000\001" \
    "\000\000\000\001\002\002\000;\000\000\000:\000\000\000\001\000" \
    "\000\000\001\002\002\000'\000\000\000\"\000\000\000\001\000\000" \
    "\000\001\002\002\000`\000\000\000~\000\000\000\000\000\000\000" \
    "\001\001\001\000\341\377\000\000\001\000\000\000\001\002\002\000" \
    "\\\000\000\000|\000\000\000\002\000\000\000\001\002\002\000z\000" \
    "\000\000Z\000\000\000\002\000\000\000\001\002\002\000x\000\000" \
    "\000X\000\000\000\002\000\000\000\001\002\002\000c\000\000\000C" \
    "\000\000\000\002\000\000\000\001\002\002\000v\000\000\000V\000" \
    "\000\000\002\000\000\000\001\002\002\000b\000\000\000B\000\000" \
    "\000\002\000\000\000\001\002\002\000n\000\000\000N\000\000\000" \
    "\002\000\000\000\001\002\002\000m\000\000\000M\000\000\000\001" \
    "\000\000\000\001\002\002\000,\000\000\000<\000\000\000\001\000" \
    "\000\000\001\002\002\000.\000\000\000>\000\000\000\001\000\000" \
    "\000\001\002\002\000/\000\000\000?\000\000\000\000\000\000\000" \
    "\001\001\001\000\342\377\000\000\f\000\000\000\001\005\005\000" \
    "\252\377\000\000\252\377\000\000\252\377\000\000\252\377\000" \
    "\000!\376\b\020\001\000\000\000\001\002\002\000\351\377\000\000" \
    "\347\377\000\000\000\000\000\000\001\001\001\000 \000\000\000" \
    "\000\000\000\000\001\001\001\000\345\377\000\000\f\000\000\000" \
    "\001\005\005\000\276\377\000\000\276\377\000\000\276\377\000" \
    "\000\276\377\000\000\001\376\b\020\f\000\000\000\001\005\005" \
    "\000\277\377\000\000\277\377\000\000\277\377\000\000\277\377" \
    "\000\000\002\376\b\020\f\000\000\000\001\005\005\000\300\377" \
    "\000\000\300\377\000\000\300\377\000\000\300\377\000\000\003" \
    "\376\b\020\f\000\000\000\001\005\005\000\301\377\000\000\301" \
    "\377\000\000\301\377\000\000\301\377\000\000\004\376\b\020\f" \
    "\000\000\000\001\005\005\000\302\377\000\000\302\377\000\000" \
    "\302\377\000\000\302\377\000\000\005\376\b\020\f\000\000\000" \
    "\001\005\005\000\303\377\000\000\303\377\000\000\303\377\000" \
    "\000\303\377\000\000\006\376\b\020\f\000\000\000\001\005\005" \
    "\000\304\377\000\000\304\377\000\000\304\377\000\000\304\377" \
    "\000\000\a\376\b\020\f\000\000\000\001\005\005\000\305\377" \
    "\000\000\305\377\000\000\305\377\000\000\305\377\000\000\b" \
    "\376\b\020\f\000\000\000\001\005\005\000\306\377\000\000\306" \
    "\377\000\000\306\377\000\000\306\377\000\000\t\376\b\020\f" \
    "\000\000\000\001\005\005\000\307\377\000\000\307\377\000\000" \
    "\307\377\000\000\307\377\000\000\n\376\b\020\000\000\000\000" \
    "\001\001\001\000\177\377\000\000\000\000\000\000\001\001\001" \
    "\000\024\377\000\000\003\000\000\000\001\002\002\000\225\377" \
    "\000\000\267\377\000\000\003\000\000\000\001\002\002\000\227" \
    "\377\000\000\270\377\000\000\003\000\000\000\001\002\002\000" \
    "\232\377\000\000\271\377\000\000\f\000\000\000\001\005\005" \
    "\000\255\377\000\000\255\377\000\000\255\377\000\000\255" \
    "\377\000\000#\376\b\020\003\000\000\000\001\002\002\000\226" \
    "\377\000\000\264\377\000\000\003\000\000\000\001\002\002" \
    "\000\235\377\000\000\265\377\000\000\003\000\000\000\001" \
    "\002\002\000\230\377\000\000\266\377\000\000\f\000\000\000" \
    "\001\005\005\000\253\377\000\000\253\377\000\000\253\377" \
    "\000\000\253\377\000\000\"\376\b\020\003\000\000\000\001" \
    "\002\002\000\234\377\000\000\261\377\000\000\003\000\000" \
    "\000\001\002\002\000\231\377\000\000\262\377\000\000\003" \
    "\000\000\000\001\002\002\000\233\377\000\000\263\377\000" \
    "\000\003\000\000\000\001\002\002\000\236\377\000\000\260" \
    "\377\000\000\003\000\000\000\001\002\002\000\237\377\000" \
    "\000\256\377\000\000\000\000\000\000\001\001\001\000\003" \
    "\376\000\000\000\000\000\000\000\000\000\000\024\000\000" \
    "\000\001\004\004\000<\000\000\000>\000\000\000|\000\000" \
    "\000\246\000\000\000\f\000\000\000\001\005\005\000\310" \
    "\377\000\000\310\377\000\000\310\377\000\000\310\377\000" \
    "\000\v\376\b\020\f\000\000\000\001\005\005\000\311\377" \
    "\000\000\311\377\000\000\311\377\000\000\311\377\000\000" \
    "\f\376\b\020\000\000\000\000\000\000\000\000\000\000\000" \
    "\000\001\001\001\000&\377\000\000\000\000\000\000\001" \
    "\001\001\000%\377\000\000\000\000\000\000\001\001\001" \
    "\000#\377\000\000\000\000\000\000\001\001\001\000'\377" \
    "\000\000\000\000\000\000\001\001\001\000\"\377\000\000" \
    "\000\000\000\000\000\000\000\000\000\000\000\000\001" \
    "\001\001\000\215\377\000\000\000\000\000\000\001\001" \
    "\001\000\344\377\000\000\f\000\000\000\001\005\005\000" \
    "\257\377\000\000\257\377\000\000\257\377\000\000\257" \
    "\377\000\000 \376\b\020\t\000\000\000\001\002\002\000a" \
    "\377\000\000\025\377\000\000\001\000\000\000\001\002" \
    "\002\000\352\377\000\000\350\377\000\000\000\000\000" \
    "\000\001\001\001\000\n\377\000\000\000\000\000\000\001" \
    "\001\001\000P\377\000\000\000\000\000\000\001\001\001" \
    "\000R\377\000\000\000\000\000\000\001\001\001\000U\377" \
    "\000\000\000\000\000\000\001\001\001\000Q\377\000\000" \
    "\000\000\000\000\001\001\001\000S\377\000\000\000\000" \
    "\000\000\001\001\001\000W\377\000\000\000\000\000\000" \
    "\001\001\001\000T\377\000\000\000\000\000\000\001\001" \
    "\001\000V\377\000\000\000\000\000\000\001\001\001\000c" \
    "\377\000\000\000\000\000\000\001\001\001\000\377\377" \
    "\000\000\000\000\000\000\000\000\000\000\000\000\000" \
    "\000\001\001\001\000\022\377\b\020\000\000\000\000\001" \
    "\001\001\000\021\377\b\020\000\000\000\000\001\001\001" \
    "\000\023\377\b\020\000\000\000\000\001\001\001\000*" \
    "\377\b\020\000\000\000\000\001\001\001\000\275\377\000" \
    "\000\000\000\000\000\001\001\001\000\261\000\000\000" \
    "\006\000\000\000\001\002\002\000\023\377\000\000k\377" \
    "\000\000\000\000\000\000\001\001\001\000J\377\b\020" \
    "\003\000\000\000\001\002\002\000\256\377\000\000\256" \
    "\377\000\000\000\000\000\000\001\001\001\0001\377\000" \
    "\000\000\000\000\000\001\001\001\0004\377\000\000\000" \
    "\000\000\000\000\000\000\000\000\000\000\000\001\001" \
    "\001\000\353\377\000\000\000\000\000\000\001\001\001" \
    "\000\354\377\000\000\000\000\000\000\001\001\001\000g" \
    "\377\000\000\000\000\000\000\001\001\001\000i\377\000" \
    "\000\000\000\000\000\001\001\001\000f\377\000\000\000\000\000" \
    "\000\001\001\001\000p\377\005\020\000\000\000\000\001\001\001" \
    "\000e\377\000\000\000\000\000\000\001\001\001\000q\377\005\020" \
    "\000\000\000\000\001\001\001\000W\377\b\020\000\000\000\000\001" \
    "\001\001\000k\377\b\020\000\000\000\000\001\001\001\000m\377\b" \
    "\020\000\000\000\000\001\001\001\000h\377\000\000\000\000\000" \
    "\000\001\001\001\000X\377\b\020\000\000\000\000\001\001\001\000" \
    "j\377\000\000\000\000\000\000\001\001\001\000e\377\b\020\000\000" \
    "\000\000\001\001\001\000\035\377\b\020\000\000\000\000\000\000" \
    "\000\000\000\000\000\000\001\001\001\000/\377\b\020\000\000\000" \
    "\000\001\001\001\000+\377\b\020\000\000\000\000\001\001\001\000" \
    "]\377\b\020\000\000\000\000\001\001\001\000{\377\b\020\000\000" \
    "\000\000\000\000\000\000\000\000\000\000\001\001\001\000\212" \
    "\377\b\020\000\000\000\000\001\001\001\000A\377\b\020\000\000" \
    "\000\000\001\001\001\000B\377\b\020\000\000\000\000\001\001" \
    "\001\000.\377\b\020\000\000\000\000\001\001\001\000Z\377\b" \
    "\020\000\000\000\000\001\001\001\000-\377\b\020\000\000\000" \
    "\000\001\001\001\000t\377\b\020\000\000\000\000\001\001\001" \
    "\000\177\377\b\020\000\000\000\000\001\001\001\000\031\377\b" \
    "\020\000\000\000\000\001\001\001\0000\377\b\020\000\000\000\000" \
    "\001\001\001\0003\377\b\020\000\000\000\000\001\001\001\000&" \
    "\377\b\020\000\000\000\000\001\001\001\000'\377\b\020\000\000" \
    "\000\000\000\000\000\000\000\000\000\000\001\001\001\000,\377" \
    "\b\020\000\000\000\000\001\001\001\000,\377\b\020\000\000\000" \
    "\000\001\001\001\000\027\377\b\020\001\000\000\000\001\002\002" \
    "\000\024\377\b\0201\377\b\020\000\000\000\000\001\001\001\000" \
    "\026\377\b\020\001\000\000\000\001\002\002\000\025\377\b\020," \
    "\377\b\020\000\000\000\000\001\001\001\000\034\377\b\020\000" \
    "\000\000\000\001\001\001\000>\377\b\020\000\000\000\000\001" \
    "\001\001\000n\377\b\020\000\000\000\000\000\000\000\000\000\000" \
    "\000\000\001\001\001\000\201\377\b\020\000\000\000\000\001\001" \
    "\001\000\030\377\b\020\000\000\000\000\001\001\001\000s\377\b" \
    "\020\000\000\000\000\001\001\001\000V\377\b\020\000\000\000\000" \
    "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000" \
    "\000\001\001\001\000x\377\b\020\000\000\000\000\001\001\001\000" \
    "y\377\b\020\000\000\000\000\001\001\001\000(\000\000\000\000\000" \
    "\000\000\001\001\001\000)\000\000\000\000\000\000\000\001\001" \
    "\001\000h\377\b\020\000\000\000\000\001\001\001\000f\377\000\000" \
    "\000\000\000\000\001\001\001\000\201\377\b\020\000\000\000\000" \
    "\001\001\001\000E\377\b\020\000\000\000\000\001\001\001\000F\377" \
    "\b\020\000\000\000\000\001\001\001\000G\377\b\020\000\000\000\000" \
    "\001\001\001\000H\377\b\020\000\000\000\000\001\001\001\000I\377\b" \
    "\020\000\000\000\000\000\000\000\000\000\000\000\000\001\001\001" \
    "\000\262\377\b\020\000\000\000\000\001\001\001\000\251\377\b\020" \
    "\000\000\000\000\001\001\001\000\260\377\b\020\000\000\000\000\001" \
    "\001\001\000\261\377\b\020\000\000\000\000\000\000\000\000\000\000" \
    "\000\000\001\001\001\000~\377\000\000\001\000\000\000\001\002\002" \
    "\000\000\000\000\000\351\377\000\000\001\000\000\000\001\002\002" \
    "\000\000\000\000\000\347\377\000\000\001\000\000\000\001\002\002" \
    "\000\000\000\000\000\353\377\000\000\001\000\000\000\001\002\002" \
    "\000\000\000\000\000\355\377\000\000\000\000\000\000\001\001\001" \
    "\000\024\377\b\020\000\000\000\000\001\001\001\0001\377\b\020\000" \
    "\000\000\000\001\001\001\000C\377\b\020\000\000\000\000\001\001" \
    "\001\000D\377\b\020\000\000\000\000\001\001\001\000K\377\b\020" \
    "\000\000\000\000\001\001\001\000\247\377\b\020\000\000\000\000" \
    "\001\001\001\000V\377\b\020\000\000\000\000\001\001\001\000\024" \
    "\377\b\020\000\000\000\000\001\001\001\000\227\377\b\020\000\000" \
    "\000\000\000\000\000\000\000\000\000\000\001\001\001\000a\377\000" \
    "\000\000\000\000\000\000\000\000\000\000\000\000\000\001\001\001" \
    "\000\217\377\b\020\000\000\000\000\001\001\001\000\266\377\b\020" \
    "\000\000\000\000\000\000\000\000\000\000\000\000\001\001\001\000" \
    "\031\377\b\020\000\000\000\000\001\001\001\000\216\377\b\020\000" \
    "\000\000\000\001\001\001\000\033\377\b\020\000\000\000\000\001" \
    "\001\001\000_\377\b\020\000\000\000\000\001\001\001\000<\377\b" \
    "\020\000\000\000\000\001\001\001\000^\377\b\020\000\000\000\000" \
    "\001\001\001\0006\377\b\020\000\000\000\000\000\000\000\000\000" \
    "\000\000\000\001\001\001\000i\377\000\000\000\000\000\000\001\001" \
    "\001\000\003\377\b\020\000\000\000\000\001\001\001\000\002\377\b" \
    "\020\000\000\000\000\001\001\001\0002\377\b\020\000\000\000\000" \
    "\001\001\001\000Y\377\b\020\000\000\000\000\001\001\001\000\004" \
    "\377\b\020\000\000\000\000\001\001\001\000\006\377\b\020\000\000" \
    "\000\000\001\001\001\000\005\377\b\020\000\000\000\000\001\001" \
    "\001\000{\377\b\020\000\000\000\000\001\001\001\000r\377\b\020" \
    "\000\000\000\000\001\001\001\000\220\377\b\020\000\000\000\000" \
    "\001\001\001\000w\377\b\020\000\000\000\000\001\001\001\000[\377" \
    "\b\020\000\000\000\000\001\001\001\000\223\377\b\020\000\000\000" \
    "\000\001\001\001\000\224\377\b\020\000\000\000\000\001\001\001" \
    "\000\225\377\b\020\000\000\000\000\001\001\001\000\226\377\b" \
    "\020\000\000\000\000\000\000\000\000\000\000\000\000\001\001\001" \
    "\000\"\376\b\020\000\000\000\000\001\001\001\000#\376\b\020\000" \
    "\000\000\000\001\001\001\000\a\377\b\020\000\000\000\000\001\001" \
    "\001\000\364\020\b\020\000\000\000\000\001\001\001\000\365\020\b" \
    "\020\000\000\000\000\001\001\001\000\264\377\b\020\000\000\000" \
    "\000\001\001\001\000\265\377\b\020%\0042\001>\001@\bB\002M\020" \
    "\\\200i\004l\b\205@\206@\313\200\315\b\316@\317@\000\000"
  end

  let(:get_querykeymap_resp) do
    "\x01\x00\x0f\x25\x02\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00"
  end

  let(:keyboard_select_events_new_keyboard_notify) do
    "\x88\x01\x05\x00\x03\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x05\x00\x05\x00"
  end

  let(:keyboard_select_events_map_notify) do
    "\x88\x01\x04\x00\x03\x00\x02\x00\x00\x00\x00\x00\x07\x00\x07\x00"
  end

  let(:keyboard_get_map_request) do
    "\x88\x08\x07\x00\x00\x01\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
  end

  let(:key_map_request) do
    "\x2c\x00\x01\x00"
  end

  let(:set_bell) do
    "\x88\x03\x07\x00\x00\x01\x00\x03\x00\x04\x32\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x2e\x03\x00\x00\x00\x00\x00\x00"
  end

  describe 'X11GetMapReply' do
    context '#read' do
      it do
        response = Rex::Proto::X11::Xkeyboard::X11GetMapReply.read(get_keyboardmap_resp)
        expect(response.min_key_code).to eq(8)
        expect(response.max_key_code).to eq(255)

        expect(response.n_types).to eq(28)
        expect(response.key_types_array.length).to eq(28)
        # spot check a few of the key_types_array items
        expect(response.key_types_array[12].mods_mask).to eq(141)
        expect(response.key_types_array[12].key_map_array.length).to eq(4)
        expect(response.key_types_array[12].key_mods_array.length).to eq(4)
        expect(response.key_types_array[13].mods_mask).to eq(135)
        expect(response.key_types_array[13].key_map_array.length).to eq(15)

        expect(response.n_key_sym).to eq(248)
        # spot check a few of the key_map_array items
        expect(response.key_map_array[247].key_sym_array[0]).to eq(269025205)

        expect(response.total_mod_map_key).to eq(15)
        # spot check a few of the key_mod_map_array items
        expect(response.key_mod_map_array[0].keycode).to eq(37)
        expect(response.key_mod_map_array[0].mods).to eq(4)
        expect(response.key_mod_map_array[14].keycode).to eq(207)
        expect(response.key_mod_map_array[14].mods).to eq(64)
      end

      # this was a crash case from https://github.com/rapid7/metasploit-framework/pull/18877#issuecomment-2445152666
      it do
        response = Rex::Proto::X11::Xkeyboard::X11GetMapReply.read(get_keyboardmap_resp_2)
        expect(response.min_key_code).to eq(8)
        expect(response.max_key_code).to eq(255)

        expect(response.n_types).to eq(28)
        expect(response.key_types_array.length).to eq(28)
        # spot check a few of the key_types_array items
        expect(response.key_types_array[12].mods_mask).to eq(141)
        expect(response.key_types_array[12].key_map_array.length).to eq(4)
        expect(response.key_types_array[12].key_mods_array.length).to eq(4)
        expect(response.key_types_array[13].mods_mask).to eq(135)
        expect(response.key_types_array[13].key_map_array.length).to eq(14)

        expect(response.n_key_sym).to eq(248)
        # spot check a few of the key_map_array items
        expect(response.key_map_array[247].key_sym_array[0]).to eq(269025205)

        expect(response.total_mod_map_key).to eq(15)
        # spot check a few of the key_mod_map_array items
        expect(response.key_mod_map_array[0].keycode).to eq(37)
        expect(response.key_mod_map_array[0].mods).to eq(4)
        expect(response.key_mod_map_array[14].keycode).to eq(207)
        expect(response.key_mod_map_array[14].mods).to eq(64)
      end
    end
  end

  describe 'X11QueryKeyMapRequest' do
    context '#read' do
      it do
        response = Rex::Proto::X11::Xkeyboard::X11QueryKeyMapReply.read(get_querykeymap_resp)
        expect(response.reply).to eq(1)
        expect(response.sequence_number).to eq(9487)
        expect(response.response_length).to eq(2)
        expect(response.data).to eq([
          0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,\
          0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
        ])
      end
    end
  end

  describe 'X11QueryKeyMapRequest' do
    context '#initialize' do
      it do
        request = Rex::Proto::X11::Xkeyboard::X11QueryKeyMapRequest.new
        expect(request.to_binary_s).to eq(key_map_request)
      end
    end
    context '#read' do
      it do
        request = Rex::Proto::X11::Xkeyboard::X11QueryKeyMapRequest.read(key_map_request)
        expect(request.opcode).to eq(44)
      end
    end
  end

  describe 'X11SelectEvents' do
    context '#read' do
      it do
        # test against packet pulled from wireshark
        request = Rex::Proto::X11::Xkeyboard::X11SelectEvents.read(keyboard_select_events_new_keyboard_notify)
        expect(request.xkeyboard_id).to eq(136)
        expect(request.extension_minor).to eq(1)
        expect(request.request_length).to eq(5)
        expect(request.device_spec).to eq(3)
        expect(request.affect_which_new_keyboard_notify).to eq(1)
        expect(request.affect_new_keyboard_key_codes).to eq(1)
        expect(request.affect_new_keyboard_device_id).to eq(1)
        # build packet and ensure it matches
      end
    end

    context '#initialize' do
      it do
        request = Rex::Proto::X11::Xkeyboard::X11SelectEvents.new(
          xkeyboard_id: 136,
          extension_minor: 1,
          device_spec: 3,
          affect_which_new_keyboard_notify: 1,
          affect_new_keyboard_key_codes: 1,
          affect_new_keyboard_device_id: 1,
          new_keyboard_details_key_codes: 1,
          new_keyboard_details_device_id: 1
        )
        expect(request.to_binary_s).to eq(keyboard_select_events_new_keyboard_notify)
      end
    end
  end

  describe 'X11SelectEvents' do
    context '#read' do
      it do
        # test against packet pulled from wireshark
        request = Rex::Proto::X11::Xkeyboard::X11SelectEvents.read(keyboard_select_events_map_notify)
        expect(request.xkeyboard_id).to eq(136)
        expect(request.extension_minor).to eq(1)
        expect(request.request_length).to eq(4)
        expect(request.device_spec).to eq(3)
        expect(request.affect_which_map_notify).to eq(1)
        expect(request.map_key_types).to eq(1)
        expect(request.map_key_syms).to eq(1)
        expect(request.map_modifier_map).to eq(1)
      end
    end

    context '#initialize' do
      it do
        request = Rex::Proto::X11::Xkeyboard::X11SelectEvents.new(
          xkeyboard_id: 136,
          extension_minor: 1,
          device_spec: 3,
          affect_which_map_notify: 1,
          affect_map_key_types: 1,
          affect_map_key_syms: 1,
          affect_map_modifier_map: 1,
          map_key_types: 1,
          map_key_syms: 1,
          map_modifier_map: 1
        )
        expect(request.to_binary_s).to eq(keyboard_select_events_map_notify)
      end
    end
  end

  describe 'X11BellRequest' do
    context '#read' do
      it do
        # test against packet pulled from wireshark
        request = Rex::Proto::X11::Xkeyboard::X11BellRequest.read(set_bell)
        expect(request.xkeyboard_id).to eq(136)
        expect(request.extension_minor).to eq(3)
        expect(request.request_length).to eq(7)
        expect(request.device_spec).to eq(256)
        expect(request.bell_class).to eq(768)
        expect(request.bell_id).to eq(1024)
        expect(request.percent).to eq(50)
        expect(request.force_sound).to eq(0)
        expect(request.sound_only).to eq(0)
        expect(request.pitch).to eq(0)
        expect(request.duration).to eq(0)
        expect(request.window).to eq(0)
        expect(request.name).to eq(814)
      end
    end
    context '#initialize' do
      it do
        request = Rex::Proto::X11::Xkeyboard::X11BellRequest.new(
          xkeyboard_id: 136
        )
        expect(request.to_binary_s).to eq(set_bell)
      end
    end
  end
end
