/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.internal;

import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.Locale;
import org.hibernate.MappingException;
import org.hibernate.boot.jaxb.mapping.spi.JaxbUserTypeImpl;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.annotations.internal.JavaTypeAnnotation;
import org.hibernate.boot.models.annotations.internal.TemporalJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.TypeAnnotation;
import org.hibernate.boot.models.xml.internal.AbstractUserTypeCases;
import org.hibernate.boot.models.xml.internal.XmlAnnotationHelper;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.MutableMemberDetails;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.usertype.UserType;

public class UserTypeCasesStandard
extends AbstractUserTypeCases {
    public static final UserTypeCasesStandard STANDARD_USER_TYPE_CASES = new UserTypeCasesStandard();

    public static void applyJavaTypeAnnotationStatic(MutableMemberDetails memberDetails, Class<? extends BasicJavaType<?>> descriptor, XmlDocumentContext xmlDocumentContext) {
        JavaTypeAnnotation javaTypeAnnotation = (JavaTypeAnnotation)memberDetails.applyAnnotationUsage(HibernateAnnotations.JAVA_TYPE, xmlDocumentContext.getModelBuildingContext());
        javaTypeAnnotation.value(descriptor);
    }

    @Override
    protected void applyJavaTypeAnnotation(MutableMemberDetails memberDetails, Class<? extends BasicJavaType<?>> descriptor, XmlDocumentContext xmlDocumentContext) {
        UserTypeCasesStandard.applyJavaTypeAnnotationStatic(memberDetails, descriptor, xmlDocumentContext);
    }

    @Override
    protected void applyTemporalPrecision(MutableMemberDetails memberDetails, TemporalType temporalType, XmlDocumentContext xmlDocumentContext) {
        Temporal directUsage = (Temporal)memberDetails.getDirectAnnotationUsage(Temporal.class);
        if (directUsage != null) {
            if (directUsage.value() != temporalType) {
                throw new MappingException(String.format(Locale.ROOT, "Mismatch in expected TemporalType on %s; found %s and %s", memberDetails, directUsage.value(), temporalType));
            }
            return;
        }
        TemporalJpaAnnotation temporalAnnotation = (TemporalJpaAnnotation)((Object)memberDetails.applyAnnotationUsage(JpaAnnotations.TEMPORAL, xmlDocumentContext.getModelBuildingContext()));
        temporalAnnotation.value(temporalType);
    }

    @Override
    public void handleGeneral(JaxbUserTypeImpl jaxbType, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        ClassDetails userTypeImpl = XmlAnnotationHelper.resolveJavaType(jaxbType.getValue(), xmlDocumentContext);
        assert (userTypeImpl.isImplementor(UserType.class));
        TypeAnnotation typeAnn = (TypeAnnotation)memberDetails.applyAnnotationUsage(HibernateAnnotations.TYPE, xmlDocumentContext.getModelBuildingContext());
        typeAnn.value(userTypeImpl.toJavaClass());
        typeAnn.parameters(XmlAnnotationHelper.collectParameters(jaxbType.getParameters(), xmlDocumentContext));
    }
}

