/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity.internal;

import java.util.BitSet;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.internal.EntityCollectionPart;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.graph.InitializerProducer;
import org.hibernate.sql.results.graph.entity.EntityFetch;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.entity.EntityValuedFetchable;
import org.hibernate.sql.results.graph.entity.internal.EntityAssembler;
import org.hibernate.sql.results.graph.entity.internal.EntityInitializerImpl;
import org.hibernate.sql.results.graph.entity.internal.EntityResultImpl;
import org.hibernate.sql.results.graph.internal.ImmutableFetchList;

public class EntityFetchJoinedImpl
implements EntityFetch,
FetchParent,
InitializerProducer<EntityFetchJoinedImpl> {
    private final FetchParent fetchParent;
    private final EntityValuedFetchable fetchContainer;
    private final EntityResultImpl entityResult;
    private final DomainResult<?> keyResult;
    private final NotFoundAction notFoundAction;
    private final boolean isAffectedByFilter;
    private final String sourceAlias;

    public EntityFetchJoinedImpl(FetchParent fetchParent, ToOneAttributeMapping toOneMapping, TableGroup tableGroup, DomainResult<?> keyResult, boolean isAffectedByFilter, NavigablePath navigablePath, DomainResultCreationState creationState) {
        this.fetchContainer = toOneMapping;
        this.fetchParent = fetchParent;
        this.keyResult = keyResult;
        this.notFoundAction = toOneMapping.getNotFoundAction();
        this.sourceAlias = tableGroup.getSourceAlias();
        this.isAffectedByFilter = isAffectedByFilter;
        this.entityResult = new EntityResultImpl(navigablePath, toOneMapping, tableGroup, null);
        this.entityResult.afterInitialize(this, creationState);
    }

    public EntityFetchJoinedImpl(FetchParent fetchParent, EntityCollectionPart collectionPart, TableGroup tableGroup, NavigablePath navigablePath, DomainResultCreationState creationState) {
        this.fetchContainer = collectionPart;
        this.fetchParent = fetchParent;
        this.notFoundAction = collectionPart.getNotFoundAction();
        this.keyResult = null;
        this.sourceAlias = tableGroup.getSourceAlias();
        this.isAffectedByFilter = false;
        this.entityResult = new EntityResultImpl(navigablePath, collectionPart, tableGroup, null);
        this.entityResult.afterInitialize(this, creationState);
    }

    protected EntityFetchJoinedImpl(EntityFetchJoinedImpl original) {
        this.fetchContainer = original.fetchContainer;
        this.fetchParent = original.fetchParent;
        this.entityResult = original.entityResult;
        this.keyResult = original.keyResult;
        this.notFoundAction = original.notFoundAction;
        this.isAffectedByFilter = original.isAffectedByFilter;
        this.sourceAlias = original.sourceAlias;
    }

    @Override
    public EntityValuedFetchable getEntityValuedModelPart() {
        return this.fetchContainer;
    }

    @Override
    public EntityValuedFetchable getReferencedModePart() {
        return this.getEntityValuedModelPart();
    }

    @Override
    public EntityValuedFetchable getReferencedMappingType() {
        return this.getEntityValuedModelPart();
    }

    @Override
    public EntityValuedFetchable getFetchedMapping() {
        return this.getEntityValuedModelPart();
    }

    @Override
    public FetchParent getFetchParent() {
        return this.fetchParent;
    }

    @Override
    public DomainResultAssembler<?> createAssembler(InitializerParent<?> parent, AssemblerCreationState creationState) {
        return this.buildEntityAssembler(creationState.resolveInitializer(this, parent, this).asEntityInitializer());
    }

    protected EntityAssembler<?> buildEntityAssembler(EntityInitializer<?> entityInitializer) {
        return new EntityAssembler(this.getFetchedMapping().getJavaType(), entityInitializer);
    }

    @Override
    public Initializer<?> createInitializer(EntityFetchJoinedImpl resultGraphNode, InitializerParent<?> parent, AssemblerCreationState creationState) {
        return resultGraphNode.createInitializer((InitializerParent)parent, creationState);
    }

    public EntityInitializer<?> createInitializer(InitializerParent<?> parent, AssemblerCreationState creationState) {
        return new EntityInitializerImpl(this, this.sourceAlias, this.entityResult.getIdentifierFetch(), this.entityResult.getDiscriminatorFetch(), this.keyResult, this.entityResult.getRowIdResult(), this.notFoundAction, this.isAffectedByFilter, parent, false, creationState);
    }

    @Override
    public FetchTiming getTiming() {
        return FetchTiming.IMMEDIATE;
    }

    @Override
    public boolean hasTableGroup() {
        return true;
    }

    public EntityResultImpl getEntityResult() {
        return this.entityResult;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.entityResult.getNavigablePath();
    }

    @Override
    public ImmutableFetchList getFetches() {
        return this.entityResult.getFetches();
    }

    @Override
    public Fetch findFetch(Fetchable fetchable) {
        return this.entityResult.findFetch(fetchable);
    }

    @Override
    public boolean hasJoinFetches() {
        return this.entityResult.hasJoinFetches();
    }

    @Override
    public boolean containsCollectionFetches() {
        return this.entityResult.containsCollectionFetches();
    }

    @Override
    public void collectValueIndexesToCache(BitSet valueIndexes) {
        this.entityResult.collectValueIndexesToCache(valueIndexes);
    }

    protected DomainResult<?> getKeyResult() {
        return this.keyResult;
    }

    protected NotFoundAction getNotFoundAction() {
        return this.notFoundAction;
    }

    protected boolean isAffectedByFilter() {
        return this.isAffectedByFilter;
    }

    protected String getSourceAlias() {
        return this.sourceAlias;
    }
}

