/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.queue;

import java.util.OptionalLong;
import java.util.function.UnaryOperator;

public interface EventQueue
extends AutoCloseable {
    default public void prepend(Event event) {
        this.enqueue(EventInsertionType.PREPEND, null, NoDeadlineFunction.INSTANCE, event);
    }

    default public void append(Event event) {
        this.enqueue(EventInsertionType.APPEND, null, NoDeadlineFunction.INSTANCE, event);
    }

    default public void appendWithDeadline(long deadlineNs, Event event) {
        this.enqueue(EventInsertionType.APPEND, null, new DeadlineFunction(deadlineNs), event);
    }

    default public void scheduleDeferred(String tag, UnaryOperator<OptionalLong> deadlineNsCalculator, Event event) {
        this.enqueue(EventInsertionType.DEFERRED, tag, deadlineNsCalculator, event);
    }

    public void cancelDeferred(String var1);

    public void enqueue(EventInsertionType var1, String var2, UnaryOperator<OptionalLong> var3, Event var4);

    public void beginShutdown(String var1);

    public int size();

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    default public void wakeup() {
    }

    @Override
    public void close() throws InterruptedException;

    public static enum EventInsertionType {
        PREPEND,
        APPEND,
        DEFERRED;

    }

    public static class NoDeadlineFunction
    implements UnaryOperator<OptionalLong> {
        public static final NoDeadlineFunction INSTANCE = new NoDeadlineFunction();

        private NoDeadlineFunction() {
        }

        @Override
        public OptionalLong apply(OptionalLong ignored) {
            return OptionalLong.empty();
        }
    }

    public static interface Event {
        public void run() throws Exception;

        default public void handleException(Throwable e) {
        }
    }

    public static class DeadlineFunction
    implements UnaryOperator<OptionalLong> {
        private final long deadlineNs;

        public DeadlineFunction(long deadlineNs) {
            this.deadlineNs = deadlineNs;
        }

        @Override
        public OptionalLong apply(OptionalLong ignored) {
            return OptionalLong.of(this.deadlineNs);
        }
    }

    public static class VoidEvent
    implements Event {
        public static final VoidEvent INSTANCE = new VoidEvent();

        private VoidEvent() {
        }

        @Override
        public void run() throws Exception {
        }
    }

    public static class EarliestDeadlineFunction
    implements UnaryOperator<OptionalLong> {
        private final long newDeadlineNs;

        public EarliestDeadlineFunction(long newDeadlineNs) {
            this.newDeadlineNs = newDeadlineNs;
        }

        @Override
        public OptionalLong apply(OptionalLong prevDeadlineNs) {
            if (prevDeadlineNs.isEmpty()) {
                return OptionalLong.of(this.newDeadlineNs);
            }
            if (prevDeadlineNs.getAsLong() < this.newDeadlineNs) {
                return prevDeadlineNs;
            }
            return OptionalLong.of(this.newDeadlineNs);
        }
    }
}

