/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.MetricNameTemplate;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Meter;
import org.apache.kafka.common.metrics.stats.Min;
import org.apache.kafka.common.metrics.stats.Value;
import org.apache.kafka.connect.mirror.MirrorSourceConnector;
import org.apache.kafka.connect.mirror.MirrorSourceTaskConfig;
import org.apache.kafka.connect.mirror.ReplicationPolicy;

class MirrorSourceMetrics
implements AutoCloseable {
    private static final String SOURCE_CONNECTOR_GROUP = MirrorSourceConnector.class.getSimpleName();
    private final MetricNameTemplate recordCount;
    private final MetricNameTemplate recordRate;
    private final MetricNameTemplate recordAge;
    private final MetricNameTemplate recordAgeMax;
    private final MetricNameTemplate recordAgeMin;
    private final MetricNameTemplate recordAgeAvg;
    private final MetricNameTemplate byteCount;
    private final MetricNameTemplate byteRate;
    private final MetricNameTemplate replicationLatency;
    private final MetricNameTemplate replicationLatencyMax;
    private final MetricNameTemplate replicationLatencyMin;
    private final MetricNameTemplate replicationLatencyAvg;
    private final Metrics metrics;
    private final Map<TopicPartition, PartitionMetrics> partitionMetrics;
    private final String source;
    private final String target;

    MirrorSourceMetrics(MirrorSourceTaskConfig taskConfig) {
        this.target = taskConfig.targetClusterAlias();
        this.source = taskConfig.sourceClusterAlias();
        this.metrics = new Metrics();
        HashSet<String> partitionTags = new HashSet<String>(Arrays.asList("source", "target", "topic", "partition"));
        this.recordCount = new MetricNameTemplate("record-count", SOURCE_CONNECTOR_GROUP, "Number of source records replicated to the target cluster.", partitionTags);
        this.recordRate = new MetricNameTemplate("record-rate", SOURCE_CONNECTOR_GROUP, "Average number of source records replicated to the target cluster per second.", partitionTags);
        this.recordAge = new MetricNameTemplate("record-age-ms", SOURCE_CONNECTOR_GROUP, "The age of incoming source records when replicated to the target cluster.", partitionTags);
        this.recordAgeMax = new MetricNameTemplate("record-age-ms-max", SOURCE_CONNECTOR_GROUP, "The max age of incoming source records when replicated to the target cluster.", partitionTags);
        this.recordAgeMin = new MetricNameTemplate("record-age-ms-min", SOURCE_CONNECTOR_GROUP, "The min age of incoming source records when replicated to the target cluster.", partitionTags);
        this.recordAgeAvg = new MetricNameTemplate("record-age-ms-avg", SOURCE_CONNECTOR_GROUP, "The average age of incoming source records when replicated to the target cluster.", partitionTags);
        this.byteCount = new MetricNameTemplate("byte-count", SOURCE_CONNECTOR_GROUP, "Number of bytes replicated to the target cluster.", partitionTags);
        this.byteRate = new MetricNameTemplate("byte-rate", SOURCE_CONNECTOR_GROUP, "Average number of bytes replicated per second.", partitionTags);
        this.replicationLatency = new MetricNameTemplate("replication-latency-ms", SOURCE_CONNECTOR_GROUP, "Time it takes records to replicate from source to target cluster.", partitionTags);
        this.replicationLatencyMax = new MetricNameTemplate("replication-latency-ms-max", SOURCE_CONNECTOR_GROUP, "Max time it takes records to replicate from source to target cluster.", partitionTags);
        this.replicationLatencyMin = new MetricNameTemplate("replication-latency-ms-min", SOURCE_CONNECTOR_GROUP, "Min time it takes records to replicate from source to target cluster.", partitionTags);
        this.replicationLatencyAvg = new MetricNameTemplate("replication-latency-ms-avg", SOURCE_CONNECTOR_GROUP, "Average time it takes records to replicate from source to target cluster.", partitionTags);
        this.metrics.sensor("record-count");
        this.metrics.sensor("byte-rate");
        this.metrics.sensor("record-age");
        this.metrics.sensor("replication-latency");
        ReplicationPolicy replicationPolicy = taskConfig.replicationPolicy();
        this.partitionMetrics = taskConfig.taskTopicPartitions().stream().map(x -> new TopicPartition(replicationPolicy.formatRemoteTopic(this.source, x.topic()), x.partition())).collect(Collectors.toMap(x -> x, x$0 -> new PartitionMetrics((TopicPartition)x$0)));
    }

    @Override
    public void close() {
        this.metrics.close();
    }

    void countRecord(TopicPartition topicPartition) {
        this.partitionMetrics.get((Object)topicPartition).recordSensor.record();
    }

    void recordAge(TopicPartition topicPartition, long ageMillis) {
        this.partitionMetrics.get((Object)topicPartition).recordAgeSensor.record((double)ageMillis);
    }

    void replicationLatency(TopicPartition topicPartition, long millis) {
        this.partitionMetrics.get((Object)topicPartition).replicationLatencySensor.record((double)millis);
    }

    void recordBytes(TopicPartition topicPartition, long bytes) {
        this.partitionMetrics.get((Object)topicPartition).byteSensor.record((double)bytes);
    }

    void addReporter(MetricsReporter reporter) {
        this.metrics.addReporter(reporter);
    }

    private class PartitionMetrics {
        private final Sensor recordSensor;
        private final Sensor byteSensor;
        private final Sensor recordAgeSensor;
        private final Sensor replicationLatencySensor;

        PartitionMetrics(TopicPartition topicPartition) {
            String prefix = topicPartition.topic() + "-" + topicPartition.partition() + "-";
            LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
            tags.put("source", MirrorSourceMetrics.this.source);
            tags.put("target", MirrorSourceMetrics.this.target);
            tags.put("topic", topicPartition.topic());
            tags.put("partition", Integer.toString(topicPartition.partition()));
            this.recordSensor = MirrorSourceMetrics.this.metrics.sensor(prefix + "records-sent");
            this.recordSensor.add((CompoundStat)new Meter(MirrorSourceMetrics.this.metrics.metricInstance(MirrorSourceMetrics.this.recordRate, tags), MirrorSourceMetrics.this.metrics.metricInstance(MirrorSourceMetrics.this.recordCount, tags)));
            this.byteSensor = MirrorSourceMetrics.this.metrics.sensor(prefix + "bytes-sent");
            this.byteSensor.add((CompoundStat)new Meter(MirrorSourceMetrics.this.metrics.metricInstance(MirrorSourceMetrics.this.byteRate, tags), MirrorSourceMetrics.this.metrics.metricInstance(MirrorSourceMetrics.this.byteCount, tags)));
            this.recordAgeSensor = MirrorSourceMetrics.this.metrics.sensor(prefix + "record-age");
            this.recordAgeSensor.add(MirrorSourceMetrics.this.metrics.metricInstance(MirrorSourceMetrics.this.recordAge, tags), (MeasurableStat)new Value());
            this.recordAgeSensor.add(MirrorSourceMetrics.this.metrics.metricInstance(MirrorSourceMetrics.this.recordAgeMax, tags), (MeasurableStat)new Max());
            this.recordAgeSensor.add(MirrorSourceMetrics.this.metrics.metricInstance(MirrorSourceMetrics.this.recordAgeMin, tags), (MeasurableStat)new Min());
            this.recordAgeSensor.add(MirrorSourceMetrics.this.metrics.metricInstance(MirrorSourceMetrics.this.recordAgeAvg, tags), (MeasurableStat)new Avg());
            this.replicationLatencySensor = MirrorSourceMetrics.this.metrics.sensor(prefix + "replication-latency");
            this.replicationLatencySensor.add(MirrorSourceMetrics.this.metrics.metricInstance(MirrorSourceMetrics.this.replicationLatency, tags), (MeasurableStat)new Value());
            this.replicationLatencySensor.add(MirrorSourceMetrics.this.metrics.metricInstance(MirrorSourceMetrics.this.replicationLatencyMax, tags), (MeasurableStat)new Max());
            this.replicationLatencySensor.add(MirrorSourceMetrics.this.metrics.metricInstance(MirrorSourceMetrics.this.replicationLatencyMin, tags), (MeasurableStat)new Min());
            this.replicationLatencySensor.add(MirrorSourceMetrics.this.metrics.metricInstance(MirrorSourceMetrics.this.replicationLatencyAvg, tags), (MeasurableStat)new Avg());
        }
    }
}

