#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 glirc
version:              2.40.1
visibility:           public
id:                   glirc-2.40.1-3KUMxttR82y3DQNRcO6R9u
key:                  glirc-2.40.1-3KUMxttR82y3DQNRcO6R9u
license:              ISC
copyright:            2016-2019 Eric Mertens
maintainer:           emertens@gmail.com
author:               Eric Mertens
homepage:             https://github.com/glguy/irc-core
synopsis:             Console IRC client
description:
    Console IRC client

    glirc is a console IRC client with an emphasis on providing
    dynamic views into the model of your IRC connections.

    <https://github.com/glguy/irc-core/wiki Documentation Wiki>

category:             Network
abi:                  1b9ea2c91e81c4e71d5a4ab1c6b6f773
exposed:              True
exposed-modules:
    Client.Authentication.Ecdh Client.Authentication.Ecdsa
    Client.Authentication.Scram Client.CApi Client.CApi.Exports
    Client.CApi.Types Client.Commands Client.Commands.Arguments.Parser
    Client.Commands.Arguments.Renderer Client.Commands.Arguments.Spec
    Client.Commands.Certificate Client.Commands.Channel
    Client.Commands.Chat Client.Commands.Connection
    Client.Commands.Docs Client.Commands.Exec
    Client.Commands.Interpolation Client.Commands.Operator
    Client.Commands.Queries Client.Commands.Recognizer
    Client.Commands.TabCompletion Client.Commands.Toggles
    Client.Commands.Types Client.Commands.Window
    Client.Commands.WordCompletion Client.Commands.ZNC
    Client.Configuration Client.Configuration.Colors
    Client.Configuration.Macros Client.Configuration.Notifications
    Client.Configuration.ServerSettings Client.Configuration.Sts
    Client.Docs Client.EventLoop Client.EventLoop.Actions
    Client.EventLoop.Errors Client.EventLoop.Network Client.Hook
    Client.Hook.DroneBLRelay Client.Hook.Matterbridge
    Client.Hook.Snotice Client.Hook.Znc.Buffextras Client.Hooks
    Client.Image Client.Image.Layout Client.Image.LineWrap
    Client.Image.Message Client.Image.MircFormatting
    Client.Image.PackedImage Client.Image.Palette
    Client.Image.StatusLine Client.Image.Textbox Client.Log Client.Mask
    Client.Message Client.Network.Async Client.Network.Connect
    Client.Options Client.State Client.State.Channel
    Client.State.EditBox Client.State.EditBox.Content
    Client.State.Extensions Client.State.Focus Client.State.Network
    Client.State.Url Client.State.Window Client.UserHost Client.View
    Client.View.Cert Client.View.ChannelInfo Client.View.ChannelList
    Client.View.Digraphs Client.View.Help Client.View.IgnoreList
    Client.View.KeyMap Client.View.MaskList Client.View.Mentions
    Client.View.Messages Client.View.Palette Client.View.RtsStats
    Client.View.UrlSelection Client.View.UserList Client.View.Who
    Client.View.Windows Client.WhoReply

hidden-modules:
    ContextFilter DigraphQuote Digraphs LensUtils RtsStats StrQuote
    StrictUnit Paths_glirc Build_glirc

import-dirs:          /usr/lib/ghc-9.6.6/site-local/glirc-2.40.1
library-dirs:         /usr/lib/ghc-9.6.6/site-local/glirc-2.40.1
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/glirc-2.40.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/glirc
hs-libraries:         HSglirc-2.40.1-3KUMxttR82y3DQNRcO6R9u
include-dirs:         /usr/lib/ghc-9.6.6/site-local/glirc-2.40.1/include
includes:             include/glirc-api.h
depends:
    HsOpenSSL-0.11.7.9-9h2AmtvUUOpArhcntkthRO
    async-2.2.5-BExe3HBSFHr8hii1cT1bvS
    attoparsec-0.14.4-FIfeiNzOKYm3sEc1QPF51Z base-4.18.2.1
    base64-bytestring-1.2.1.0-6srVB7ZKmzD1HZV2AV5j9d
    bytestring-0.11.5.3 config-schema-1.3.0.0-4i0MO4nvyFB3lnBmUYy3f
    config-value-0.8.3-IWIlPmbx9u07ZPnTUBDeDU containers-0.6.7
    curve25519-0.2.8.1-7NE4kCXqGVN9Wjx3WOc64D directory-1.3.8.5
    filepath-1.4.300.1 free-5.2-lYbtii88KLEfQCefRJ76n
    githash-0.1.6.3-I67lp2I8Vnr6v6Q6s23zsl
    hashable-1.4.7.0-LE3bCdm1Wgy6IgVYkRoAlQ
    hookup-0.8-6P36etKzpwi2jTdC2skEe1
    irc-core-2.12-HV7XbZZswgx2EFUu6ZwRxF
    kan-extensions-5.2.7-CMh63la3Yj0AL7ENIquBPx
    lens-5.3.3-Ag3JywAjDxJ2k98xBhf4hs
    network-3.1.4.0-LsWsY6caX6uCNLTGwySDR3
    psqueues-0.2.8.2-LsUAa3w1mPKDcfs17B3nfY
    random-1.2.1.3-HzFGhfPSv5b3eeTVe0g48p
    regex-tdfa-1.3.2.5-4Nt33WWCOhH70pmXr5RVz
    semigroupoids-6.0.1-DgRGywcI4cKAo6YP4lFHsp
    split-0.2.5-9bPPlQ4mlHj6gKeWe5Fjp8 stm-2.5.1.0
    template-haskell-2.20.0.0 text-2.0.2 time-1.12.2
    transformers-0.6.1.0 typed-process-0.2.13.0-40GtvANGP6yKk97Fq1akCj
    unix-2.8.4.0 unordered-containers-0.2.20.1-I6eyTXb69D2BhxejMtPouo
    vector-0.13.2.0-KFVS0U8K6eML5O0P7tVbRi
    vty-6.2-6i5q23gZbHJ7XNQnEoipug

haddock-interfaces:   /usr/share/doc/glirc/html/glirc.haddock
haddock-html:         /usr/share/doc/glirc/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

