---
stage: AI-powered
group: Workflow Catalog
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: セキュリティ分析エージェント
---

{{< details >}}

- プラン: Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

この機能は[GitLabクレジット](../../../../subscriptions/gitlab_credits.md)を使用します。

{{< /details >}}

{{< history >}}

- GitLab 18.6で[導入](https://gitlab.com/groups/gitlab-org/-/epics/19659)されました。
- GitLab 18.8で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/work_items/585273)になりました。

{{< /history >}}

セキュリティ分析エージェントは、GitLabの脆弱性管理およびセキュリティ分析ワークフローを支援する特化型AIアシスタントです。セキュリティの専門知識と、GitLabのセキュリティ機能、脆弱性レポート、セキュリティダッシュボード、コンプライアンスツールに関する深い知識を組み合わせることで、セキュリティ検出結果を効率的にトリアージ、評価、修正できるよう支援します。

セキュリティ分析エージェントは、次のような場合に役立ちます:

- 脆弱性トリアージ: さまざまなスキャンタイプにわたって、セキュリティ検出結果を分析し、優先順位を付ける。
- リスク評価: 脆弱性の重大度、悪用可能性、ビジネスへの影響を評価する。
- 誤検出の特定: 実際の脅威と無害な検出結果を見分ける。
- コンプライアンス管理: 規制要件と修正タイムラインを理解する。
- セキュリティレポート: セキュリティ対策状況と修正の進捗状況の要約を生成する。
- 修正計画: セキュリティ脆弱性に対処するための実行可能な計画を作成する。
- セキュリティワークフローの自動化: 繰り返し発生するセキュリティ評価タスクを効率化する。

セキュリティ分析エージェントは、脆弱性の状態、重大度レベル、セキュリティスキャナーの出力など、GitLab固有のセキュリティ実装を理解しています。EPSSスコア、CVEデータ、到達可能性分析を解釈し、コンテキストに応じたセキュリティガイダンスを提供できます。

## セキュリティ分析エージェントにアクセスする {#access-the-security-analyst-agent}

前提条件: 

- セキュリティスキャンが有効になっているGitLabプロジェクトで作業している必要があります。
- 基本エージェントを[オン](_index.md#turn-foundational-agents-on-or-off)にする必要があります。

1. 上部のバーで、**検索または移動先**を選択して、プロジェクトを見つけます。

1. GitLab Duoのサイドバーで、**新しいGitLab Duo Chat**（{{< icon name="pencil-square" >}}）または**現在のGitLab Duo Chat**（{{< icon name="duo-chat" >}}）を選択します。

   画面右側のGitLab Duoサイドバーに、Chatの会話が表示されます。

1. **新しいチャット**（{{< icon name="duo-chat-new" >}}）ドロップダウンリストから、**セキュリティ分析**を選択します。
1. セキュリティに関する質問またはリクエストを入力します。リクエストから最良の結果を得るには、次の点に留意してください:

   - セキュリティ要件とリスク許容度に関するコンテキストを提供する。
   - 重視している脆弱性の種類やスキャン結果を指定する。
   - 分析をリクエストする場合は、関連するプロジェクトやコンポーネントの詳細を含める。
   - セキュリティ分析エージェントの推奨事項が自社のセキュリティポリシーと一致しない場合は、補足説明を求める。
   - 特定の検出結果について議論する場合は、脆弱性IDやURLを具体的に指定する。

## プロンプトの例 {#example-prompts}

- 脆弱性分析:
  - 「プロジェクト内の重大な脆弱性をすべて表示してください。」
  - 「EPSSスコアが0.7を超え、かつ到達可能な脆弱性を一覧表示してください。」
  - 「悪用可能性に基づいて、優先的に対応すべきSASTの検出結果はどれですか？」
  - 「（コンポーネント名）に含まれる脆弱性のセキュリティへの影響を分析してください。」
  - 「このリリースと前回のリリースにおける脆弱性の傾向を比較してください。」
- リスク評価: 
  - 「これらのコンテナスキャンの検出結果によるビジネスリスクは何ですか？」
  - 「この依存関係の脆弱性が当社のユースケースに影響するか、評価するのを手伝ってください。」
  - 「信頼境界を越える脆弱性の重大度を評価してください。」
  - 「本番環境に最大のリスクをもたらす脆弱性はどれですか？」
- トリアージと管理:
  - 「到達不能なコードに起因する誤検出としてマークされている、依存関係スキャンの脆弱性をすべて却下してください。」
  - 「既知のエクスプロイトがある、すべてのコンテナスキャンの脆弱性を確認してください。」
  - 「信頼境界を越えるすべての脆弱性の重大度を高に更新してください。」
  - 「過去1週間に却下された脆弱性と、その理由を表示してください。」
  - 「再評価のため、脆弱性のステータスを検出済みに戻してください。」
- イシュー管理:
  - 「確認済みの重大度が高いSAST脆弱性すべてについてイシューを作成し、最近のコミッターに割り当ててください。」
  - 「修正を追跡するために、脆弱性（脆弱性ID）をイシュー（イシューID）にリンクしてください。」
  - 「重要なインフラストラクチャの脆弱性に対する修正タスクを生成してください。」
  - 「すべての認証関連の脆弱性を追跡するためのセキュリティエピックを作成してください。」
- レポートとコンプライアンス:
  - 「現在のセキュリティ対策状況について、エグゼクティブサマリーを生成してください。」
  - 「修正の進捗状況を示すコンプライアンスレポートの下書きを作成してください。」
  - 「セキュリティ審査会向けに、セキュリティ検出結果を要約してください。」
  - 「重大度の高いすべての検出結果に対処するためのタイムラインを作成してください。」
- 修正ガイダンス:
  - 「これらのSQLインジェクションの脆弱性に対する修正アプローチを提案してください。」
  - 「このコンテナベースイメージの脆弱性に対して推奨される修正は何ですか？」
  - 「次のスプリントに向けたセキュリティパッチの優先順位付けを手伝ってください。」
  - 「これらの問題を防ぐための安全なコーディング手法に関するガイダンスを提供してください。」
