---
stage: AI-powered
group: Workflow Catalog
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: カスタムエージェント
---

{{< details >}}

- プラン: Premium、Ultimate
- アドオン: GitLab Duo Core、Pro、またはEnterprise
- 提供形態: GitLab.com、GitLab Self-Managed

この機能は[GitLabクレジット](../../../subscriptions/gitlab_credits.md)を使用します。

{{< /details >}}

{{< collapsible title="モデル情報" >}}

- セルフホストモデル対応のGitLab Duoでは利用不可

{{< /collapsible >}}

{{< history >}}

- GitLab 18.5で`global_ai_catalog`[フラグ](../../../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/549914)されました。GitLab.comで有効になりました。
- GitLab 18.7でグループでの有効化が`ai_catalog_agents`[フラグ](../../../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/580307)されました。GitLab.comで有効になりました。
- GitLab 18.7でベータ版に[変更](https://gitlab.com/gitlab-org/gitlab/-/issues/568176)されました。
- GitLab 18.8で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/work_items/585273)になりました。

{{< /history >}}

{{< alert type="flag" >}}

この機能の利用可否は、機能フラグによって制御されます。詳細については、履歴を参照してください。

{{< /alert >}}

エージェントはAIを使用してタスクを実行し、複雑な質問に答えます。マージリクエストの作成やコードのレビューなど、特定のタスクを実行するためのカスタムエージェントを作成できます。また、AIカタログを使用して、GitLabによって作成されたエージェントを見つけることもできます。

エージェントとやり取りする準備ができたら、エージェントを有効にして、GitLab Duo Chatで使用を開始できます。

## エージェントの表示レベル {#agent-visibility}

カスタムエージェントを作成する際は、そのエージェントを管理するプロジェクトを選択し、エージェントを公開または非公開のどちらにするかを選択します。

公開エージェント:

- 誰でも閲覧でき、前提条件を満たすすべてのプロジェクトで有効にできます。

非公開エージェント:

- 管理対象プロジェクトのデベロッパーロール以上を持つメンバーのみが閲覧できます。
- 管理対象プロジェクト以外のプロジェクトでは有効にできません。

エージェントが現在有効になっている場合、非公開エージェントを公開エージェントに変更することはできません。

## プロジェクトのエージェントを表示する {#view-the-agents-for-your-project}

前提条件: 

- プロジェクトのデベロッパーロール以上が必要です。

プロジェクトに関連付けられたエージェントのリストを表示するには:

1. 上部のバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **自動化** > **エージェント**を選択します。
   - プロジェクトで有効になっているエージェントを表示するには、**有効**タブを選択します。
   - プロジェクトで管理されているエージェントを表示するには、**Managed**タブを選択します。

エージェントを選択して詳細を表示します。

## エージェントを作成する {#create-an-agent}

プロジェクトから、またはAIカタログを使用して、エージェントを作成できます。

前提条件: 

- プロジェクトのメンテナーロール以上が必要です。

{{< tabs >}}

{{< tab title="プロジェクトから" >}}

エージェントを作成するには:

1. 上部のバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **自動化** > **エージェント**を選択します。
1. **新しいエージェント**を選択します。
1. **基本情報**で、次の操作を行います:
   1. **表示名**に、エージェントの名前を入力します。
   1. **説明**に、エージェントの説明を入力します。
1. **表示レベルとアクセス**の下にある**表示レベル**で、**非公開**または**公開**を選択します。
1. **プロンプト**の下にある**システムプロンプト**に、エージェントの特性、専門知識、動作を定義するプロンプトを入力します。
1. オプション。**利用可能なツール**の下にある**ツール**ドロップダウンリストから、エージェントがアクセスできるツールを選択します。たとえば、エージェントにイシューを自動的に作成させるには、**イシューを作成**を選択します。

   利用可能なツールのリストについては、[組み込みツールの定義](https://gitlab.com/gitlab-org/gitlab/-/blob/master/ee/lib/ai/catalog/built_in_tool_definitions.rb)を参照してください。
1. **エージェントを作成**を選択します。

{{< /tab >}}

{{< tab title="AIカタログから" >}}

エージェントを作成するには:

1. 上部のバーで、**検索または移動先** > **検索**を選択します。
1. **AIカタログ**を選択し、次に**エージェント**タブを選択します。
1. **新しいエージェント**を選択します。
1. **基本情報**で、次の操作を行います:
   1. **表示名**に、エージェントの名前を入力します。
   1. **説明**に、エージェントの説明を入力します。
1. **表示レベルとアクセス**で、次の操作を行います:
   1. **管理済み**ドロップダウンリストから、エージェントのプロジェクトを選択します。
   1. **表示レベル**で、**非公開**または**公開**を選択します。
1. **プロンプト**の下にある**システムプロンプト**に、エージェントの特性、専門知識、動作を定義するプロンプトを入力します。
1. オプション。**利用可能なツール**の下にある**ツール**ドロップダウンリストから、エージェントがアクセスできるツールを選択します。たとえば、エージェントにイシューを自動的に作成させるには、**イシューを作成**を選択します。

   利用可能なツールのリストについては、[組み込みツールの定義](https://gitlab.com/gitlab-org/gitlab/-/blob/master/ee/lib/ai/catalog/built_in_tool_definitions.rb)を参照してください。
1. **エージェントを作成**を選択します。

{{< /tab >}}

{{< /tabs >}}

エージェントがAIカタログに表示されます。Chatでエージェントを使用するには、プロジェクトでエージェントを有効にします。

## エージェントを有効にする {#enable-an-agent}

Chatでエージェントを使用するには、エージェントを有効にします。エージェントを有効にするには、以下を実行する必要があります:

1. トップレベルグループで有効になっている。
1. 使用するプロジェクトで有効になっている。

### トップレベルグループで有効にする {#enable-in-a-top-level-group}

前提条件: 

- グループのオーナーロールが必要です。

トップレベルグループでエージェントを有効にするには:

1. 上部のバーで、**検索または移動先** > **検索**を選択します。
1. **AIカタログ**を選択し、次に**エージェント**タブを選択します。
1. 有効にするエージェントを選択します。
1. 右上隅で、**グループで有効にする**を選択します。
1. ドロップダウンリストから、エージェントを有効にするグループを選択します。
1. **有効化**を選択します。

エージェントがグループの**自動化** > **エージェント**ページに表示されます。

### プロジェクトで有効にする {#enable-in-a-project}

前提条件: 

- プロジェクトのメンテナーロール以上が必要です。
- エージェントは、トップレベルグループで有効になっている必要があります。

プロジェクトでエージェントを有効にするには:

1. 上部のバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **自動化** > **エージェント**を選択します。
1. 右上隅で、**グループからのエージェントを有効にする**を選択します。
1. ドロップダウンリストから、有効にするエージェントを選択します。
1. **有効化**を選択します。

プロジェクトの**自動化** > **エージェント**ページにエージェントが表示されます。プロジェクトで、エージェントとの新しいチャットを開始できます。詳細については、[エージェントを選択する](../../gitlab_duo_chat/agentic_chat.md#select-an-agent)を参照してください。

### エージェントを無効にする {#disable-an-agent}

前提条件: 

- グループの場合、オーナーロールが必要です。
- プロジェクトの場合、メンテナーロール以上が必要です。

エージェントを無効にするには:

1. 上部のバーで、**検索または移動先**を選択し、グループまたはプロジェクトを見つけます。
1. **自動化** > **エージェント**を選択します。
1. 削除するエージェントを見つけて、**アクション**（{{< icon name="ellipsis_v" >}}）> **無効化**を選択します。
1. 確認ダイアログで、**無効化**を選択します。

エージェントはプロジェクトに表示されなくなり、Chatで使用できなくなります。

## エージェントを複製する {#duplicate-an-agent}

元のエージェントを上書きせずに変更を加えるには、既存のエージェントのコピーを作成します。

前提条件: 

- プロジェクトのメンテナーロール以上が必要です。

エージェントを複製するには:

1. 上部のバーで、**検索または移動先** > **検索**を選択します。
1. **AIカタログ**を選択し、次に**エージェント**タブを選択します。
1. 複製するエージェントを選択します。
1. 右上隅で、**アクション**（{{< icon name="ellipsis_v" >}}）> **重複**を選択します。
1. オプション。変更するフィールドを編集します。
1. **エージェントを作成**を選択します。

## エージェントを管理する {#manage-agents}

エージェントの設定を変更するには編集し、AIカタログから削除するにはエージェントを削除します。

前提条件: 

- 管理対象プロジェクトのメンバーであり、メンテナーロール以上を持っている必要があります。

エージェントを管理するには:

1. 上部のバーで、**検索または移動先** > **検索**を選択します。
1. **AIカタログ**を選択し、次に**エージェント**タブを選択します。
1. 管理するエージェントを選択します。
   - エージェントを編集するには:
     1. 右上隅で、**編集**を選択します。
     1. 変更するフィールドを編集し、**変更を保存**を選択します。
   - エージェントを削除するには:
     1. 右上隅で、**アクション**（{{< icon name="ellipsis_v" >}}）> **削除**を選択します。
     1. 確認ダイアログで、**削除**を選択します。
