---
stage: Application Security Testing
group: Static Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 脆弱性スキャナーのメンテナンス
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

以下の脆弱性スキャナーとそのデータベースは定期的に更新されます:

| セキュアスキャンツール                                                     | 脆弱性データベースの更新 |
|:-------------------------------------------------------------------------|:---------------------------------|
| [コンテナスキャン](../container_scanning/_index.md)                       | ジョブは毎日実行され、アップストリームスキャナーからの最新の脆弱性データベースの更新で新しいイメージをビルドします。GitLabは、データベースが48時間以上経過した場合にエンジニアリングチームに通知する内部アラートを通じて、このジョブを監視します。詳細については、[脆弱性データベースの更新](../container_scanning/_index.md#vulnerabilities-database)を参照してください。 |
| [依存関係スキャン - Gemnasium](../dependency_scanning/_index.md)                     | National Vulnerability Database（NVD）およびGitHub Advisory Databaseのデータを使用して1時間ごとに更新される[GitLab Advisory Database](../gitlab_advisory_database/_index.md)に依存します。 |
| [動的アプリケーションセキュリティテスト（DAST）](../dast/_index.md)            | [DAST](../dast/browser/_index.md)アナライザーは定期的に更新されます。 |
| [シークレット検出](../secret_detection/pipeline/_index.md#detected-secrets) | GitLabは[検出ルール](../secret_detection/pipeline/_index.md#detected-secrets)を保持し、[コミュニティからのコントリビュートを受け付け](../secret_detection/pipeline/configure.md#add-new-patterns)ます。関連する更新プログラムが利用可能な場合、スキャンエンジンは少なくとも月に1回更新されます。 |
| [静的アプリケーションセキュリティテスト（SAST）](../sast/_index.md)             | スキャンルールのソースは、[サポートされているプログラミング言語](../sast/_index.md#supported-languages-and-frameworks)ごとに使用される[アナライザー](../sast/analyzers.md)によって異なります。GitLabは、Semgrepベースのアナライザーのルールセットを保持し、内部調査とユーザーフィードバックに基づいて定期的に更新します。他のアナライザーの場合、ルールセットはアップストリームのオープンソーススキャナーから供給されます。関連する更新プログラムが利用可能な場合、各アナライザーは少なくとも月に1回更新されます。 |

アナライザーの同じメジャーバージョンを使用するGitLabのバージョンでは、最新の脆弱性定義の恩恵を受けるためにそれらを更新する必要はありません。セキュリティツールはDockerイメージとしてリリースされます。それらを有効にするベンダーのジョブ定義は、[セマンティックバージョニング](https://semver.org/)に従ってメジャーリリースタグを使用します。ツールの新しいリリースごとに、これらのタグがオーバーライドされます。メジャーアナライザーバージョンでは、スキャンツールの最新バージョンが自動的に取得されますが、このアプローチにはいくつかの[既知のイシュー](https://gitlab.com/gitlab-org/gitlab/-/issues/9725)があります。

{{< alert type="note" >}}

既存の脆弱性に関する最新の脆弱性情報を入手するには、デフォルトブランチのパイプラインを再実行する必要がある場合があります。

{{< /alert >}}
