/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.os.Clock;
import java.io.PrintStream;

public class TSPrinter {
    private static TSPrinter err;
    private static TSPrinter out;
    private final PrintStream parent;

    public static synchronized TSPrinter stderr() {
        if (null == err) {
            err = new TSPrinter(System.err);
        }
        return err;
    }

    public static synchronized TSPrinter stdout() {
        if (null == out) {
            out = new TSPrinter(System.out);
        }
        return out;
    }

    public TSPrinter(PrintStream printStream) {
        this.parent = printStream;
    }

    public static void printf(PrintStream printStream, long l, String string, Object ... objectArray) {
        printStream.printf("[%,9d] ", l);
        printStream.printf(string, objectArray);
    }

    public static void printf(PrintStream printStream, String string, Object ... objectArray) {
        TSPrinter.printf(printStream, Clock.currentMillis(), string, objectArray);
    }

    public void printf(long l, String string, Object ... objectArray) {
        TSPrinter.printf(this.parent, l, string, objectArray);
    }

    public void printf(String string, Object ... objectArray) {
        TSPrinter.printf(this.parent, Clock.currentMillis(), string, objectArray);
    }

    public static void print(PrintStream printStream, long l, String string) {
        printStream.printf("[%,9d] %s", l, string);
    }

    public static void print(PrintStream printStream, String string) {
        TSPrinter.print(printStream, Clock.currentMillis(), string);
    }

    public void print(long l, String string) {
        TSPrinter.print(this.parent, l, string);
    }

    public void print(String string) {
        TSPrinter.print(this.parent, Clock.currentMillis(), string);
    }

    public static void println(PrintStream printStream, long l, String string) {
        printStream.printf("[%,9d] %s%n", l, string);
    }

    public static void println(PrintStream printStream, String string) {
        TSPrinter.println(printStream, Clock.currentMillis(), string);
    }

    public void println(long l, String string) {
        TSPrinter.println(this.parent, l, string);
    }

    public void println(String string) {
        TSPrinter.println(this.parent, Clock.currentMillis(), string);
    }
}

