/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.outline;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import javax.swing.JPanel;
import org.freeplane.view.swing.map.outline.NavigationButtons;
import org.freeplane.view.swing.map.outline.OutlineBlockLayout;
import org.freeplane.view.swing.map.outline.OutlineBlockViewCache;
import org.freeplane.view.swing.map.outline.OutlineFocusManager;
import org.freeplane.view.swing.map.outline.OutlineViewport;
import org.freeplane.view.swing.map.outline.OutlineVisibleBlockRange;
import org.freeplane.view.swing.map.outline.TreeNode;
import org.freeplane.view.swing.map.outline.VisibleOutlineNodes;

final class VisibleBlockRenderer {
    private OutlineViewport viewport;
    private final OutlineBlockLayout blockLayout;
    private final OutlineBlockViewCache blockCache;
    private final JPanel blockPanel;
    private final VisibleOutlineNodes visibleNodes;
    private final NavigationButtons navigationButtons;
    private final OutlineFocusManager focusManager;
    private final IntSupplier panelWidthSupplier;
    private final Runnable updatePreferredSize;
    private final Runnable refreshUI;
    private final Runnable updateFirstVisibleNodeId;
    private final Predicate<TreeNode> isInBreadcrumbArea;
    private OutlineVisibleBlockRange lastVisibleRange;

    VisibleBlockRenderer(OutlineBlockLayout blockLayout, OutlineBlockViewCache blockCache, JPanel blockPanel, VisibleOutlineNodes visibleNodes, NavigationButtons navigationButtons, OutlineFocusManager focusManager, IntSupplier panelWidthSupplier, Runnable updatePreferredSize, Runnable refreshUI, Runnable updateFirstVisibleNodeId, Predicate<TreeNode> isInBreadcrumbArea) {
        this.blockLayout = blockLayout;
        this.blockCache = blockCache;
        this.blockPanel = blockPanel;
        this.visibleNodes = visibleNodes;
        this.navigationButtons = navigationButtons;
        this.focusManager = focusManager;
        this.panelWidthSupplier = panelWidthSupplier;
        this.updatePreferredSize = updatePreferredSize;
        this.refreshUI = refreshUI;
        this.updateFirstVisibleNodeId = updateFirstVisibleNodeId;
        this.isInBreadcrumbArea = isInBreadcrumbArea;
    }

    void setViewport(OutlineViewport viewport) {
        this.viewport = viewport;
        this.resetCachedRange();
    }

    void resetCachedRange() {
        this.lastVisibleRange = null;
    }

    void render() {
        this.render(false, 0);
    }

    void renderFromIndex(int startFromNodeIndex) {
        this.render(true, startFromNodeIndex);
    }

    private void render(boolean repositionViewport, int startFromNodeIndex) {
        boolean unchanged;
        if (this.viewport == null) {
            return;
        }
        Component previousFocus = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        boolean focusWasInsideOutline = this.focusManager.isWithinOutline(previousFocus);
        if (repositionViewport) {
            this.viewport.setViewPosition(startFromNodeIndex, this.visibleNodes.getBreadcrumbHeight() - this.visibleNodes.getBlockPanelY());
        }
        OutlineVisibleBlockRange range = this.viewport.calculateVisibleBlockRange();
        boolean haveBlocks = !this.blockCache.isEmpty();
        boolean bl = unchanged = !repositionViewport && haveBlocks && range.equals(this.lastVisibleRange);
        if (unchanged) {
            this.viewport.refreshViewport();
            this.updateFirstVisibleNodeId.run();
            this.lastVisibleRange = range;
            this.focusManager.restoreFocusIfNeeded(focusWasInsideOutline);
            return;
        }
        this.blockLayout.removeBlocksOutsideRange(this.blockPanel, range);
        this.blockLayout.updateVisibleBlocks(this.blockPanel, range, this.panelWidthSupplier.getAsInt());
        this.lastVisibleRange = range;
        this.updatePreferredSize.run();
        this.refreshUI.run();
        this.updateFirstVisibleNodeId.run();
        this.attachNavigationButtonsIfNeeded();
        this.focusManager.restoreFocusIfNeeded(focusWasInsideOutline);
    }

    private void attachNavigationButtonsIfNeeded() {
        boolean inBreadcrumb;
        TreeNode hoveredNode = this.visibleNodes.getHoveredNode();
        if (hoveredNode == null || hoveredNode.getChildren().isEmpty()) {
            return;
        }
        boolean bl = inBreadcrumb = this.visibleNodes.isHoveredNodeContainedInBreadcrumb() && this.isInBreadcrumbArea.test(hoveredNode);
        if (!inBreadcrumb) {
            this.navigationButtons.attachToNode(hoveredNode, this.blockPanel, this.visibleNodes.findNodeIndexInVisibleList(hoveredNode), hoveredNode.getLevel());
        }
    }
}

