/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon.factory;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

public class WeakValueCache<K, V> {
    private final Map<K, WeakReference<V>> map = new HashMap<K, WeakReference<V>>();

    public boolean containsKey(String key) {
        WeakReference<V> weakReference = this.map.get(key);
        return weakReference != null && weakReference.get() != null;
    }

    public V get(K key) {
        WeakReference<V> weakReference = this.map.get(key);
        return weakReference != null ? (V)weakReference.get() : null;
    }

    public void put(K key, V value) {
        if (value == null) {
            throw new IllegalArgumentException("null values are not allowed");
        }
        WeakReference<V> reference = new WeakReference<V>(value);
        this.map.put(key, reference);
    }
}

