/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.greenplum.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.greenplum.model.GreenplumDataSource;
import org.jkiss.dbeaver.ext.greenplum.model.GreenplumExternalTable;
import org.jkiss.dbeaver.ext.greenplum.model.GreenplumFunction;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedure;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTable;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableContainer;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class GreenplumSchema
extends PostgreSchema {
    public GreenplumSchema(PostgreDatabase owner, String name, JDBCResultSet resultSet) throws SQLException {
        super(owner, name, (ResultSet)resultSet);
    }

    @NotNull
    protected PostgreSchema.ProceduresCache createProceduresCache() {
        return new GreenplumFunctionsCache(this);
    }

    @NotNull
    protected PostgreSchema.TableCache createTableCache() {
        return new GreenplumTableCache();
    }

    @NotNull
    public GreenplumDataSource getDataSource() {
        return (GreenplumDataSource)super.getDataSource();
    }

    @Association
    public Collection<? extends JDBCTable> getExternalTables(DBRProgressMonitor monitor) throws DBException {
        return new ArrayList(this.getTableCache().getTypedObjects(monitor, (DBSObject)this, GreenplumExternalTable.class));
    }

    public List<? extends PostgreTable> getTables(DBRProgressMonitor monitor) throws DBException {
        List postgreTables = super.getTables(monitor);
        return postgreTables.stream().filter(e -> !(e instanceof GreenplumExternalTable)).collect(Collectors.toCollection(ArrayList::new));
    }

    public List<? extends PostgreTable> getForeignTables(DBRProgressMonitor monitor) throws DBException {
        List foreignTables = super.getForeignTables(monitor);
        GreenplumDataSource dataSource = this.getDataSource();
        if (dataSource.isServerVersionAtLeast(7, 0) && dataSource.isHasAccessToExttable()) {
            return foreignTables.stream().filter(e -> !(e instanceof GreenplumExternalTable)).collect(Collectors.toCollection(ArrayList::new));
        }
        return foreignTables;
    }

    public class GreenplumFunctionsCache
    extends PostgreSchema.ProceduresCache {
        GreenplumFunctionsCache(GreenplumSchema this$0) {
        }

        @NotNull
        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull PostgreSchema owner, @Nullable PostgreProcedure object, @Nullable String objectName) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT p.oid as poid,p.*," + (session.getDataSource().isServerVersionAtLeast(8, 4) ? "pg_catalog.pg_get_expr(p.proargdefaults, 0)" : "NULL") + " as arg_defaults,d.description\nFROM pg_catalog.pg_proc p\nLEFT OUTER JOIN pg_catalog.pg_description d ON d.objoid=p.oid\nWHERE p.pronamespace=?" + (object == null ? "" : " AND p.oid=?") + "\nORDER BY p.proname");
            dbStat.setLong(1, owner.getObjectId());
            if (object != null) {
                dbStat.setLong(2, object.getObjectId());
            }
            return dbStat;
        }

        protected GreenplumFunction fetchObject(@NotNull JDBCSession session, @NotNull PostgreSchema owner, @NotNull JDBCResultSet dbResult) {
            return new GreenplumFunction(session.getProgressMonitor(), owner, (ResultSet)dbResult);
        }
    }

    public class GreenplumTableCache
    extends PostgreSchema.TableCache {
        private boolean before7version;

        GreenplumTableCache() {
            super((PostgreSchema)GreenplumSchema.this);
        }

        @NotNull
        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull PostgreTableContainer container, @Nullable PostgreTableBase object, @Nullable String objectName) throws SQLException {
            GreenplumDataSource dataSource = GreenplumSchema.this.getDataSource();
            boolean greenplumVersionAtLeast5 = dataSource.isGreenplumVersionAtLeast(5, 0);
            String uriLocationColumn = greenplumVersionAtLeast5 ? "urilocation" : "location";
            String execLocationColumn = greenplumVersionAtLeast5 ? "execlocation" : "location";
            boolean hasAccessToExttable = dataSource.isHasAccessToExttable();
            boolean supportsRelStorageColumn = dataSource.isServerSupportsRelstorageColumn(session);
            this.before7version = !dataSource.isGreenplumVersionAtLeast(7, 0);
            String sqlQuery = "SELECT c.oid,c.*,d.description,\n" + (this.before7version ? "p.partitiontablename,p.partitionboundary as partition_expr," : "pg_catalog.pg_get_expr(c.relpartbound, c.oid) as partition_expr, pg_catalog.pg_get_partkeydef(c.oid) as partition_key,") + (String)(hasAccessToExttable ? "CASE WHEN x." + uriLocationColumn + " IS NOT NULL THEN array_to_string(x." + uriLocationColumn + ", ',') ELSE '' END AS urilocation,\nCASE WHEN x.command IS NOT NULL THEN x.command ELSE '' END AS command,\nx.fmttype, x.fmtopts,\ncoalesce(x.rejectlimit, 0) AS rejectlimit,\ncoalesce(x.rejectlimittype, '') AS rejectlimittype,\narray_to_string(x." + execLocationColumn + ", ',') AS execlocation,\npg_encoding_to_char(x.encoding) AS encoding,\nx.writable,\n" : "") + (dataSource.isServerSupportFmterrtblColumn(session) ? "case when x.fmterrtbl is not NULL then true else false end as \"is_logging_errors\",\n" : "") + (supportsRelStorageColumn ? "case when c.relstorage = 'x' then true else false end as \"is_ext_table\"" : (hasAccessToExttable ? "\ncase when x.fmttype is not null then true else false end as \"is_ext_table\"" : "false as \"is_ext_table\"")) + "\n,case when (ns.nspname !~ '^pg_toast' and ns.nspname like 'pg_temp%') then true else false end as \"is_temp_table\"\n" + (this.before7version ? "" : ", pa.amname\n") + "\nFROM pg_catalog.pg_class c\nINNER JOIN pg_catalog.pg_namespace ns\n\ton ns.oid = c.relnamespace\nLEFT OUTER JOIN pg_catalog.pg_description d\n\tON d.objoid=c.oid AND d.objsubid=0\n" + (hasAccessToExttable ? "LEFT OUTER JOIN pg_catalog.pg_exttable x\n\ton x.reloid = c.oid\n" : "") + (this.before7version ? "LEFT OUTER JOIN pg_catalog.pg_partitions p\n\ton c.relname = p.partitiontablename and ns.nspname = p.schemaname\n" : "") + (this.before7version ? "" : "\nLEFT JOIN pg_catalog.pg_am pa ON pa.oid = c.relam") + "\nWHERE c.relnamespace= ? AND c.relkind not in ('i','c') " + (object == null && objectName == null ? "" : " AND relname=?");
            JDBCPreparedStatement dbStat = session.prepareStatement(sqlQuery);
            dbStat.setLong(1, GreenplumSchema.this.getObjectId());
            if (object != null || objectName != null) {
                dbStat.setString(2, object != null ? object.getName() : objectName);
            }
            return dbStat;
        }

        protected boolean isPartitionTableRow(@NotNull JDBCResultSet dbResult) {
            return this.before7version ? CommonUtils.isNotEmpty((String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"partitiontablename")) : super.isPartitionTableRow(dbResult);
        }
    }
}

