/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices.recovery;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class VerifyIndex
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, VerifyIndex> {
    @Nullable
    private final Time checkIndexTime;
    private final long checkIndexTimeInMillis;
    @Nullable
    private final Time totalTime;
    private final long totalTimeInMillis;
    public static final JsonpDeserializer<VerifyIndex> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, VerifyIndex::setupVerifyIndexDeserializer);

    private VerifyIndex(Builder builder) {
        this.checkIndexTime = builder.checkIndexTime;
        this.checkIndexTimeInMillis = ApiTypeHelper.requireNonNull(builder.checkIndexTimeInMillis, this, "checkIndexTimeInMillis");
        this.totalTime = builder.totalTime;
        this.totalTimeInMillis = ApiTypeHelper.requireNonNull(builder.totalTimeInMillis, this, "totalTimeInMillis");
    }

    public static VerifyIndex of(Function<Builder, ObjectBuilder<VerifyIndex>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Time checkIndexTime() {
        return this.checkIndexTime;
    }

    public final long checkIndexTimeInMillis() {
        return this.checkIndexTimeInMillis;
    }

    @Nullable
    public final Time totalTime() {
        return this.totalTime;
    }

    public final long totalTimeInMillis() {
        return this.totalTimeInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.checkIndexTime != null) {
            generator.writeKey("check_index_time");
            this.checkIndexTime.serialize(generator, mapper);
        }
        generator.writeKey("check_index_time_in_millis");
        generator.write(this.checkIndexTimeInMillis);
        if (this.totalTime != null) {
            generator.writeKey("total_time");
            this.totalTime.serialize(generator, mapper);
        }
        generator.writeKey("total_time_in_millis");
        generator.write(this.totalTimeInMillis);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupVerifyIndexDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::checkIndexTime, Time._DESERIALIZER, "check_index_time");
        op.add(Builder::checkIndexTimeInMillis, JsonpDeserializer.longDeserializer(), "check_index_time_in_millis");
        op.add(Builder::totalTime, Time._DESERIALIZER, "total_time");
        op.add(Builder::totalTimeInMillis, JsonpDeserializer.longDeserializer(), "total_time_in_millis");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.checkIndexTime);
        result = 31 * result + Long.hashCode(this.checkIndexTimeInMillis);
        result = 31 * result + Objects.hashCode(this.totalTime);
        result = 31 * result + Long.hashCode(this.totalTimeInMillis);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VerifyIndex other = (VerifyIndex)o;
        return Objects.equals(this.checkIndexTime, other.checkIndexTime) && this.checkIndexTimeInMillis == other.checkIndexTimeInMillis && Objects.equals(this.totalTime, other.totalTime) && this.totalTimeInMillis == other.totalTimeInMillis;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, VerifyIndex> {
        @Nullable
        private Time checkIndexTime;
        private Long checkIndexTimeInMillis;
        @Nullable
        private Time totalTime;
        private Long totalTimeInMillis;

        public Builder() {
        }

        private Builder(VerifyIndex o) {
            this.checkIndexTime = o.checkIndexTime;
            this.checkIndexTimeInMillis = o.checkIndexTimeInMillis;
            this.totalTime = o.totalTime;
            this.totalTimeInMillis = o.totalTimeInMillis;
        }

        private Builder(Builder o) {
            this.checkIndexTime = o.checkIndexTime;
            this.checkIndexTimeInMillis = o.checkIndexTimeInMillis;
            this.totalTime = o.totalTime;
            this.totalTimeInMillis = o.totalTimeInMillis;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder checkIndexTime(@Nullable Time value) {
            this.checkIndexTime = value;
            return this;
        }

        @Nonnull
        public final Builder checkIndexTime(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.checkIndexTime(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder checkIndexTimeInMillis(long value) {
            this.checkIndexTimeInMillis = value;
            return this;
        }

        @Nonnull
        public final Builder totalTime(@Nullable Time value) {
            this.totalTime = value;
            return this;
        }

        @Nonnull
        public final Builder totalTime(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.totalTime(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder totalTimeInMillis(long value) {
            this.totalTimeInMillis = value;
            return this;
        }

        @Override
        @Nonnull
        public VerifyIndex build() {
            this._checkSingleUse();
            return new VerifyIndex(this);
        }
    }
}

