/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.mapping;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.mapping.Property;
import org.opensearch.client.opensearch._types.mapping.PropertyBase;
import org.opensearch.client.opensearch._types.mapping.PropertyVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class JoinProperty
extends PropertyBase
implements PropertyVariant,
ToCopyableBuilder<Builder, JoinProperty> {
    @Nullable
    private final Boolean eagerGlobalOrdinals;
    @Nonnull
    private final Map<String, List<String>> relations;
    public static final JsonpDeserializer<JoinProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, JoinProperty::setupJoinPropertyDeserializer);

    private JoinProperty(Builder builder) {
        super(builder);
        this.eagerGlobalOrdinals = builder.eagerGlobalOrdinals;
        this.relations = ApiTypeHelper.unmodifiable(builder.relations);
    }

    public static JoinProperty of(Function<Builder, ObjectBuilder<JoinProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.Join;
    }

    @Nullable
    public final Boolean eagerGlobalOrdinals() {
        return this.eagerGlobalOrdinals;
    }

    @Nonnull
    public final Map<String, List<String>> relations() {
        return this.relations;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "join");
        super.serializeInternal(generator, mapper);
        if (this.eagerGlobalOrdinals != null) {
            generator.writeKey("eager_global_ordinals");
            generator.write(this.eagerGlobalOrdinals.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.relations)) {
            generator.writeKey("relations");
            generator.writeStartObject();
            for (Map.Entry<String, List<String>> item0 : this.relations.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.writeStartArray();
                if (item0.getValue() != null) {
                    for (String item1 : item0.getValue()) {
                        generator.write(item1);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupJoinPropertyDeserializer(ObjectDeserializer<Builder> op) {
        JoinProperty.setupPropertyBaseDeserializer(op);
        op.add(Builder::eagerGlobalOrdinals, JsonpDeserializer.booleanDeserializer(), "eager_global_ordinals");
        op.add(Builder::relations, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer())), "relations");
        op.ignore("type");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.eagerGlobalOrdinals);
        result = 31 * result + Objects.hashCode(this.relations);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JoinProperty other = (JoinProperty)o;
        return Objects.equals(this.eagerGlobalOrdinals, other.eagerGlobalOrdinals) && Objects.equals(this.relations, other.relations);
    }

    public static class Builder
    extends PropertyBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, JoinProperty> {
        @Nullable
        private Boolean eagerGlobalOrdinals;
        @Nullable
        private Map<String, List<String>> relations;

        public Builder() {
        }

        private Builder(JoinProperty o) {
            super(o);
            this.eagerGlobalOrdinals = o.eagerGlobalOrdinals;
            this.relations = Builder._mapCopy(o.relations);
        }

        private Builder(Builder o) {
            super(o);
            this.eagerGlobalOrdinals = o.eagerGlobalOrdinals;
            this.relations = Builder._mapCopy(o.relations);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder eagerGlobalOrdinals(@Nullable Boolean value) {
            this.eagerGlobalOrdinals = value;
            return this;
        }

        @Nonnull
        public final Builder relations(Map<String, List<String>> map) {
            this.relations = Builder._mapPutAll(this.relations, map);
            return this;
        }

        @Nonnull
        public final Builder relations(String key, List<String> value) {
            this.relations = Builder._mapPut(this.relations, key, value);
            return this;
        }

        @Override
        @Nonnull
        public JoinProperty build() {
            this._checkSingleUse();
            return new JoinProperty(this);
        }
    }
}

