/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.pipeline;

import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.search.pipeline.PipelineProcessingContext;
import org.opensearch.search.pipeline.ProcessorExecutionDetail;
import org.opensearch.search.pipeline.SearchResponseProcessor;

public class TrackingSearchResponseProcessorWrapper
implements SearchResponseProcessor {
    private final SearchResponseProcessor wrappedProcessor;

    public TrackingSearchResponseProcessorWrapper(SearchResponseProcessor wrappedProcessor) {
        if (wrappedProcessor == null) {
            throw new IllegalArgumentException("Wrapped processor cannot be null.");
        }
        this.wrappedProcessor = wrappedProcessor;
    }

    @Override
    public String getType() {
        return this.wrappedProcessor.getType();
    }

    @Override
    public String getTag() {
        return this.wrappedProcessor.getTag();
    }

    @Override
    public String getDescription() {
        return this.wrappedProcessor.getDescription();
    }

    @Override
    public boolean isIgnoreFailure() {
        return this.wrappedProcessor.isIgnoreFailure();
    }

    @Override
    public SearchResponse processResponse(SearchRequest request, SearchResponse response) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public SearchResponse processResponse(SearchRequest request, SearchResponse response, PipelineProcessingContext requestContext) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void processResponseAsync(SearchRequest request, SearchResponse response, PipelineProcessingContext requestContext, ActionListener<SearchResponse> responseListener) {
        ProcessorExecutionDetail detail = new ProcessorExecutionDetail(this.getType(), this.getTag());
        long start = System.nanoTime();
        try {
            detail.addInput(Arrays.asList(response.getHits().deepCopy().getHits()));
        }
        catch (IOException e2) {
            responseListener.onFailure((Exception)e2);
            return;
        }
        this.wrappedProcessor.processResponseAsync(request, response, requestContext, (ActionListener<SearchResponse>)ActionListener.wrap(result -> {
            detail.addOutput(Arrays.asList(result.getHits().deepCopy().getHits()));
            long took = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
            detail.addTook(took);
            requestContext.addProcessorExecutionDetail(detail);
            responseListener.onResponse(result);
        }, e -> {
            detail.markProcessorAsFailed(ProcessorExecutionDetail.ProcessorStatus.FAIL, e.getMessage());
            requestContext.addProcessorExecutionDetail(detail);
            responseListener.onFailure(e);
        }));
    }
}

