/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.store.remote.filecache;

import java.io.IOException;
import java.lang.ref.Cleaner;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.IndexInput;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.util.concurrent.OpenSearchExecutors;
import org.opensearch.index.store.remote.filecache.FileCache;
import org.opensearch.index.store.remote.filecache.FileCachedIndexInput;

@ExperimentalApi
public class FullFileCachedIndexInput
extends FileCachedIndexInput {
    private static final Logger logger = LogManager.getLogger(FullFileCachedIndexInput.class);
    private final IndexInputHolder indexInputHolder;
    private static final Cleaner CLEANER = Cleaner.create(OpenSearchExecutors.daemonThreadFactory("index-input-cleaner"));

    public FullFileCachedIndexInput(FileCache cache, Path filePath, IndexInput underlyingIndexInput) {
        this(cache, filePath, underlyingIndexInput, false);
    }

    public FullFileCachedIndexInput(FileCache cache, Path filePath, IndexInput underlyingIndexInput, boolean isClone) {
        super(cache, filePath, underlyingIndexInput, isClone);
        this.indexInputHolder = new IndexInputHolder(this.closed, underlyingIndexInput, isClone, cache, filePath);
        CLEANER.register((Object)this, this.indexInputHolder);
    }

    @Override
    public FullFileCachedIndexInput clone() {
        FullFileCachedIndexInput clonedIndexInput = new FullFileCachedIndexInput(this.cache, this.filePath, this.luceneIndexInput.clone(), true);
        this.cache.incRef(this.filePath);
        return clonedIndexInput;
    }

    @Override
    public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
        if (offset < 0L || length < 0L || offset + length > this.length()) {
            throw new IllegalArgumentException("slice() " + sliceDescription + " out of bounds: offset=" + offset + ",length=" + length + ",fileLength=" + this.length() + ": " + String.valueOf((Object)this));
        }
        IndexInput slicedLuceneIndexInput = this.luceneIndexInput.slice(sliceDescription, offset, length);
        FullFileCachedIndexInput slicedIndexInput = new FullFileCachedIndexInput(this.cache, this.filePath, slicedLuceneIndexInput, true);
        this.cache.incRef(this.filePath);
        return slicedIndexInput;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed.get()) {
            if (this.isClone) {
                this.cache.decRef(this.filePath);
            }
            try {
                this.luceneIndexInput.close();
            }
            catch (AlreadyClosedException e) {
                logger.trace("FullFileCachedIndexInput already closed");
            }
            this.luceneIndexInput = null;
            this.closed.set(true);
        }
    }

    public void indexInputHolderRun() {
        this.indexInputHolder.run();
    }

    private static class IndexInputHolder
    implements Runnable {
        private final AtomicBoolean closed;
        private final IndexInput indexInput;
        private final FileCache cache;
        private final boolean isClone;
        private final Path path;

        IndexInputHolder(AtomicBoolean closed, IndexInput indexInput, boolean isClone, FileCache cache, Path path) {
            this.closed = closed;
            this.indexInput = indexInput;
            this.isClone = isClone;
            this.cache = cache;
            this.path = path;
        }

        @Override
        public void run() {
            try {
                if (!this.closed.get()) {
                    this.indexInput.close();
                    if (this.isClone) {
                        this.cache.decRef(this.path);
                    }
                    this.closed.set(true);
                }
            }
            catch (IOException e) {
                logger.error("Failed to close IndexInput while clearing phantom reachable object");
            }
        }
    }
}

