/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax;

import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.lang.Args;

public class AjaxChannel
implements IClusterable {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_NAME = "0";
    public static final Type DEFAULT_TYPE = Type.QUEUE;
    public static final AjaxChannel DEFAULT = new AjaxChannel("0", DEFAULT_TYPE);
    private final String name;
    private final Type type;

    public AjaxChannel(String name) {
        this(name, Type.QUEUE);
    }

    public AjaxChannel(String name, Type type) {
        this.name = (String)Args.notNull((Object)name, (String)"name");
        this.type = (Type)((Object)Args.notNull((Object)((Object)type), (String)"type"));
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    String getChannelName() {
        return this.toString();
    }

    public String toString() {
        return this.name + "|" + this.type.shortType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AjaxChannel that = (AjaxChannel)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public static enum Type {
        QUEUE("s"),
        DROP("d"),
        ACTIVE("a");

        private final String shortType;

        private Type(String shortType) {
            this.shortType = shortType;
        }
    }
}

