/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.tasks;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParserHelper;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.tasks.TaskInfo;

public final class TaskResult
implements Writeable,
ToXContentObject {
    private final boolean completed;
    private final TaskInfo task;
    @Nullable
    private final BytesReference error;
    @Nullable
    private final BytesReference response;
    public static final ConstructingObjectParser<TaskResult, Void> PARSER = new ConstructingObjectParser("stored_task_result", a -> {
        int i = 0;
        boolean completed = (Boolean)a[i++];
        TaskInfo task = (TaskInfo)a[i++];
        BytesReference error = (BytesReference)a[i++];
        BytesReference response = (BytesReference)a[i++];
        return new TaskResult(completed, task, error, response);
    });

    public TaskResult(boolean completed, TaskInfo task) {
        this(completed, task, null, null);
    }

    public TaskResult(TaskInfo task, Exception error) throws IOException {
        this(true, task, TaskResult.toXContent(error), null);
    }

    public TaskResult(TaskInfo task, ToXContent response) throws IOException {
        this(true, task, null, XContentHelper.toXContent(response, Requests.INDEX_CONTENT_TYPE, true));
    }

    private TaskResult(boolean completed, TaskInfo task, @Nullable BytesReference error, @Nullable BytesReference result) {
        this.completed = completed;
        this.task = Objects.requireNonNull(task, "task is required");
        this.error = error;
        this.response = result;
    }

    public TaskResult(StreamInput in) throws IOException {
        this.completed = in.readBoolean();
        this.task = new TaskInfo(in);
        this.error = in.readOptionalBytesReference();
        this.response = in.readOptionalBytesReference();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.completed);
        this.task.writeTo(out);
        out.writeOptionalBytesReference(this.error);
        out.writeOptionalBytesReference(this.response);
    }

    public TaskInfo getTask() {
        return this.task;
    }

    public BytesReference getError() {
        return this.error;
    }

    public Map<String, Object> getErrorAsMap() {
        if (this.error == null) {
            return Collections.emptyMap();
        }
        return XContentHelper.convertToMap(this.error, false).v2();
    }

    public BytesReference getResponse() {
        return this.response;
    }

    public Map<String, Object> getResponseAsMap() {
        if (this.response == null) {
            return Collections.emptyMap();
        }
        return XContentHelper.convertToMap(this.response, false).v2();
    }

    public boolean isCompleted() {
        return this.completed;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.innerToXContent(builder, params);
        return builder.endObject();
    }

    public XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("completed", this.completed);
        builder.startObject("task");
        this.task.toXContent(builder, params);
        builder.endObject();
        if (this.error != null) {
            XContentHelper.writeRawField("error", this.error, builder, params);
        }
        if (this.response != null) {
            XContentHelper.writeRawField("response", this.response, builder, params);
        }
        return builder;
    }

    public String toString() {
        return Strings.toString(this);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != TaskResult.class) {
            return false;
        }
        TaskResult other = (TaskResult)obj;
        return Objects.equals(this.completed, other.completed) && Objects.equals(this.task, other.task) && Objects.equals(this.getErrorAsMap(), other.getErrorAsMap()) && Objects.equals(this.getResponseAsMap(), other.getResponseAsMap());
    }

    public int hashCode() {
        return Objects.hash(this.completed, this.task, this.getErrorAsMap(), this.getResponseAsMap());
    }

    private static BytesReference toXContent(Exception error) throws IOException {
        try (XContentBuilder builder = XContentFactory.contentBuilder(Requests.INDEX_CONTENT_TYPE);){
            builder.startObject();
            ElasticsearchException.generateThrowableXContent(builder, ToXContent.EMPTY_PARAMS, error);
            builder.endObject();
            BytesReference bytesReference = BytesReference.bytes(builder);
            return bytesReference;
        }
    }

    static {
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), new ParseField("completed", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), TaskInfo.PARSER, new ParseField("task", new String[0]));
        ObjectParserHelper<TaskResult, Void> parserHelper = new ObjectParserHelper<TaskResult, Void>();
        parserHelper.declareRawObject(PARSER, ConstructingObjectParser.optionalConstructorArg(), new ParseField("error", new String[0]));
        parserHelper.declareRawObject(PARSER, ConstructingObjectParser.optionalConstructorArg(), new ParseField("response", new String[0]));
    }
}

