/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.debug.ui.launchConfiguration;

import org.apache.uima.ruta.ide.RutaIdeUIPlugin;
import org.apache.uima.ruta.ide.core.builder.RutaProjectUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.PreferencesLookupDelegate;
import org.eclipse.dltk.debug.ui.launchConfigurations.MainLaunchConfigurationTab;
import org.eclipse.dltk.launching.AbstractScriptLaunchConfigurationDelegate;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class RutaMainLaunchConfigurationTab
extends MainLaunchConfigurationTab {
    private Text inputFolderText;
    private Button recursivelyButton;
    private Text outputFolderText;
    private Text viewText;

    public RutaMainLaunchConfigurationTab(String mode) {
        super(mode);
    }

    protected boolean breakOnFirstLinePrefEnabled(PreferencesLookupDelegate delegate) {
        return delegate.getBoolean("org.apache.uima.ruta.ide.ui", "dbgp_break_on_first_line");
    }

    protected boolean dbpgLoggingPrefEnabled(PreferencesLookupDelegate delegate) {
        return delegate.getBoolean("org.apache.uima.ruta.ide.ui", "dbgp_enable_logging");
    }

    public String getNatureID() {
        return "org.apache.uima.ruta.ide.nature";
    }

    protected void doCreateControl(Composite composite) {
        super.doCreateControl(composite);
        Group inputResourceGroup = new Group(composite, 0);
        inputResourceGroup.setText("Input Folder:");
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)inputResourceGroup);
        GridLayout inputResourceGroupLayout = new GridLayout(4, false);
        inputResourceGroup.setLayout((Layout)inputResourceGroupLayout);
        this.inputFolderText = new Text((Composite)inputResourceGroup, 2048);
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).span(3, 1).applyTo((Control)this.inputFolderText);
        this.inputFolderText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                RutaMainLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button browseInputResource = new Button((Composite)inputResourceGroup, 0);
        browseInputResource.setText("Browse ...");
        browseInputResource.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IResource resource;
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(RutaMainLaunchConfigurationTab.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                dialog.setTitle("Select input folder");
                dialog.setMessage("Select input folder");
                dialog.setInput((Object)RutaMainLaunchConfigurationTab.this.getProject().getProject());
                dialog.setInitialSelection((Object)RutaMainLaunchConfigurationTab.this.getWorkspaceRoot().findMember(RutaMainLaunchConfigurationTab.this.inputFolderText.getText()));
                if (dialog.open() == 0 && (resource = (IResource)dialog.getFirstResult()) != null) {
                    String fileLoc = resource.getFullPath().toString();
                    RutaMainLaunchConfigurationTab.this.inputFolderText.setText(fileLoc);
                }
            }
        });
        this.recursivelyButton = new Button((Composite)inputResourceGroup, 32);
        this.recursivelyButton.setText("Recursively");
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.recursivelyButton);
        this.recursivelyButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                RutaMainLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        Label viewLabel = new Label((Composite)inputResourceGroup, 0);
        viewLabel.setText("View Name:");
        this.viewText = new Text((Composite)inputResourceGroup, 2048);
        GridDataFactory.swtDefaults().hint(250, -1).align(16384, 0x1000000).grab(true, false).applyTo((Control)this.viewText);
        this.viewText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                RutaMainLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        Group outputFolderGroup = new Group(composite, 0);
        outputFolderGroup.setText("Output Folder:");
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)outputFolderGroup);
        GridLayout outputFolderGroupLayout = new GridLayout(2, false);
        outputFolderGroup.setLayout((Layout)outputFolderGroupLayout);
        this.outputFolderText = new Text((Composite)outputFolderGroup, 2048);
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.outputFolderText);
        this.outputFolderText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                RutaMainLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button browseOutputFolderButton = new Button((Composite)outputFolderGroup, 0);
        browseOutputFolderButton.setText("Browse ...");
        browseOutputFolderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String currentContainerString = RutaMainLaunchConfigurationTab.this.outputFolderText.getText();
                IContainer currentContainer = RutaMainLaunchConfigurationTab.this.getContainer(currentContainerString);
                ContainerSelectionDialog dialog = new ContainerSelectionDialog(RutaMainLaunchConfigurationTab.this.getShell(), currentContainer, false, "Select output folder");
                dialog.showClosedProjects(false);
                dialog.open();
                Object[] results = dialog.getResult();
                if (results != null && results.length > 0 && results[0] instanceof IPath) {
                    IPath path = (IPath)results[0];
                    String containerName = path.toOSString();
                    RutaMainLaunchConfigurationTab.this.outputFolderText.setText(containerName);
                }
            }
        });
    }

    private IContainer getContainer(String path) {
        Path containerPath = new Path(path);
        IResource resource = this.getWorkspaceRoot().findMember((IPath)containerPath);
        if (resource instanceof IContainer) {
            return (IContainer)resource;
        }
        return null;
    }

    public void doInitializeForm(ILaunchConfiguration config) {
        super.doInitializeForm(config);
        IScriptProject proj = null;
        try {
            proj = AbstractScriptLaunchConfigurationDelegate.getScriptProject((ILaunchConfiguration)config);
        }
        catch (CoreException e) {
            RutaIdeUIPlugin.error(e);
        }
        String defaultInputLocation = RutaProjectUtils.getDefaultInputLocation();
        String defaultOutputLocation = RutaProjectUtils.getDefaultOutputLocation();
        IResource defaultInputFolder = proj.getProject().findMember(defaultInputLocation);
        IResource defaultOutputFolder = proj.getProject().findMember(defaultOutputLocation);
        try {
            this.recursivelyButton.setSelection(config.getAttribute("org.apache.uima.ruta.ide.launching.recursive", false));
        }
        catch (CoreException e) {
            this.recursivelyButton.setSelection(false);
        }
        try {
            this.viewText.setText(config.getAttribute("org.apache.uima.ruta.ide.launching.view", "_InitialView"));
        }
        catch (CoreException e) {
            this.viewText.setText("_InitialView");
        }
        try {
            if (defaultInputFolder != null) {
                this.inputFolderText.setText(config.getAttribute("org.apache.uima.ruta.ide.launching.inputFolder", defaultInputFolder.getFullPath().toPortableString()));
            } else {
                this.inputFolderText.setText(config.getAttribute("org.apache.uima.ruta.ide.launching.inputFolder", ""));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (defaultOutputFolder != null) {
                this.outputFolderText.setText(config.getAttribute("org.apache.uima.ruta.ide.launching.outputFolder", defaultOutputFolder.getFullPath().toPortableString()));
            } else {
                this.outputFolderText.setText(config.getAttribute("org.apache.uima.ruta.ide.launching.outputFolder", ""));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void doPerformApply(ILaunchConfigurationWorkingCopy config) {
        super.doPerformApply(config);
        config.setAttribute("org.apache.uima.ruta.ide.launching.recursive", this.recursivelyButton.getSelection());
        config.setAttribute("org.apache.uima.ruta.ide.launching.view", this.viewText.getText());
        config.setAttribute("org.apache.uima.ruta.ide.launching.inputFolder", this.inputFolderText.getText());
        config.setAttribute("org.apache.uima.ruta.ide.launching.outputFolder", this.outputFolderText.getText());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        super.setDefaults(config);
        IScriptProject proj = null;
        try {
            proj = AbstractScriptLaunchConfigurationDelegate.getScriptProject((ILaunchConfiguration)config);
        }
        catch (CoreException e) {
            RutaIdeUIPlugin.error(e);
        }
        String defaultInputLocation = RutaProjectUtils.getDefaultInputLocation();
        String defaultOutputLocation = RutaProjectUtils.getDefaultOutputLocation();
        IResource inputFolder = proj.getProject().findMember(defaultInputLocation);
        IResource outputFolder = proj.getProject().findMember(defaultOutputLocation);
        config.setAttribute("org.apache.uima.ruta.ide.launching.recursive", false);
        config.setAttribute("org.apache.uima.ruta.ide.launching.inputFolder", inputFolder.getFullPath().toPortableString());
        config.setAttribute("org.apache.uima.ruta.ide.launching.outputFolder", outputFolder.getFullPath().toPortableString());
    }
}

