/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.admin.model.GetScenariosResult;
import com.github.tomakehurst.wiremock.admin.model.GetServeEventsResult;
import com.github.tomakehurst.wiremock.admin.model.ListStubMappingsResult;
import com.github.tomakehurst.wiremock.admin.model.SingleServedStubResult;
import com.github.tomakehurst.wiremock.admin.model.SingleStubMappingResult;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.FatalStartupException;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.common.ProxySettings;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.core.Container;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockApp;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.global.GlobalSettings;
import com.github.tomakehurst.wiremock.global.GlobalSettingsHolder;
import com.github.tomakehurst.wiremock.http.HttpServer;
import com.github.tomakehurst.wiremock.http.HttpServerFactory;
import com.github.tomakehurst.wiremock.http.RequestListener;
import com.github.tomakehurst.wiremock.http.StubRequestHandler;
import com.github.tomakehurst.wiremock.junit.Stubbing;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.recording.RecordSpec;
import com.github.tomakehurst.wiremock.recording.RecordSpecBuilder;
import com.github.tomakehurst.wiremock.recording.RecordingStatusResult;
import com.github.tomakehurst.wiremock.recording.SnapshotRecordResult;
import com.github.tomakehurst.wiremock.standalone.MappingsLoader;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.stubbing.StubMappingJsonRecorder;
import com.github.tomakehurst.wiremock.verification.FindNearMissesResult;
import com.github.tomakehurst.wiremock.verification.FindRequestsResult;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import com.github.tomakehurst.wiremock.verification.NearMiss;
import com.github.tomakehurst.wiremock.verification.VerificationResult;
import java.util.List;
import java.util.UUID;
import wiremock.com.google.common.base.Preconditions;

public class WireMockServer
implements Container,
Stubbing,
Admin {
    private final WireMockApp wireMockApp;
    private final StubRequestHandler stubRequestHandler;
    private final HttpServer httpServer;
    private final Notifier notifier;
    private final Options options;
    protected final WireMock client;

    public WireMockServer(Options options) {
        this.options = options;
        this.notifier = options.notifier();
        this.wireMockApp = new WireMockApp(options, this);
        this.stubRequestHandler = this.wireMockApp.buildStubRequestHandler();
        HttpServerFactory httpServerFactory = options.httpServerFactory();
        this.httpServer = httpServerFactory.buildHttpServer(options, this.wireMockApp.buildAdminRequestHandler(), this.stubRequestHandler);
        this.client = new WireMock(this.wireMockApp);
    }

    public WireMockServer(int port, Integer httpsPort, FileSource fileSource, boolean enableBrowserProxying, ProxySettings proxySettings, Notifier notifier) {
        this(WireMockConfiguration.wireMockConfig().port(port).httpsPort(httpsPort).fileSource(fileSource).enableBrowserProxying(enableBrowserProxying).proxyVia(proxySettings).notifier(notifier));
    }

    public WireMockServer(int port, FileSource fileSource, boolean enableBrowserProxying, ProxySettings proxySettings) {
        this(WireMockConfiguration.wireMockConfig().port(port).fileSource(fileSource).enableBrowserProxying(enableBrowserProxying).proxyVia(proxySettings));
    }

    public WireMockServer(int port, FileSource fileSource, boolean enableBrowserProxying) {
        this(WireMockConfiguration.wireMockConfig().port(port).fileSource(fileSource).enableBrowserProxying(enableBrowserProxying));
    }

    public WireMockServer(int port) {
        this(WireMockConfiguration.wireMockConfig().port(port));
    }

    public WireMockServer(int port, Integer httpsPort) {
        this(WireMockConfiguration.wireMockConfig().port(port).httpsPort(httpsPort));
    }

    public WireMockServer() {
        this(WireMockConfiguration.wireMockConfig());
    }

    public void loadMappingsUsing(MappingsLoader mappingsLoader) {
        this.wireMockApp.loadMappingsUsing(mappingsLoader);
    }

    public GlobalSettingsHolder getGlobalSettingsHolder() {
        return this.wireMockApp.getGlobalSettingsHolder();
    }

    public void addMockServiceRequestListener(RequestListener listener) {
        this.stubRequestHandler.addRequestListener(listener);
    }

    public void enableRecordMappings(FileSource mappingsFileSource, FileSource filesFileSource) {
        this.addMockServiceRequestListener(new StubMappingJsonRecorder(mappingsFileSource, filesFileSource, this.wireMockApp, this.options.matchingHeaders()));
        this.notifier.info("Recording mappings to " + mappingsFileSource.getPath());
    }

    public void stop() {
        this.httpServer.stop();
    }

    public void start() {
        try {
            this.httpServer.start();
        }
        catch (Exception e) {
            throw new FatalStartupException(e);
        }
    }

    @Override
    public void shutdown() {
        final WireMockServer server = this;
        Thread shutdownThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                server.stop();
            }
        });
        shutdownThread.start();
    }

    @Override
    public int port() {
        Preconditions.checkState(this.isRunning(), "Not listening on HTTP port. The WireMock server is most likely stopped");
        return this.httpServer.port();
    }

    public int httpsPort() {
        Preconditions.checkState(this.isRunning() && this.options.httpsSettings().enabled(), "Not listening on HTTPS port. Either HTTPS is not enabled or the WireMock server is stopped.");
        return this.httpServer.httpsPort();
    }

    public String url(String path) {
        int port;
        boolean https = this.options.httpsSettings().enabled();
        String protocol = https ? "https" : "http";
        int n = port = https ? this.httpsPort() : this.port();
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return String.format("%s://localhost:%d%s", protocol, port, path);
    }

    public boolean isRunning() {
        return this.httpServer.isRunning();
    }

    @Override
    public StubMapping givenThat(MappingBuilder mappingBuilder) {
        return this.client.register(mappingBuilder);
    }

    @Override
    public StubMapping stubFor(MappingBuilder mappingBuilder) {
        return this.givenThat(mappingBuilder);
    }

    @Override
    public void editStub(MappingBuilder mappingBuilder) {
        this.client.editStubMapping(mappingBuilder);
    }

    @Override
    public void removeStub(MappingBuilder mappingBuilder) {
        this.client.removeStubMapping(mappingBuilder);
    }

    @Override
    public void removeStub(StubMapping stubMapping) {
        this.client.removeStubMapping(stubMapping);
    }

    @Override
    public List<StubMapping> getStubMappings() {
        return this.client.allStubMappings().getMappings();
    }

    @Override
    public StubMapping getSingleStubMapping(UUID id) {
        return (StubMapping)this.client.getStubMapping(id).getItem();
    }

    @Override
    public void removeStubMapping(StubMapping stubMapping) {
        this.wireMockApp.removeStubMapping(stubMapping);
    }

    @Override
    public void verify(RequestPatternBuilder requestPatternBuilder) {
        this.client.verifyThat(requestPatternBuilder);
    }

    @Override
    public void verify(int count, RequestPatternBuilder requestPatternBuilder) {
        this.client.verifyThat(count, requestPatternBuilder);
    }

    @Override
    public List<LoggedRequest> findAll(RequestPatternBuilder requestPatternBuilder) {
        return this.client.find(requestPatternBuilder);
    }

    @Override
    public List<ServeEvent> getAllServeEvents() {
        return this.client.getServeEvents();
    }

    @Override
    public void setGlobalFixedDelay(int milliseconds) {
        this.client.setGlobalFixedDelayVariable(milliseconds);
    }

    @Override
    public List<LoggedRequest> findAllUnmatchedRequests() {
        return this.client.findAllUnmatchedRequests();
    }

    @Override
    public List<NearMiss> findNearMissesForAllUnmatchedRequests() {
        return this.client.findNearMissesForAllUnmatchedRequests();
    }

    @Override
    public List<NearMiss> findAllNearMissesFor(RequestPatternBuilder requestPatternBuilder) {
        return this.client.findAllNearMissesFor(requestPatternBuilder);
    }

    @Override
    public List<NearMiss> findNearMissesFor(LoggedRequest loggedRequest) {
        return this.client.findTopNearMissesFor(loggedRequest);
    }

    @Override
    public void addStubMapping(StubMapping stubMapping) {
        this.wireMockApp.addStubMapping(stubMapping);
    }

    @Override
    public void editStubMapping(StubMapping stubMapping) {
        this.wireMockApp.editStubMapping(stubMapping);
    }

    @Override
    public ListStubMappingsResult listAllStubMappings() {
        return this.wireMockApp.listAllStubMappings();
    }

    @Override
    public SingleStubMappingResult getStubMapping(UUID id) {
        return this.wireMockApp.getStubMapping(id);
    }

    @Override
    public void saveMappings() {
        this.wireMockApp.saveMappings();
    }

    @Override
    public void resetAll() {
        this.wireMockApp.resetAll();
    }

    @Override
    public void resetRequests() {
        this.wireMockApp.resetRequests();
    }

    @Override
    public void resetToDefaultMappings() {
        this.wireMockApp.resetToDefaultMappings();
    }

    @Override
    public GetServeEventsResult getServeEvents() {
        return this.wireMockApp.getServeEvents();
    }

    @Override
    public SingleServedStubResult getServedStub(UUID id) {
        return this.wireMockApp.getServedStub(id);
    }

    @Override
    public void resetScenarios() {
        this.wireMockApp.resetScenarios();
    }

    @Override
    public void resetMappings() {
        this.wireMockApp.resetMappings();
    }

    @Override
    public VerificationResult countRequestsMatching(RequestPattern requestPattern) {
        return this.wireMockApp.countRequestsMatching(requestPattern);
    }

    @Override
    public FindRequestsResult findRequestsMatching(RequestPattern requestPattern) {
        return this.wireMockApp.findRequestsMatching(requestPattern);
    }

    @Override
    public FindRequestsResult findUnmatchedRequests() {
        return this.wireMockApp.findUnmatchedRequests();
    }

    @Override
    public void updateGlobalSettings(GlobalSettings newSettings) {
        this.wireMockApp.updateGlobalSettings(newSettings);
    }

    @Override
    public FindNearMissesResult findNearMissesForUnmatchedRequests() {
        return this.wireMockApp.findNearMissesForUnmatchedRequests();
    }

    @Override
    public GetScenariosResult getAllScenarios() {
        return this.wireMockApp.getAllScenarios();
    }

    @Override
    public FindNearMissesResult findTopNearMissesFor(LoggedRequest loggedRequest) {
        return this.wireMockApp.findTopNearMissesFor(loggedRequest);
    }

    @Override
    public FindNearMissesResult findTopNearMissesFor(RequestPattern requestPattern) {
        return this.wireMockApp.findTopNearMissesFor(requestPattern);
    }

    @Override
    public void startRecording(String targetBaseUrl) {
        this.wireMockApp.startRecording(targetBaseUrl);
    }

    @Override
    public void startRecording(RecordSpec spec) {
        this.wireMockApp.startRecording(spec);
    }

    @Override
    public void startRecording(RecordSpecBuilder recordSpec) {
        this.wireMockApp.startRecording(recordSpec);
    }

    @Override
    public SnapshotRecordResult stopRecording() {
        return this.wireMockApp.stopRecording();
    }

    @Override
    public RecordingStatusResult getRecordingStatus() {
        return this.wireMockApp.getRecordingStatus();
    }

    @Override
    public SnapshotRecordResult snapshotRecord() {
        return this.wireMockApp.snapshotRecord();
    }

    @Override
    public SnapshotRecordResult snapshotRecord(RecordSpecBuilder spec) {
        return this.wireMockApp.snapshotRecord(spec);
    }

    @Override
    public SnapshotRecordResult snapshotRecord(RecordSpec spec) {
        return this.wireMockApp.snapshotRecord(spec);
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    @Override
    public void shutdownServer() {
        this.shutdown();
    }
}

