/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.jsr223;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.tinkerpop.gremlin.jsr223.AbstractGremlinPlugin;
import org.apache.tinkerpop.gremlin.jsr223.VariableResolverCustomizer;
import org.apache.tinkerpop.gremlin.language.grammar.VariableResolver;

public class VariableResolverPlugin
extends AbstractGremlinPlugin {
    private static final String NAME = "tinkerpop.variableResolver";
    public static final Map<String, Function<Map<String, Object>, VariableResolver>> VARIABLE_RESOLVERS = new HashMap<String, Function<Map<String, Object>, VariableResolver>>(){
        {
            this.put(VariableResolver.DirectVariableResolver.class.getSimpleName(), VariableResolver.DirectVariableResolver::new);
            this.put(VariableResolver.DefaultVariableResolver.class.getSimpleName(), VariableResolver.DefaultVariableResolver::new);
            this.put(VariableResolver.NoVariableResolver.class.getSimpleName(), m -> VariableResolver.NoVariableResolver.instance());
            this.put(VariableResolver.NullVariableResolver.class.getSimpleName(), m -> VariableResolver.NullVariableResolver.instance());
        }
    };

    private VariableResolverPlugin(Builder builder) {
        super(NAME, new VariableResolverCustomizer(builder.variableResolverMaker));
    }

    public static Builder build() {
        return new Builder();
    }

    public static final class Builder {
        Function<Map<String, Object>, VariableResolver> variableResolverMaker = VariableResolver.DirectVariableResolver::new;

        private Builder() {
        }

        public Builder resolver(String resolverName) {
            if (VARIABLE_RESOLVERS.containsKey(resolverName)) {
                this.variableResolverMaker = VARIABLE_RESOLVERS.get(resolverName);
            } else {
                try {
                    Class<?> clazz = Class.forName(resolverName);
                    if (VariableResolver.class.isAssignableFrom(clazz)) {
                        this.variableResolverMaker = map -> {
                            try {
                                return (VariableResolver)clazz.getConstructor(Map.class).newInstance(map);
                            }
                            catch (Exception e) {
                                throw new RuntimeException("Error instantiating VariableResolver", e);
                            }
                        };
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("VariableResolver class not found: " + resolverName, e);
                }
            }
            return this;
        }

        public VariableResolverPlugin create() {
            return new VariableResolverPlugin(this);
        }
    }
}

