/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.callback;

import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.OAuth20ResponseModeTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.OAuth20RequestParameterResolver;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20ResponseModeBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20ResponseModeFactory;
import org.pac4j.core.context.WebContext;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;

public class OAuth20InvalidAuthorizationResponseBuilder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20InvalidAuthorizationResponseBuilder.class);
    private final ServicesManager servicesManager;
    private final OAuth20RequestParameterResolver requestParameterResolver;
    private final OAuth20ResponseModeFactory responseModeFactory;

    public ModelAndView build(JEEContext context) throws Exception {
        Boolean errorWithCallBack = context.getRequestAttribute("error_with_callback").orElse(false);
        if (!errorWithCallBack.booleanValue()) {
            return OAuth20Utils.produceUnauthorizedErrorView();
        }
        String error = context.getRequestAttribute("error").orElseThrow().toString();
        String errorDescription = context.getRequestAttribute("error_description").orElse("").toString();
        String clientId = context.getRequestParameter("client_id").map(String::valueOf).orElse("");
        String redirectUri = context.getRequestParameter("redirect_uri").map(String::valueOf).orElse("");
        String state = context.getRequestParameter("state").map(String::valueOf).orElse("");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("error", error);
        if (StringUtils.isNotBlank((CharSequence)errorDescription)) {
            params.put("error_description", errorDescription);
        }
        if (StringUtils.isNotBlank((CharSequence)state)) {
            params.put("state", state);
        }
        LOGGER.debug("Redirecting to URL [{}] with params [{}] for clientId [{}]", new Object[]{redirectUri, params.keySet(), clientId});
        return this.buildResponseModelAndView(context, this.servicesManager, clientId, redirectUri, params);
    }

    public ModelAndView buildResponseModelAndView(JEEContext context, ServicesManager servicesManager, String clientId, String redirectUrl, Map<String, String> parameters) throws Exception {
        OAuth20Utils.validateRedirectUri(redirectUrl);
        OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId(servicesManager, clientId);
        OAuth20ResponseModeTypes responseType = this.requestParameterResolver.resolveResponseModeType((WebContext)context);
        OAuth20ResponseModeBuilder builder = this.responseModeFactory.getBuilder(registeredService, responseType);
        return builder.build((RegisteredService)registeredService, redirectUrl, parameters);
    }

    public boolean supports(JEEContext context) {
        return context.getRequestAttribute("error").isPresent();
    }

    @Generated
    public OAuth20InvalidAuthorizationResponseBuilder(ServicesManager servicesManager, OAuth20RequestParameterResolver requestParameterResolver, OAuth20ResponseModeFactory responseModeFactory) {
        this.servicesManager = servicesManager;
        this.requestParameterResolver = requestParameterResolver;
        this.responseModeFactory = responseModeFactory;
    }
}

