/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;

enum LogSyntaxMessages {
    ERR_BOOLEAN_LOG_SYNTAX_CANNOT_PARSE("Unable to parse the provided string as a Boolean value of either ''true'' or ''false''."),
    ERR_BOOLEAN_LOG_SYNTAX_CANNOT_PARSE_REDACTED("Unable to parse a redacted value as a Boolean."),
    ERR_BOOLEAN_LOG_SYNTAX_CANNOT_PARSE_TOKENIZED("Unable to parse a tokenized value as a Boolean."),
    ERR_DN_LOG_SYNTAX_CANNOT_PARSE("Unable to parse the value as a distinguished name."),
    ERR_DN_LOG_SYNTAX_CANNOT_PARSE_REDACTED("Unable to parse a redacted value as a distinguished name."),
    ERR_DN_LOG_SYNTAX_CANNOT_PARSE_TOKENIZED("Unable to parse a tokenized value as a distinguished name."),
    ERR_FILTER_LOG_SYNTAX_CANNOT_PARSE("Unable to parse the value as a filter."),
    ERR_FILTER_LOG_SYNTAX_CANNOT_PARSE_REDACTED("Unable to parse a redacted value as a filter."),
    ERR_FILTER_LOG_SYNTAX_CANNOT_PARSE_TOKENIZED("Unable to parse a tokenized value as a filter."),
    ERR_FP_LOG_SYNTAX_CANNOT_PARSE("Unable to parse the value as a floating-point number."),
    ERR_FP_LOG_SYNTAX_CANNOT_PARSE_REDACTED("Unable to parse a redacted value as a floating-point number."),
    ERR_FP_LOG_SYNTAX_CANNOT_PARSE_TOKENIZED("Unable to parse a tokenized value as a floating-point number."),
    ERR_GEN_TIME_LOG_SYNTAX_CANNOT_PARSE("Unable to parse the value as a timestamp in the generalized time format."),
    ERR_GEN_TIME_LOG_SYNTAX_CANNOT_PARSE_REDACTED("Unable to parse a redacted value as a timestamp in the generalized time format."),
    ERR_GEN_TIME_LOG_SYNTAX_CANNOT_PARSE_TOKENIZED("Unable to parse a tokenized value a timestamp in the generalized time format."),
    ERR_INTEGER_LOG_SYNTAX_CANNOT_PARSE("Unable to parse the value as an integer."),
    ERR_INTEGER_LOG_SYNTAX_CANNOT_PARSE_REDACTED("Unable to parse a redacted value as an integer."),
    ERR_INTEGER_LOG_SYNTAX_CANNOT_PARSE_TOKENIZED("Unable to parse a tokenized value as an integer."),
    ERR_JSON_LOG_SYNTAX_CANNOT_PARSE("Unable to parse the value as a JSON object."),
    ERR_JSON_LOG_SYNTAX_CANNOT_PARSE_REDACTED("Unable to parse a redacted value as a JSON object."),
    ERR_JSON_LOG_SYNTAX_CANNOT_PARSE_TOKENIZED("Unable to parse a tokenized value as a JSON object."),
    ERR_LOG_SYNTAX_TOKENIZE_DIGEST_ERROR("Unable to compute a ''{0}'' digest for the purpose of generating a log token."),
    ERR_RFC_3339_LOG_SYNTAX_CANNOT_PARSE("Unable to parse the value as an RFC 3339 timestamp."),
    ERR_RFC_3339_LOG_SYNTAX_CANNOT_PARSE_REDACTED("Unable to parse a redacted value as an RFC 3339 timestamp."),
    ERR_RFC_3339_LOG_SYNTAX_CANNOT_PARSE_TOKENIZED("Unable to parse a tokenized value as an RFC 3339 timestamp."),
    INFO_LOG_SYNTAX_TRUNCATED_1_CHAR("'{'1 more character'}'"),
    INFO_LOG_SYNTAX_TRUNCATED_CHARS("'{'{0,number,0} more characters'}'");

    private static final boolean IS_WITHIN_UNIT_TESTS;
    private static final Object[] NO_ARGS;
    private static final ResourceBundle RESOURCE_BUNDLE;
    private static final ConcurrentHashMap<LogSyntaxMessages, String> MESSAGE_STRINGS;
    private static final ConcurrentHashMap<LogSyntaxMessages, MessageFormat> MESSAGES;
    private final String defaultText;

    private LogSyntaxMessages(String defaultText) {
        this.defaultText = defaultText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get() {
        String formattedMessage;
        MessageFormat f = MESSAGES.get((Object)this);
        if (f == null) {
            if (RESOURCE_BUNDLE == null) {
                f = new MessageFormat(this.defaultText);
            } else {
                try {
                    f = new MessageFormat(RESOURCE_BUNDLE.getString(this.name()));
                }
                catch (Exception e) {
                    f = new MessageFormat(this.defaultText);
                }
            }
            MESSAGES.putIfAbsent(this, f);
        }
        MessageFormat messageFormat = f;
        synchronized (messageFormat) {
            formattedMessage = f.format(NO_ARGS);
        }
        if (IS_WITHIN_UNIT_TESTS && (formattedMessage.contains("{0}") || formattedMessage.contains("{0,number,0}") || formattedMessage.contains("{1}") || formattedMessage.contains("{1,number,0}") || formattedMessage.contains("{2}") || formattedMessage.contains("{2,number,0}") || formattedMessage.contains("{3}") || formattedMessage.contains("{3,number,0}") || formattedMessage.contains("{4}") || formattedMessage.contains("{4,number,0}") || formattedMessage.contains("{5}") || formattedMessage.contains("{5,number,0}") || formattedMessage.contains("{6}") || formattedMessage.contains("{6,number,0}") || formattedMessage.contains("{7}") || formattedMessage.contains("{7,number,0}") || formattedMessage.contains("{8}") || formattedMessage.contains("{8,number,0}") || formattedMessage.contains("{9}") || formattedMessage.contains("{9,number,0}") || formattedMessage.contains("{10}") || formattedMessage.contains("{10,number,0}"))) {
            throw new IllegalArgumentException("Message " + ((Object)((Object)this)).getClass().getName() + '.' + this.name() + " contains an un-replaced token:  " + formattedMessage);
        }
        return formattedMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(Object ... args) {
        String formattedMessage;
        MessageFormat f = MESSAGES.get((Object)this);
        if (f == null) {
            if (RESOURCE_BUNDLE == null) {
                f = new MessageFormat(this.defaultText);
            } else {
                try {
                    f = new MessageFormat(RESOURCE_BUNDLE.getString(this.name()));
                }
                catch (Exception e) {
                    f = new MessageFormat(this.defaultText);
                }
            }
            MESSAGES.putIfAbsent(this, f);
        }
        MessageFormat messageFormat = f;
        synchronized (messageFormat) {
            formattedMessage = f.format(args);
        }
        if (IS_WITHIN_UNIT_TESTS && (formattedMessage.contains("{0}") || formattedMessage.contains("{0,number,0}") || formattedMessage.contains("{1}") || formattedMessage.contains("{1,number,0}") || formattedMessage.contains("{2}") || formattedMessage.contains("{2,number,0}") || formattedMessage.contains("{3}") || formattedMessage.contains("{3,number,0}") || formattedMessage.contains("{4}") || formattedMessage.contains("{4,number,0}") || formattedMessage.contains("{5}") || formattedMessage.contains("{5,number,0}") || formattedMessage.contains("{6}") || formattedMessage.contains("{6,number,0}") || formattedMessage.contains("{7}") || formattedMessage.contains("{7,number,0}") || formattedMessage.contains("{8}") || formattedMessage.contains("{8,number,0}") || formattedMessage.contains("{9}") || formattedMessage.contains("{9,number,0}") || formattedMessage.contains("{10}") || formattedMessage.contains("{10,number,0}"))) {
            throw new IllegalArgumentException("Message " + ((Object)((Object)this)).getClass().getName() + '.' + this.name() + " contains an un-replaced token:  " + formattedMessage);
        }
        return formattedMessage;
    }

    public String toString() {
        String s = MESSAGE_STRINGS.get((Object)this);
        if (s == null) {
            if (RESOURCE_BUNDLE == null) {
                s = this.defaultText;
            } else {
                try {
                    s = RESOURCE_BUNDLE.getString(this.name());
                }
                catch (Exception e) {
                    s = this.defaultText;
                }
                MESSAGE_STRINGS.putIfAbsent(this, s);
            }
        }
        return s;
    }

    static {
        IS_WITHIN_UNIT_TESTS = Boolean.getBoolean("com.unboundid.ldap.sdk.RunningUnitTests") || Boolean.getBoolean("com.unboundid.directory.server.RunningUnitTests");
        NO_ARGS = new Object[0];
        ResourceBundle rb = null;
        try {
            rb = ResourceBundle.getBundle("unboundid-ldapsdk-log-syntax");
        }
        catch (Exception exception) {
            // empty catch block
        }
        RESOURCE_BUNDLE = rb;
        MESSAGE_STRINGS = new ConcurrentHashMap(100);
        MESSAGES = new ConcurrentHashMap(100);
    }
}

