/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.transport.netty;

import io.netty.buffer.ByteBuf;
import org.ldaptive.asn1.DERBuffer;

final class NettyDERBuffer
implements DERBuffer {
    private final ByteBuf buffer;

    NettyDERBuffer(ByteBuf buf) {
        this(buf, 0, buf.capacity());
    }

    NettyDERBuffer(ByteBuf buf, int pos, int lim) {
        this.buffer = buf;
        this.buffer.setIndex(pos, lim);
    }

    @Override
    public int position() {
        return this.buffer.readerIndex();
    }

    @Override
    public DERBuffer position(int newPosition) {
        try {
            this.buffer.readerIndex(newPosition);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(e);
        }
        return this;
    }

    @Override
    public int limit() {
        return this.buffer.writerIndex();
    }

    @Override
    public int capacity() {
        return this.buffer.capacity();
    }

    @Override
    public DERBuffer limit(int newLimit) {
        try {
            this.buffer.writerIndex(newLimit);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(e);
        }
        return this;
    }

    @Override
    public DERBuffer positionAndLimit(int newPosition, int newLimit) {
        if (newPosition > newLimit) {
            throw new IllegalArgumentException("newPosition must be less than or equal to newLimit");
        }
        try {
            if (newPosition > this.buffer.writerIndex()) {
                this.buffer.writerIndex(newLimit).readerIndex(newPosition);
            } else {
                this.buffer.readerIndex(newPosition).writerIndex(newLimit);
            }
            return this;
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public DERBuffer clear() {
        this.buffer.setIndex(0, this.buffer.capacity());
        return this;
    }

    @Override
    public byte get() {
        return this.buffer.readByte();
    }

    @Override
    public DERBuffer get(byte[] dst) {
        this.buffer.readBytes(dst);
        return this;
    }

    @Override
    public DERBuffer slice() {
        return new NettyDERBuffer(this.buffer.slice(this.position(), this.remaining()));
    }

    public String toString() {
        return this.getClass().getName() + "@" + this.hashCode() + "::pos=" + this.position() + ", lim=" + this.limit() + ", cap=" + this.capacity();
    }
}

