/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.soap;

import net.tirasa.connid.bundles.soap.WebServiceConfiguration;
import net.tirasa.connid.bundles.soap.cxf.ForceSoapActionOutInterceptor;
import net.tirasa.connid.bundles.soap.provisioning.interfaces.Provisioning;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.identityconnectors.common.logging.Log;

public class WebServiceConnection {
    private static final Log LOG = Log.getLog(WebServiceConnection.class);
    private static final String SUCCESS = "OK";
    private static Bus bus = null;
    private Provisioning provisioning;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownBus() {
        Log log = LOG;
        synchronized (log) {
            if (bus != null) {
                bus.shutdown(true);
                BusFactory.clearDefaultBusForAnyThread((Bus)bus);
                bus = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebServiceConnection(WebServiceConfiguration configuration) {
        boolean isValidConf = false;
        try {
            configuration.validate();
            isValidConf = true;
        }
        catch (IllegalArgumentException e) {
            LOG.error((Throwable)e, "Invalid configuration", new Object[0]);
        }
        if (!isValidConf) {
            return;
        }
        Class<?> serviceClass = null;
        try {
            serviceClass = Class.forName(configuration.getServicename());
        }
        catch (ClassNotFoundException e) {
            LOG.error((Throwable)e, "Provisioning class " + configuration.getServicename() + " not found", new Object[0]);
        }
        if (serviceClass == null) {
            return;
        }
        Log e = LOG;
        synchronized (e) {
            if (bus == null) {
                bus = BusFactory.newInstance().createBus();
                BusFactory.setDefaultBus((Bus)bus);
                BusFactory.setThreadDefaultBus((Bus)bus);
            }
        }
        JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        factory.setBus(bus);
        factory.setServiceClass(serviceClass);
        factory.setAddress(configuration.getEndpoint());
        factory.getOutInterceptors().add(new ForceSoapActionOutInterceptor(configuration.getSoapActionUriPrefix()));
        this.provisioning = (Provisioning)factory.create(Provisioning.class);
        try {
            Client client = ClientProxy.getClient((Object)this.provisioning);
            if (client != null) {
                HTTPConduit conduit = (HTTPConduit)client.getConduit();
                HTTPClientPolicy policy = conduit.getClient();
                policy.setConnectionTimeout(Long.parseLong(configuration.getConnectionTimeout()) * 1000L);
                policy.setReceiveTimeout(Long.parseLong(configuration.getReceiveTimeout()) * 1000L);
            }
        }
        catch (Throwable t) {
            LOG.error(t, "Unknown exception", new Object[0]);
        }
    }

    public void dispose() {
        this.provisioning = null;
    }

    public void test() {
        if (this.provisioning == null) {
            throw new IllegalStateException("Service port not found.");
        }
        String res = this.provisioning.checkAlive();
        if (!SUCCESS.equals(res)) {
            throw new IllegalStateException("Invalid response.");
        }
    }

    public Provisioning getProvisioning() {
        return this.provisioning;
    }
}

