/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.duo.authn;

import java.util.ArrayList;
import java.util.List;
import javax.security.auth.login.FailedLoginException;
import lombok.Generated;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityAuthenticationResult;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityAuthenticationService;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityDirectCredential;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityMultifactorAuthenticationProvider;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityPasscodeCredential;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityUniversalPromptCredential;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.MultifactorAuthenticationCredential;
import org.apereo.cas.authentication.MultifactorAuthenticationHandler;
import org.apereo.cas.authentication.MultifactorAuthenticationPrincipalResolver;
import org.apereo.cas.authentication.handler.support.AbstractPreAndPostProcessingAuthenticationHandler;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.monitor.Monitorable;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;

@Monitorable
public class DuoSecurityAuthenticationHandler
extends AbstractPreAndPostProcessingAuthenticationHandler
implements MultifactorAuthenticationHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DuoSecurityAuthenticationHandler.class);
    private final ObjectProvider<? extends DuoSecurityMultifactorAuthenticationProvider> multifactorAuthenticationProvider;
    private final List<MultifactorAuthenticationPrincipalResolver> multifactorAuthenticationPrincipalResolver;

    public DuoSecurityAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory, ObjectProvider<DuoSecurityMultifactorAuthenticationProvider> multifactorAuthenticationProvider, Integer order, List<MultifactorAuthenticationPrincipalResolver> multifactorAuthenticationPrincipalResolver) {
        super(name, servicesManager, principalFactory, order);
        this.multifactorAuthenticationProvider = multifactorAuthenticationProvider;
        this.multifactorAuthenticationPrincipalResolver = multifactorAuthenticationPrincipalResolver;
    }

    public boolean supports(Credential credential) {
        if (credential instanceof MultifactorAuthenticationCredential) {
            MultifactorAuthenticationCredential mfaCredential = (MultifactorAuthenticationCredential)credential;
            String id = mfaCredential.getProviderId();
            return ((DuoSecurityMultifactorAuthenticationProvider)this.multifactorAuthenticationProvider.getObject()).matches(id);
        }
        return false;
    }

    protected AuthenticationHandlerExecutionResult doAuthentication(Credential credential, Service service) throws Exception {
        if (credential instanceof DuoSecurityPasscodeCredential) {
            DuoSecurityPasscodeCredential duo = (DuoSecurityPasscodeCredential)credential;
            LOGGER.debug("Attempting to authenticate credential via Duo Security passcode");
            return this.authenticateDuoPasscodeCredential(duo);
        }
        if (credential instanceof DuoSecurityUniversalPromptCredential) {
            DuoSecurityUniversalPromptCredential duo = (DuoSecurityUniversalPromptCredential)credential;
            LOGGER.debug("Attempting to authenticate credential via Duo Security universal prompt");
            return this.authenticateDuoUniversalPromptCredential(duo);
        }
        if (credential instanceof DuoSecurityDirectCredential) {
            DuoSecurityDirectCredential duo = (DuoSecurityDirectCredential)credential;
            LOGGER.debug("Attempting to directly authenticate credential against Duo");
            return this.authenticateDuoApiCredential(duo);
        }
        throw new FailedLoginException("Unknown Duo Security authentication attempt");
    }

    protected Principal resolvePrincipal(Principal principal) {
        return this.multifactorAuthenticationPrincipalResolver.stream().filter(resolver -> resolver.supports(principal)).findFirst().map(resolver -> resolver.resolve(principal)).orElseThrow(() -> new IllegalStateException("Unable to resolve principal for Duo Security multifactor authentication"));
    }

    private AuthenticationHandlerExecutionResult authenticateDuoPasscodeCredential(DuoSecurityPasscodeCredential credential) throws Exception {
        try {
            DuoSecurityAuthenticationService duoAuthenticationService = ((DuoSecurityMultifactorAuthenticationProvider)this.multifactorAuthenticationProvider.getObject()).getDuoAuthenticationService();
            if (duoAuthenticationService.authenticate((Credential)credential).isSuccess()) {
                Principal principal = this.principalFactory.createPrincipal(credential.getId());
                return this.createHandlerResult((Credential)credential, principal, new ArrayList());
            }
        }
        catch (Throwable e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
        throw new FailedLoginException("Duo Security passcode authentication has failed");
    }

    private AuthenticationHandlerExecutionResult authenticateDuoUniversalPromptCredential(DuoSecurityUniversalPromptCredential credential) throws Exception {
        try {
            DuoSecurityAuthenticationService duoAuthenticationService = ((DuoSecurityMultifactorAuthenticationProvider)this.multifactorAuthenticationProvider.getObject()).getDuoAuthenticationService();
            DuoSecurityAuthenticationResult result = duoAuthenticationService.authenticate((Credential)credential);
            if (result.isSuccess()) {
                Principal principal = this.principalFactory.createPrincipal(result.getUsername(), result.getAttributes());
                LOGGER.debug("Duo Security Universal Prompt has successfully authenticated [{}]", (Object)principal.getId());
                return this.createHandlerResult((Credential)credential, principal, new ArrayList());
            }
        }
        catch (Throwable e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
        throw new FailedLoginException("Duo Security universal prompt authentication has failed");
    }

    private AuthenticationHandlerExecutionResult authenticateDuoApiCredential(DuoSecurityDirectCredential credential) throws FailedLoginException {
        try {
            DuoSecurityAuthenticationService duoAuthenticationService = ((DuoSecurityMultifactorAuthenticationProvider)this.multifactorAuthenticationProvider.getObject()).getDuoAuthenticationService();
            if (duoAuthenticationService.authenticate((Credential)credential).isSuccess()) {
                Principal principal = this.resolvePrincipal(credential.getPrincipal());
                LOGGER.debug("Duo Security has successfully authenticated [{}]", (Object)principal.getId());
                return this.createHandlerResult((Credential)credential, principal, new ArrayList());
            }
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
        throw new FailedLoginException("Duo Security authentication has failed");
    }

    @Generated
    public ObjectProvider<? extends DuoSecurityMultifactorAuthenticationProvider> getMultifactorAuthenticationProvider() {
        return this.multifactorAuthenticationProvider;
    }
}

