/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.aup;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.aup.AcceptableUsagePolicyStatus;
import org.apereo.cas.aup.BaseAcceptableUsagePolicyRepository;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.model.support.aup.AcceptableUsagePolicyProperties;
import org.apereo.cas.configuration.support.TriStateBoolean;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.webflow.execution.RequestContext;

public class DefaultAcceptableUsagePolicyRepository
extends BaseAcceptableUsagePolicyRepository {
    private static final long serialVersionUID = -3059445754626980894L;
    private static final String AUP_ACCEPTED = "AUP_ACCEPTED";
    private final Map<String, Boolean> policyMap = new ConcurrentHashMap<String, Boolean>();

    public DefaultAcceptableUsagePolicyRepository(TicketRegistrySupport ticketRegistrySupport, AcceptableUsagePolicyProperties aupProperties) {
        super(ticketRegistrySupport, aupProperties);
    }

    @Override
    public AcceptableUsagePolicyStatus verify(RequestContext requestContext) throws Throwable {
        AcceptableUsagePolicyStatus status = super.verify(requestContext);
        if (status.isDenied()) {
            Pair<String, Map> storageInfo = this.getKeyAndMap(requestContext);
            String key = (String)storageInfo.getLeft();
            Map map = (Map)storageInfo.getRight();
            Authentication authentication = WebUtils.getAuthentication((RequestContext)requestContext);
            Principal principal = authentication.getPrincipal();
            if (map.containsKey(key)) {
                boolean accepted = map.getOrDefault(key, Boolean.FALSE) != false || this.isUsagePolicyAcceptedBy(principal);
                return new AcceptableUsagePolicyStatus(TriStateBoolean.fromBoolean((boolean)accepted), principal);
            }
            return AcceptableUsagePolicyStatus.denied(principal);
        }
        return status;
    }

    @Override
    public boolean submit(RequestContext requestContext) {
        Pair<String, Map> storageInfo = this.getKeyAndMap(requestContext);
        String key = (String)storageInfo.getLeft();
        Map map = (Map)storageInfo.getRight();
        map.put(key, Boolean.TRUE);
        return map.containsKey(key);
    }

    private Pair<String, Map> getKeyAndMap(RequestContext requestContext) {
        switch (this.aupProperties.getInMemory().getScope()) {
            case GLOBAL: {
                Principal principal = WebUtils.getAuthentication((RequestContext)requestContext).getPrincipal();
                return Pair.of((Object)principal.getId(), this.policyMap);
            }
        }
        return Pair.of((Object)AUP_ACCEPTED, (Object)requestContext.getFlowScope().asMap());
    }
}

