/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.api.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.apache.syncope.core.provisioning.api.serialization.AbstractValueDeserializer;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.ConnectorObjectIdentification;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.Uid;

public class ConnectorObjectIdentificationDeserializer
extends AbstractValueDeserializer<ConnectorObjectIdentification> {
    public ConnectorObjectIdentification deserialize(JsonParser jp, DeserializationContext deserializationContext) throws IOException {
        ObjectNode tree = (ObjectNode)jp.readValueAsTree();
        String objectClass = tree.get("objectClass").asText();
        HashSet attributes = new HashSet();
        JsonNode attributesNode = tree.get("attributes");
        if (attributesNode != null && attributesNode.isArray()) {
            attributesNode.forEach(attrNode -> {
                try {
                    String name = attrNode.get("name").asText();
                    List<Object> values = this.doDeserialize(attrNode.get("value"), jp);
                    attributes.add(Uid.NAME.equals(name) ? new Uid(values.isEmpty() || values.getFirst() == null ? null : values.getFirst().toString()) : (Name.NAME.equals(name) ? new Name(values.isEmpty() || values.getFirst() == null ? null : values.getFirst().toString()) : AttributeBuilder.build((String)name, values)));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
        return new ConnectorObjectIdentification(new ObjectClass(objectClass), attributes);
    }
}

