/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.expiration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import lombok.Generated;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicketAwareTicket;
import org.apereo.cas.ticket.expiration.AbstractCasExpirationPolicy;
import org.apereo.cas.util.DateTimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public class FixedInstantExpirationPolicy
extends AbstractCasExpirationPolicy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(FixedInstantExpirationPolicy.class);
    private static final long serialVersionUID = 6728077010285422290L;
    @JsonProperty
    private Instant expirationInstant;

    @Override
    public boolean isExpired(TicketGrantingTicketAwareTicket ticketState) {
        ZonedDateTime expiringTime = this.toMaximumExpirationTime((Ticket)ticketState);
        ZonedDateTime now = ZonedDateTime.now(this.getClock());
        return expiringTime.isBefore(now);
    }

    @JsonIgnore
    public Long getTimeToLive() {
        Instant currentTime = ZonedDateTime.now(this.getClock()).toInstant();
        return Duration.between(currentTime, this.expirationInstant).toSeconds();
    }

    @JsonIgnore
    public ZonedDateTime toMaximumExpirationTime(Ticket ticketState) {
        return DateTimeUtils.zonedDateTimeOf((Instant)this.expirationInstant);
    }

    @Generated
    public FixedInstantExpirationPolicy() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FixedInstantExpirationPolicy)) {
            return false;
        }
        FixedInstantExpirationPolicy other = (FixedInstantExpirationPolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Instant this$expirationInstant = this.expirationInstant;
        Instant other$expirationInstant = other.expirationInstant;
        return !(this$expirationInstant == null ? other$expirationInstant != null : !((Object)this$expirationInstant).equals(other$expirationInstant));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FixedInstantExpirationPolicy;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Instant $expirationInstant = this.expirationInstant;
        result = result * 59 + ($expirationInstant == null ? 43 : ((Object)$expirationInstant).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "FixedInstantExpirationPolicy(super=" + super.toString() + ", expirationInstant=" + String.valueOf(this.expirationInstant) + ")";
    }

    @Generated
    public FixedInstantExpirationPolicy(Instant expirationInstant) {
        this.expirationInstant = expirationInstant;
    }

    @Generated
    public FixedInstantExpirationPolicy withExpirationInstant(Instant expirationInstant) {
        return this.expirationInstant == expirationInstant ? this : new FixedInstantExpirationPolicy(expirationInstant);
    }

    @JsonProperty
    @Generated
    public void setExpirationInstant(Instant expirationInstant) {
        this.expirationInstant = expirationInstant;
    }

    @Generated
    public Instant getExpirationInstant() {
        return this.expirationInstant;
    }
}

