/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.asyncexecutor;

import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandConfig;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandContextCloseListener;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.job.api.Job;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.event.impl.FlowableJobEventBuilder;
import org.flowable.job.service.impl.asyncexecutor.FailedJobCommandFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailedJobListener
implements CommandContextCloseListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(FailedJobListener.class);
    protected CommandExecutor commandExecutor;
    protected Job job;
    protected JobServiceConfiguration jobServiceConfiguration;

    public FailedJobListener(CommandExecutor commandExecutor, Job job, JobServiceConfiguration jobServiceConfiguration) {
        this.commandExecutor = commandExecutor;
        this.job = job;
        this.jobServiceConfiguration = jobServiceConfiguration;
    }

    public void closing(CommandContext commandContext) {
    }

    public void afterSessionsFlush(CommandContext commandContext) {
    }

    public void closed(CommandContext context) {
        FlowableEventDispatcher eventDispatcher = this.jobServiceConfiguration.getEventDispatcher();
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableJobEventBuilder.createEntityEvent(FlowableEngineEventType.JOB_EXECUTION_SUCCESS, this.job), this.jobServiceConfiguration.getEngineName());
        }
    }

    public void closeFailure(CommandContext commandContext) {
        FlowableEventDispatcher eventDispatcher = this.jobServiceConfiguration.getEventDispatcher();
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableJobEventBuilder.createEntityExceptionEvent(FlowableEngineEventType.JOB_EXECUTION_FAILURE, this.job, commandContext.getException()), this.jobServiceConfiguration.getEngineName());
        }
        CommandConfig commandConfig = this.commandExecutor.getDefaultConfig().transactionRequiresNew();
        FailedJobCommandFactory failedJobCommandFactory = this.jobServiceConfiguration.getFailedJobCommandFactory();
        Command<Object> cmd = failedJobCommandFactory.getCommand(this.job.getId(), commandContext.getException());
        LOGGER.trace("Using FailedJobCommandFactory '{}' and command of type '{}'", failedJobCommandFactory.getClass(), (Object)cmd.getClass());
        this.commandExecutor.execute(commandConfig, cmd);
    }

    public Integer order() {
        return 20;
    }

    public boolean multipleAllowed() {
        return true;
    }
}

