/*
 * Decompiled with CFR 0.152.
 */
package nz.net.ultraq.thymeleaf.layoutdialect.internal;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import nz.net.ultraq.thymeleaf.layoutdialect.models.extensions.IModelExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.ElementDefinitions;
import org.thymeleaf.engine.HTMLElementDefinition;
import org.thymeleaf.engine.HTMLElementType;
import org.thymeleaf.model.AttributeValueQuotes;
import org.thymeleaf.model.IModel;
import org.thymeleaf.model.IModelFactory;
import org.thymeleaf.model.ITemplateEvent;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.util.StringUtils;

public class ModelBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ModelBuilder.class);
    private static final Set<String> encounteredVoidTags = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ElementDefinitions elementDefinitions;
    private final IModelFactory modelFactory;
    private final TemplateMode templateMode;

    public ModelBuilder(ITemplateContext iTemplateContext) {
        this(iTemplateContext.getModelFactory(), iTemplateContext.getConfiguration().getElementDefinitions(), iTemplateContext.getTemplateMode());
    }

    public ModelBuilder(IModelFactory iModelFactory, ElementDefinitions elementDefinitions, TemplateMode templateMode) {
        this.modelFactory = iModelFactory;
        this.elementDefinitions = elementDefinitions;
        this.templateMode = templateMode;
    }

    public IModel createNode(String string) {
        return this.createNode(string, null, null);
    }

    public IModel createNode(String string, String string2) {
        return this.createNode(string, null, string2);
    }

    public IModel createNode(String string, Map<String, String> map) {
        return this.createNode(string, map, null);
    }

    public IModel createNode(String string, Map<String, String> map, String string2) {
        Objects.requireNonNull(string);
        IModel iModel = this.modelFactory.createModel();
        HTMLElementDefinition hTMLElementDefinition = (HTMLElementDefinition)this.elementDefinitions.forName(this.templateMode, string);
        if (hTMLElementDefinition.getType() == HTMLElementType.VOID) {
            if (map != null && map.containsKey("standalone")) {
                map.remove("standalone");
                iModel.add((ITemplateEvent)this.modelFactory.createStandaloneElementTag(string, map, AttributeValueQuotes.DOUBLE, false, true));
            } else if (map != null && map.containsKey("void")) {
                map.remove("void");
                iModel.add((ITemplateEvent)this.modelFactory.createStandaloneElementTag(string, map, AttributeValueQuotes.DOUBLE, false, false));
            } else {
                if (encounteredVoidTags.add(string)) {
                    logger.warn("Instructed to write a closing tag {} for an HTML void element.  This might cause processing errors further down the track.  To avoid this, either self close the opening element, remove the closing tag, or process this template using the XML processing mode.  See https://html.spec.whatwg.org/multipage/syntax.html#void-elements for more information on HTML void elements.", (Object)string);
                }
                iModel.add((ITemplateEvent)this.modelFactory.createStandaloneElementTag(string, map, AttributeValueQuotes.DOUBLE, false, false));
                iModel.add((ITemplateEvent)this.modelFactory.createCloseElementTag(string, false, true));
            }
        } else if (map != null && map.containsKey("standalone")) {
            map.remove("standalone");
            iModel.add((ITemplateEvent)this.modelFactory.createStandaloneElementTag(string, map, AttributeValueQuotes.DOUBLE, false, true));
        } else {
            iModel.add((ITemplateEvent)this.modelFactory.createOpenElementTag(string, map, AttributeValueQuotes.DOUBLE, false));
            if (!StringUtils.isEmpty((String)string2)) {
                iModel.add((ITemplateEvent)this.modelFactory.createText((CharSequence)string2));
            }
            iModel.add((ITemplateEvent)this.modelFactory.createCloseElementTag(string));
        }
        return iModel;
    }

    public void nodeCompleted(@Nullable IModel iModel, @Nullable IModel iModel2) {
        if (IModelExtensions.asBoolean(iModel)) {
            iModel.insertModel(iModel.size() - 1, iModel2);
        }
    }

    public void setParent(IModel iModel, IModel iModel2) {
    }
}

