/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authorization;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authorization.BaseUseAttributesAuthorizationGenerator;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LdapUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.ldaptive.LdapEntry;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class LdapUserGroupsToRolesAuthorizationGenerator
extends BaseUseAttributesAuthorizationGenerator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapUserGroupsToRolesAuthorizationGenerator.class);
    private final String groupAttributeName;
    private final String groupPrefix;
    private final SearchOperation groupSearchOperation;

    public LdapUserGroupsToRolesAuthorizationGenerator(SearchOperation userSearchOperation, boolean allowMultipleResults, String groupAttributeName, String groupPrefix, SearchOperation groupSearchOperation) {
        super(userSearchOperation, allowMultipleResults);
        this.groupAttributeName = groupAttributeName;
        this.groupPrefix = groupPrefix;
        this.groupSearchOperation = groupSearchOperation;
    }

    @Override
    protected List<SimpleGrantedAuthority> generateAuthorizationForLdapEntry(Principal profile, LdapEntry userEntry) {
        LOGGER.debug("Attempting to get roles for user [{}].", (Object)userEntry.getDn());
        SearchResponse response = (SearchResponse)FunctionUtils.doUnchecked(() -> this.groupSearchOperation.execute(LdapUtils.newLdaptiveSearchFilter(this.groupSearchOperation.getTemplate().getFilter(), "user", (List<String>)CollectionUtils.wrap((Object)userEntry.getDn()))));
        LOGGER.debug("LDAP role search response: [{}]", (Object)response);
        return response.getEntries().stream().map(entry -> entry.getAttribute(this.groupAttributeName)).filter(Objects::nonNull).map(attribute -> attribute.getStringValues().stream().map(entry -> entry.toUpperCase(Locale.ENGLISH)).map(role -> StringUtils.prependIfMissing((String)role, (CharSequence)this.groupPrefix, (CharSequence[])new CharSequence[0])).collect(Collectors.toList())).flatMap(Collection::stream).map(SimpleGrantedAuthority::new).collect(Collectors.toList());
    }
}

